/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.external;

import ghidra.app.util.bin.format.dwarf4.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf4.external.SearchLocation;
import ghidra.app.util.bin.format.dwarf4.external.SearchLocationCreatorContext;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class BuildIdSearchLocation
implements SearchLocation {
    private static final String BUILD_ID_PREFIX = "build-id://";
    private final File rootDir;

    public static boolean isBuildIdSearchLocation(String locString) {
        return locString.startsWith(BUILD_ID_PREFIX);
    }

    public static BuildIdSearchLocation create(String locString, SearchLocationCreatorContext context) {
        locString = locString.substring(BUILD_ID_PREFIX.length());
        return new BuildIdSearchLocation(new File(locString));
    }

    public BuildIdSearchLocation(File rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public String getName() {
        return BUILD_ID_PREFIX + this.rootDir.getPath();
    }

    @Override
    public String getDescriptiveName() {
        return this.rootDir.getPath() + " (build-id)";
    }

    @Override
    public FSRL findDebugFile(ExternalDebugInfo debugInfo, TaskMonitor monitor) throws IOException, CancelledException {
        String hash = NumericUtilities.convertBytesToString((byte[])debugInfo.getHash());
        if (hash == null || hash.length() < 4) {
            return null;
        }
        File bucketDir = new File(this.rootDir, hash.substring(0, 2));
        File file = new File(bucketDir, hash.substring(2) + ".debug");
        return file.isFile() ? FileSystemService.getInstance().getLocalFSRL(file) : null;
    }
}

