/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.gui;

import docking.options.editor.StringWithChoicesEditor;
import docking.widgets.OptionDialog;
import ghidra.docking.util.DockingWindowsLookAndFeelUtils;
import ghidra.framework.main.FrontEndOnly;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.beans.PropertyEditor;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Support", shortDescription="Sets the GUI look and feel", description="Adds a Tool Option to allow the user to adjust the GUI look and feel settings. Ghidra may have to be restarted to see the effect. This plugin is available only in the Ghidra Project Window.")
public class LookAndFeelPlugin
extends Plugin
implements FrontEndOnly,
OptionsChangeListener {
    private String selectedLookAndFeel;
    private boolean useInvertedColors;
    public static final String LOOK_AND_FEEL_NAME = "Swing Look And Feel";
    private static final String USE_INVERTED_COLORS_NAME = "Use Inverted Colors";
    private static final String OPTIONS_TITLE = "Tool";
    private static boolean issuedLafNotification;
    private static boolean issuedPreferredDarkThemeLafNotification;

    public LookAndFeelPlugin(PluginTool tool) {
        super(tool);
        SystemUtilities.assertTrue((boolean)(tool instanceof FrontEndTool), (String)"Plugin added to the wrong type of tool");
        this.initLookAndFeelOptions();
    }

    private void initLookAndFeelOptions() {
        ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
        this.selectedLookAndFeel = DockingWindowsLookAndFeelUtils.getInstalledLookAndFeelName();
        List lookAndFeelNames = DockingWindowsLookAndFeelUtils.getLookAndFeelNames();
        opt.registerOption(LOOK_AND_FEEL_NAME, OptionType.STRING_TYPE, (Object)this.selectedLookAndFeel, new HelpLocation(OPTIONS_TITLE, "Look_And_Feel"), "Set the look and feel for Ghidra.  After you change the look and feel, you will have to restart Ghidra to see the effect.", (PropertyEditor)new StringWithChoicesEditor(lookAndFeelNames));
        this.selectedLookAndFeel = opt.getString(LOOK_AND_FEEL_NAME, this.selectedLookAndFeel);
        this.useInvertedColors = DockingWindowsLookAndFeelUtils.getUseInvertedColorsPreference();
        opt.registerOption(USE_INVERTED_COLORS_NAME, OptionType.BOOLEAN_TYPE, (Object)this.useInvertedColors, new HelpLocation(OPTIONS_TITLE, "Use_Inverted_Colors"), "Indicates to invert all drawn colors.   This provides the ability to create an effective 'Dark Theme' appearance.  (Note: you may have to change your Look and Feel to achieve the best rendering.)\n\n<FONT SIZE='7'><B>PROTOTYPE</B></FONT> - This feature is an example prototype and contains many known rendering issues that cause some widgets to be <U>unreadable</U>.");
        this.useInvertedColors = opt.getBoolean(USE_INVERTED_COLORS_NAME, this.useInvertedColors);
        opt.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(LOOK_AND_FEEL_NAME)) {
            String newLookAndFeel = (String)newValue;
            if (!newLookAndFeel.equals(this.selectedLookAndFeel)) {
                this.issueLaFNotification();
            }
            this.saveLookAndFeel((String)newValue);
        }
        if (optionName.equals(USE_INVERTED_COLORS_NAME)) {
            boolean newUseInvertedColors = (Boolean)newValue;
            if (newUseInvertedColors != this.useInvertedColors) {
                this.issueLaFNotification();
            }
            this.useInvertedColors = newUseInvertedColors;
            Preferences.setProperty((String)"LookAndFeel.UseInvertedColors", (String)Boolean.toString(this.useInvertedColors));
            Preferences.store();
            if (this.useInvertedColors) {
                this.issuePreferredDarkThemeLaFNotification();
            }
        }
    }

    private void saveLookAndFeel(String lookAndFeelName) {
        this.selectedLookAndFeel = lookAndFeelName;
        Preferences.setProperty((String)"LastLookAndFeel", (String)this.selectedLookAndFeel);
        Preferences.store();
    }

    private void issuePreferredDarkThemeLaFNotification() {
        if (issuedPreferredDarkThemeLafNotification) {
            return;
        }
        issuedPreferredDarkThemeLafNotification = true;
        if ("Metal".equals(this.selectedLookAndFeel)) {
            return;
        }
        int choice = OptionDialog.showYesNoDialog(null, (String)"Change Look and Feel?", (String)"The 'Use Inverted Colors' setting works best with the 'Metal' Look and Feel.\nWould you like to switch to that Look and Feel upon restart?");
        if (choice == 1) {
            SystemUtilities.runSwingLater(() -> this.saveLookAndFeel("Metal"));
        }
    }

    private void issueLaFNotification() {
        if (issuedLafNotification) {
            return;
        }
        issuedLafNotification = true;
        Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"Look And Feel Updated", (Object)"The new Look and Feel will take effect \nafter you exit and restart Ghidra.");
    }

    public void dispose() {
        ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
        opt.removeOptionsChangeListener((OptionsChangeListener)this);
        super.dispose();
    }
}

