/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.cmd.function.DeleteFunctionCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;

class DeleteFunctionAction
extends ListingContextAction {
    FunctionPlugin funcPlugin;

    DeleteFunctionAction(FunctionPlugin plugin) {
        super("Delete Function", plugin.getName());
        this.funcPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Function", "Delete Function"}, null, "Function"));
        this.setKeyBindingData(new KeyBindingData(127, 0));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Function function = this.funcPlugin.getFunction(context);
        if (function == null) {
            return;
        }
        Address entry = function.getEntryPoint();
        this.funcPlugin.execute(context.getProgram(), new DeleteFunctionCmd(entry));
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        ProgramLocation location = context.getLocation();
        if (location instanceof FunctionLocation && !(location instanceof VariableLocation)) {
            return location.getAddress().equals((Object)((FunctionLocation)location).getFunctionAddress());
        }
        return false;
    }
}

