/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class AddParameterCommand
implements Command {
    protected Function function;
    protected Parameter parameter;
    protected String statusMessage;
    protected int ordinal;
    protected SourceType source;

    public AddParameterCommand(Function function, Parameter parameter, int ordinal, SourceType source) {
        this.function = function;
        this.parameter = parameter;
        this.ordinal = ordinal;
        this.source = source;
    }

    protected AddParameterCommand(Function function, int ordinal, SourceType source) {
        this(function, null, ordinal, source);
    }

    protected Parameter getParameter(Program program) throws InvalidInputException {
        return this.parameter;
    }

    public boolean applyTo(DomainObject obj) {
        String name = null;
        try {
            Parameter parameter2add = this.getParameter((Program)obj);
            name = parameter2add.getName();
            if (this.function.insertParameter(this.ordinal, (Variable)parameter2add, this.source) == null) {
                this.statusMessage = "Create parameter failed";
                return false;
            }
        }
        catch (DuplicateNameException e) {
            this.statusMessage = "Parameter named " + name + " already exists";
            return false;
        }
        catch (Exception exc) {
            Throwable cause = exc.getCause();
            if (cause != null) {
                this.statusMessage = cause.getMessage();
                if (this.statusMessage == null) {
                    this.statusMessage = cause.getClass().getName();
                }
            } else {
                this.statusMessage = exc.getMessage();
                if (this.statusMessage == null) {
                    this.statusMessage = exc.getClass().getName();
                }
            }
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.statusMessage;
    }

    public String getName() {
        return "Add Parameter Command";
    }
}

