/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface2;

import agent.dbgeng.manager.DbgModule;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface DbgModelTargetModule
extends DbgModelTargetObject,
TargetModule {
    public DbgModule getDbgModule();

    @Override
    default public CompletableFuture<Void> init(Map<String, Object> map) {
        AddressSpace space = this.getModel().getAddressSpace("ram");
        return this.requestNativeAttributes().thenAccept(attrs -> {
            if (!this.isValid()) {
                return;
            }
            if (attrs != null) {
                map.putAll((Map<String, Object>)attrs);
                TargetObject baseAttr = (TargetObject)attrs.get("BaseAddress");
                TargetObject nameAttr = (TargetObject)attrs.get("Name");
                TargetObject sizeAttr = (TargetObject)attrs.get("Size");
                Object baseval = baseAttr == null ? null : baseAttr.getCachedAttribute("_value");
                Object nameval = nameAttr == null ? null : nameAttr.getCachedAttribute("_value");
                Object sizeval = sizeAttr == null ? null : sizeAttr.getCachedAttribute("_value");
                String basestr = baseval == null ? "0" : baseval.toString();
                String namestr = nameval == null ? "" : nameval.toString();
                String sizestr = sizeval == null ? "1" : sizeval.toString();
                String shortnamestr = namestr;
                int sep = shortnamestr.lastIndexOf(92);
                if (sep > 0 && sep < shortnamestr.length()) {
                    shortnamestr = shortnamestr.substring(sep + 1);
                }
                Long base = Long.parseUnsignedLong(basestr, 16);
                Integer sz = Integer.parseInt(sizestr, 16);
                Address min = space.getAddress(base.longValue());
                Address max = min.add((long)(sz - 1));
                AddressRangeImpl range = new AddressRangeImpl(min, max);
                map.put("_range", range);
                String oldval = (String)this.getCachedAttribute("_display");
                map.put("_module_name", namestr);
                map.put("_short_display", shortnamestr);
                map.put("_display", shortnamestr);
                this.setModified(map, !shortnamestr.equals(oldval));
            }
        });
    }
}

