/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.breakpoint;

import agent.dbgeng.dbgeng.DebugBreakpoint;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.breakpoint.DbgBreakpointDisp;
import agent.dbgeng.manager.breakpoint.DbgBreakpointType;
import ghidra.comm.util.BitmaskSet;
import java.util.Objects;

public class DbgBreakpointInfo {
    private DebugBreakpoint bpt;
    private DbgProcess proc;
    private DbgThread eventThread;
    private DebugBreakpoint.BreakFullType bptType;
    private BitmaskSet<DebugBreakpoint.BreakFlags> flags;
    private DebugBreakpoint.BreakDataParameters parameters = new DebugBreakpoint.BreakDataParameters(1, (BitmaskSet<DebugBreakpoint.BreakAccess>)BitmaskSet.of((Enum[])new DebugBreakpoint.BreakAccess[]{DebugBreakpoint.BreakAccess.EXECUTE}));
    private BitmaskSet<DebugBreakpoint.BreakAccess> access;
    private int size = 1;
    private final long number;
    private boolean enabled;
    private Long offset;
    private String expression;

    public DbgBreakpointInfo(DbgBreakpointInfo oldInfo, boolean enabled) {
        this(oldInfo.getDebugBreakpoint(), oldInfo.getProc(), oldInfo.getEventThread());
        this.enabled = enabled;
    }

    public DbgBreakpointInfo(DebugBreakpoint bpt, DbgProcess proc) {
        this(bpt, proc, null);
    }

    public DbgBreakpointInfo(DebugBreakpoint bp, DbgProcess process, DbgThread thread) {
        this.setBreakpoint(bp);
        this.proc = process;
        this.eventThread = thread;
        this.number = this.bpt.getId();
        this.bptType = this.bpt.getType();
        this.flags = this.bpt.getFlags();
        if (this.bpt.getType().breakType.equals((Object)DebugBreakpoint.BreakType.DATA)) {
            this.parameters = this.bpt.getDataParameters();
        }
        this.access = this.parameters.access;
        this.size = this.parameters.size;
        this.offset = this.bpt.getOffset();
        this.expression = this.bpt.getOffsetExpression();
    }

    public int hashCode() {
        return Objects.hash(this.number, this.bptType, this.getFlags(), this.enabled, this.access, this.getSize(), this.offset, this.expression);
    }

    public int getId() {
        return this.bpt.getId();
    }

    public String toString() {
        return Integer.toHexString(this.bpt.getId());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DbgBreakpointInfo)) {
            return false;
        }
        DbgBreakpointInfo that = (DbgBreakpointInfo)obj;
        if (this.number != that.number) {
            return false;
        }
        if (this.getFlags() != that.getFlags()) {
            return false;
        }
        if (this.getSize() != that.getSize()) {
            return false;
        }
        if (!Objects.equals(this.expression, that.expression)) {
            return false;
        }
        if (!Objects.equals(this.offset, that.offset)) {
            return false;
        }
        return this.enabled == that.enabled;
    }

    public long getNumber() {
        return this.number;
    }

    public DbgBreakpointType getType() {
        boolean isCode = this.bpt.getType().breakType.equals((Object)DebugBreakpoint.BreakType.CODE);
        if (isCode) {
            return DbgBreakpointType.BREAKPOINT;
        }
        DebugBreakpoint.BreakDataParameters params = this.bpt.getDataParameters();
        if (params == null || params.access.isEmpty()) {
            return DbgBreakpointType.OTHER;
        }
        if (params.access.contains((Object)DebugBreakpoint.BreakAccess.READ) && params.access.contains((Object)DebugBreakpoint.BreakAccess.WRITE)) {
            return DbgBreakpointType.ACCESS_WATCHPOINT;
        }
        if (params.access.contains((Object)DebugBreakpoint.BreakAccess.READ)) {
            return DbgBreakpointType.READ_WATCHPOINT;
        }
        if (params.access.contains((Object)DebugBreakpoint.BreakAccess.WRITE)) {
            return DbgBreakpointType.HW_WATCHPOINT;
        }
        if (params.access.contains((Object)DebugBreakpoint.BreakAccess.EXECUTE)) {
            return DbgBreakpointType.HW_BREAKPOINT;
        }
        return DbgBreakpointType.OTHER;
    }

    public DbgBreakpointDisp getDisp() {
        return DbgBreakpointDisp.KEEP;
    }

    public String getExpression() {
        return this.expression;
    }

    public int getSize() {
        return this.size;
    }

    public BitmaskSet<DebugBreakpoint.BreakAccess> getAccess() {
        return this.access;
    }

    public Long getOffset() {
        return this.offset;
    }

    public String getPending() {
        return this.getFlags().contains((Object)DebugBreakpoint.BreakFlags.DEFERRED) ? "pending" : "";
    }

    public boolean isEnabled() {
        return this.getFlags().contains((Object)DebugBreakpoint.BreakFlags.ENABLED);
    }

    public int getTimes() {
        return 0;
    }

    public DbgBreakpointInfo withEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return this;
        }
        return new DbgBreakpointInfo(this, enabled);
    }

    public DebugBreakpoint getDebugBreakpoint() {
        return this.bpt;
    }

    public BitmaskSet<DebugBreakpoint.BreakFlags> getFlags() {
        return this.flags;
    }

    public DbgProcess getProc() {
        return this.proc;
    }

    public DbgThread getEventThread() {
        return this.eventThread;
    }

    public void setBreakpoint(DebugBreakpoint bpt) {
        this.bpt = bpt;
        this.bptType = bpt.getType();
        this.flags = bpt.getFlags();
        this.offset = bpt.getOffset();
        this.expression = bpt.getOffsetExpression();
        if (this.bptType.breakType.equals((Object)DebugBreakpoint.BreakType.DATA)) {
            DebugBreakpoint.BreakDataParameters p = bpt.getDataParameters();
            this.access = p.access;
            this.size = p.size;
        }
    }
}

