/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.bitpatterns.gui.FunctionBitPatternsMainProvider;
import ghidra.bitpatterns.gui.PatternInfoRowObject;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.ProgramSelection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@PluginInfo(status=PluginStatus.STABLE, packageName="Miscellaneous", category="Analysis", shortDescription="FunctionBitPatternsExplorerPlugin", description="Plugin for exploring function start/return patterns.")
public class FunctionBitPatternsExplorerPlugin
extends ProgramPlugin {
    private FunctionBitPatternsMainProvider provider = new FunctionBitPatternsMainProvider(this);
    private Set<PatternInfoRowObject> patterns = new HashSet<PatternInfoRowObject>();

    public FunctionBitPatternsExplorerPlugin(PluginTool tool) {
        super(tool, false, false);
    }

    public void addPattern(PatternInfoRowObject patternRow) {
        this.patterns.add(patternRow);
    }

    public void removePatterns(Collection<PatternInfoRowObject> patternsToRemove) {
        this.patterns.removeAll(patternsToRemove);
    }

    public Set<PatternInfoRowObject> getPatterns() {
        return new HashSet<PatternInfoRowObject>(this.patterns);
    }

    public void clearPatterns() {
        this.patterns.clear();
    }

    void updateClipboard() {
        this.provider.updateClipboard();
    }

    void highlightMatches(AddressSetView matches) {
        ProgramSelection highlighted = new ProgramSelection(matches);
        ProgramHighlightPluginEvent highLightEvent = new ProgramHighlightPluginEvent(this.getName(), highlighted, this.getCurrentProgram());
        this.firePluginEvent((PluginEvent)highLightEvent);
    }

    protected void dispose() {
        if (this.provider != null) {
            this.provider.dispose();
        }
    }
}

