/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockCache;
import ghidra.program.model.block.CodeBlockImpl;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.MultEntSubModel;
import ghidra.program.model.block.PartitionCodeSubIterator;
import ghidra.program.model.block.SubroutineBlockModel;
import ghidra.program.model.block.SubroutineDestReferenceIterator;
import ghidra.program.model.block.SubroutineSourceReferenceIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NoValueException;
import ghidra.util.graph.DirectedGraph;
import ghidra.util.graph.Edge;
import ghidra.util.graph.GraphIterator;
import ghidra.util.graph.KeyedObject;
import ghidra.util.graph.Vertex;
import ghidra.util.graph.attributes.AttributeManager;
import ghidra.util.graph.attributes.IntegerAttribute;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class PartitionCodeSubModel
implements SubroutineBlockModel {
    public static final String NAME = "Partitioned Code";
    private Program program;
    private Listing listing;
    private CodeBlockCache foundModelP;
    private MultEntSubModel modelM;
    private static final CodeBlock[] emptyArray = new CodeBlock[0];
    private static final String ENTRY_POINT_TAG = "Entry Point Tag";
    private static final String SOURCE_NUMBER = "Source Number";
    private String attributeType = "INTEGER_TYPE";
    private DirectedGraph g;
    private AttributeManager<?> vertexAttributes;
    private IntegerAttribute<Vertex> entAttribute;

    public PartitionCodeSubModel(Program program) {
        this(program, false);
    }

    public PartitionCodeSubModel(Program program, boolean includeExternals) {
        this.program = program;
        this.listing = program.getListing();
        this.foundModelP = new CodeBlockCache();
        this.modelM = new MultEntSubModel(program, includeExternals);
    }

    @Override
    public CodeBlock getCodeBlockAt(Address addr, TaskMonitor monitor) throws CancelledException {
        CodeBlock block = this.foundModelP.getBlockAt(addr);
        if (block != null) {
            return block;
        }
        block = this.getFirstCodeBlockContaining(addr, monitor);
        if (block != null && block.getFirstStartAddress().equals(addr)) {
            return block;
        }
        return null;
    }

    @Override
    public CodeBlock[] getCodeBlocksContaining(Address addr, TaskMonitor monitor) throws CancelledException {
        CodeBlock[] subs;
        CodeBlock[] blocks = new CodeBlock[]{this.foundModelP.getFirstBlockContaining(addr)};
        if (blocks[0] != null) {
            return blocks;
        }
        CodeBlock modelMSub = this.modelM.getFirstCodeBlockContaining(addr, monitor);
        if (modelMSub == null) {
            return emptyArray;
        }
        Address[] entPts = modelMSub.getStartAddresses();
        AddressSet modelMSet = new AddressSet(modelMSub);
        if (entPts.length == 1) {
            blocks[0] = this.createSub(modelMSet, entPts[0]);
            return blocks;
        }
        for (CodeBlock sub : subs = this.getModelPSubs(modelMSub, monitor)) {
            if (!sub.contains(addr)) continue;
            blocks[0] = sub;
            return blocks;
        }
        return emptyArray;
    }

    @Override
    public CodeBlock getFirstCodeBlockContaining(Address addr, TaskMonitor monitor) throws CancelledException {
        CodeBlock[] blocks = this.getCodeBlocksContaining(addr, monitor);
        if (blocks.length != 0) {
            return blocks[0];
        }
        return null;
    }

    @Override
    public CodeBlockIterator getCodeBlocks(TaskMonitor monitor) {
        return new PartitionCodeSubIterator(this, monitor);
    }

    @Override
    public CodeBlockIterator getCodeBlocksContaining(AddressSetView addrSet, TaskMonitor monitor) {
        return new PartitionCodeSubIterator(this, addrSet, monitor);
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    public Listing getListing() {
        return this.listing;
    }

    @Override
    public String getName(CodeBlock block) {
        Address a;
        if (!(block.getModel() instanceof PartitionCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        Address start = block.getFirstStartAddress();
        Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(start);
        if (symbol != null) {
            return symbol.getName();
        }
        Instruction inst = this.getListing().getInstructionBefore(start);
        if (inst != null && start.equals(a = inst.getFallThrough())) {
            return "SUB" + start;
        }
        return "SOURCE_SUB" + start.toString();
    }

    @Override
    public FlowType getFlowType(CodeBlock block) {
        if (!(block.getModel() instanceof PartitionCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        try {
            SubroutineDestReferenceIterator iter = new SubroutineDestReferenceIterator(block, TaskMonitorAdapter.DUMMY_MONITOR);
            while (iter.hasNext()) {
                if (iter.next().getFlowType().isCall()) continue;
                return RefType.FLOW;
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return RefType.TERMINATOR;
    }

    @Override
    public CodeBlockReferenceIterator getSources(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof PartitionCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        return new SubroutineSourceReferenceIterator(block, monitor);
    }

    @Override
    public int getNumSources(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof PartitionCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        return SubroutineSourceReferenceIterator.getNumSources(block, monitor);
    }

    @Override
    public CodeBlockReferenceIterator getDestinations(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof PartitionCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        return new SubroutineDestReferenceIterator(block, monitor);
    }

    @Override
    public int getNumDestinations(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof PartitionCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        return SubroutineDestReferenceIterator.getNumDestinations(block, monitor);
    }

    private CodeBlock createSub(AddressSetView set, Address entryPt) {
        CodeBlock sub = this.foundModelP.getBlockAt(entryPt);
        if (sub != null) {
            return sub;
        }
        Address[] starts = new Address[]{entryPt};
        sub = new CodeBlockImpl(this, starts, set);
        this.foundModelP.addObject(sub, set);
        return sub;
    }

    private void createBlockGraph(CodeBlock modelMSub, TaskMonitor monitor) throws CancelledException {
        this.g = new DirectedGraph();
        this.vertexAttributes = this.g.vertexAttributes();
        this.entAttribute = (IntegerAttribute)this.vertexAttributes.createAttribute(ENTRY_POINT_TAG, this.attributeType);
        Address[] entPts = modelMSub.getStartAddresses();
        LinkedList<Address> entryAddrList = new LinkedList<Address>();
        for (Address entPt : entPts) {
            entryAddrList.addLast(entPt);
        }
        CodeBlockModel blockModel = this.modelM.getBasicBlockModel();
        CodeBlockIterator blockIter = blockModel.getCodeBlocksContaining(modelMSub, monitor);
        while (blockIter.hasNext()) {
            CodeBlock block = blockIter.next();
            Vertex[] verticesOfBlock = this.g.getVerticesHavingReferent((Object)block);
            Vertex fromVertex = verticesOfBlock.length != 0 ? verticesOfBlock[0] : new Vertex((Object)block);
            this.g.add(fromVertex);
            Address[] entryPts = block.getStartAddresses();
            for (int i = 0; i < entryPts.length; ++i) {
                if (!entryAddrList.contains(entryPts[i])) continue;
                this.entAttribute.setValue((KeyedObject)fromVertex, i);
                break;
            }
            CodeBlockReferenceIterator destinations = block.getDestinations(monitor);
            while (destinations.hasNext()) {
                Address targetAddr;
                CodeBlock targetBlock;
                CodeBlockReference destinationReference = destinations.next();
                FlowType flowType = destinationReference.getFlowType();
                if (flowType.isCall() || flowType.isTerminal() || (targetBlock = blockModel.getFirstCodeBlockContaining(targetAddr = destinationReference.getDestinationAddress(), monitor)) == null) continue;
                entryPts = targetBlock.getStartAddresses();
                boolean connect = true;
                for (Address entryPt : entryPts) {
                    if (!entryAddrList.contains(entryPt)) continue;
                    connect = false;
                }
                if (!connect) continue;
                verticesOfBlock = this.g.getVerticesHavingReferent((Object)targetBlock);
                Vertex targetVertex = verticesOfBlock.length != 0 ? verticesOfBlock[0] : new Vertex((Object)targetBlock);
                Edge edge = new Edge(fromVertex, targetVertex);
                this.g.add(edge);
            }
        }
    }

    private void partitionGraph(TaskMonitor monitor) throws CancelledException {
        Vertex[] sources;
        LinkedList<Vertex> entryList = new LinkedList<Vertex>();
        for (Vertex source : sources = this.g.getSources()) {
            entryList.addLast(source);
        }
        LinkedList<Vertex> todoStack = new LinkedList<Vertex>();
        boolean sourceListIsGrowing = true;
        while (sourceListIsGrowing) {
            sourceListIsGrowing = false;
            IntegerAttribute sourceNumber = (IntegerAttribute)this.vertexAttributes.createAttribute(SOURCE_NUMBER, this.attributeType);
            int cnt = entryList.size();
            for (int i = 0; i < cnt; ++i) {
                todoStack.addLast((Vertex)entryList.get(i));
                while (!todoStack.isEmpty()) {
                    if (monitor.isCancelled()) {
                        throw new CancelledException();
                    }
                    Vertex v = (Vertex)todoStack.removeLast();
                    sourceNumber.setValue((KeyedObject)v, i + 1);
                    Set children = this.g.getChildren(v);
                    if (children.isEmpty()) continue;
                    for (Vertex child : children) {
                        int sourceValue = 0;
                        try {
                            sourceValue = sourceNumber.getValue((KeyedObject)child);
                            if (sourceValue == i + 1) {
                                continue;
                            }
                        }
                        catch (NoValueException nVE) {
                            sourceValue = i + 1;
                        }
                        if (sourceValue == i + 1) {
                            todoStack.addLast(child);
                            continue;
                        }
                        Set incomingEdges = this.g.getIncomingEdges(child);
                        Iterator edgeIter = incomingEdges.iterator();
                        while (edgeIter.hasNext()) {
                            this.g.remove((Edge)edgeIter.next());
                        }
                        entryList.addLast(child);
                        this.entAttribute.setValue((KeyedObject)child, 0);
                        sourceListIsGrowing = true;
                    }
                }
            }
        }
    }

    private CodeBlock[] fromGraphToSubs(TaskMonitor monitor) throws CancelledException {
        DirectedGraph[] components = this.g.getComponents();
        CodeBlock[] subs = new CodeBlock[components.length];
        for (int i = 0; i < subs.length; ++i) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            GraphIterator vertIter = components[i].vertexIterator();
            AddressSet addrSet = new AddressSet();
            Address entry = null;
            while (vertIter.hasNext()) {
                Vertex v = (Vertex)vertIter.next();
                CodeBlock block = (CodeBlock)this.g.getReferent(v);
                try {
                    int ix = this.entAttribute.getValue((KeyedObject)v);
                    Address[] entryPts = block.getStartAddresses();
                    entry = entryPts[ix];
                }
                catch (NoValueException noValueException) {
                    // empty catch block
                }
                addrSet.add(block);
            }
            if (entry == null) {
                entry = addrSet.getMinAddress();
                Msg.warn((Object)this, (Object)("WARNING: fabricating entry point for Partitioned subroutine at " + entry));
            }
            subs[i] = this.createSub(addrSet, entry);
        }
        this.entAttribute.clear();
        this.vertexAttributes.removeAttribute(ENTRY_POINT_TAG);
        this.vertexAttributes.removeAttribute(SOURCE_NUMBER);
        this.g.clear();
        return subs;
    }

    private CodeBlock[] getModelPSubs(CodeBlock modelMSub, TaskMonitor monitor) throws CancelledException {
        this.createBlockGraph(modelMSub, monitor);
        this.partitionGraph(monitor);
        return this.fromGraphToSubs(monitor);
    }

    @Override
    public CodeBlockModel getBasicBlockModel() {
        return this.modelM.getBasicBlockModel();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public SubroutineBlockModel getBaseSubroutineModel() {
        return this.modelM;
    }

    @Override
    public boolean allowsBlockOverlap() {
        return false;
    }

    @Override
    public boolean externalsIncluded() {
        return this.modelM.externalsIncluded();
    }
}

