/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.languages.sleigh;

import ghidra.app.plugin.languages.sleigh.ConstructorEntryVisitor;
import ghidra.app.plugin.languages.sleigh.SleighSubtableTraversal;
import ghidra.app.plugin.languages.sleigh.SubtableEntryVisitor;
import ghidra.app.plugin.languages.sleigh.VisitorResults;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.Symbol;

public class SleighConstructorTraversal
implements VisitorResults {
    protected final SleighLanguage lang;

    public SleighConstructorTraversal(SleighLanguage lang) {
        this.lang = lang;
    }

    public int traverse(ConstructorEntryVisitor visitor) {
        for (Symbol sym : this.lang.getSymbolTable().getSymbolList()) {
            SubtableSymbol subtable;
            SleighSubtableTraversal t;
            int result;
            if (!(sym instanceof SubtableSymbol) || (result = (t = new SleighSubtableTraversal(subtable = (SubtableSymbol)sym)).traverse(new SubVisitor(subtable, visitor))) == 1) continue;
            assert (result != 0);
            return result;
        }
        return 1;
    }

    protected static class SubVisitor
    implements SubtableEntryVisitor {
        protected final SubtableSymbol subtable;
        protected final ConstructorEntryVisitor cev;

        protected SubVisitor(SubtableSymbol subtable, ConstructorEntryVisitor cev) {
            this.subtable = subtable;
            this.cev = cev;
        }

        @Override
        public int visit(DisjointPattern pattern, Constructor cons) {
            return this.cev.visit(this.subtable, pattern, cons);
        }
    }
}

