/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;

final class RunLengthDecodeFilter
extends Filter {
    private static final Log LOG = LogFactory.getLog(RunLengthDecodeFilter.class);
    private static final int RUN_LENGTH_EOD = 128;

    RunLengthDecodeFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        int dupAmount;
        byte[] buffer = new byte[128];
        while ((dupAmount = encoded.read()) != -1 && dupAmount != 128) {
            if (dupAmount <= 127) {
                int compressedRead;
                for (int amountToCopy = dupAmount + 1; amountToCopy > 0 && (compressedRead = encoded.read(buffer, 0, amountToCopy)) != -1; amountToCopy -= compressedRead) {
                    decoded.write(buffer, 0, compressedRead);
                }
                continue;
            }
            int dupByte = encoded.read();
            if (dupByte == -1) break;
            for (int i = 0; i < 257 - dupAmount; ++i) {
                decoded.write(dupByte);
            }
        }
        return new DecodeResult(parameters);
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        LOG.warn((Object)"RunLengthDecodeFilter.encode is not implemented yet, skipping this stream.");
    }
}

