/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import org.junit.Test;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.testCases.unity.TestCasesBaseApply;
import org.snpeff.util.Gpr;

public class TestCasesApplyDel
extends TestCasesBaseApply {
    @Test
    public void test_apply_variant_01() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 290, "TTT", "");
        this.checkApplyDel(variant, this.transcript.cds(), this.transcript.protein(), 1, 297, 396);
    }

    @Test
    public void test_apply_variant_02() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 297, "TCC", "");
        this.checkApplyDel(variant, this.transcript.cds(), this.transcript.protein(), 1, 297, 396);
    }

    @Test
    public void test_apply_variant_03() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 299, "CTG", "");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatggtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacgggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyDel(variant, expectedCds, null, 1, 299, 396);
    }

    @Test
    public void test_apply_variant_04() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 300, "TGT", "");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatggttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacgggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyDel(variant, expectedCds, null, 1, 300, 396);
    }

    @Test
    public void test_apply_variant_05() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 310, "TTC", "");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatggtgtttgggaaacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacgggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyDel(variant, expectedCds, null, 1, 300, 396);
    }

    @Test
    public void test_apply_variant_06() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 397, "ACG", "");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatggtgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyDel(variant, expectedCds, null, 1, 300, 396);
    }

    @Test
    public void test_apply_variant_07() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 398, "CGA", "");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "tgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaa".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyDel(variant, expectedCds, null, 1, 300, 397);
    }

    @Test
    public void test_apply_variant_08() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 400, "AAA", "");
        this.checkApplyDel(variant, this.transcript.cds(), this.transcript.protein(), 1, 300, 399);
    }

    @Test
    public void test_apply_variant_09() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 410, "AGC", "");
        this.checkApplyDel(variant, this.transcript.cds(), this.transcript.protein(), 1, 300, 399);
    }

    @Test
    public void test_apply_variant_10() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 290, "tttatcgtcctgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacgaaagggagct", "");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatggggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyDel(variant, expectedCds, null, 1, 780, 879);
    }

    @Test
    public void test_apply_variant_11() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 300, "TGTTTGGGAATTCACGGGCACGGTTCTGCAGCAAGCTGAATTGGCAGCTCGGCATAAATCCCGACCCCATCGTCACGCACGGATCAATTCATCCTCAACGAAAGGGAGCTAGCGCTGTAC", "");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatggggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyDel(variant, expectedCds, null, 1, 780, 879);
    }

    @Test
    public void test_apply_variant_12() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 280, "aaccgctaactttatcgtcctgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toUpperCase(), "");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatggggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyDel(variant, expectedCds, null, 1, 780, 879);
    }

    @Test
    public void test_apply_variant_13() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 300, "tgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toUpperCase(), "");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatggggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyDel(variant, expectedCds, null, 1, 800, 899);
    }
}

