/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationErrors {
    boolean debug;
    boolean verbose;

    public TestCasesIntegrationErrors() {
        this.verbose = this.debug = false;
    }

    @Test
    public void test_01_ERROR_CHROMOSOME_NOT_FOUND() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr1";
        String vcf = "tests/missing_chromo.vcf";
        String[] args = new String[]{"-noLog", genome, vcf};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        snpEff.setDebug(this.debug);
        SnpEffCmdEff seff = (SnpEffCmdEff)snpEff.cmd();
        List<VcfEntry> vcfEntries = seff.run(true);
        int count2 = 0;
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\t\t" + veff);
                }
                Assert.assertEquals(VariantEffect.ErrorWarningType.ERROR_CHROMOSOME_NOT_FOUND.toString(), veff.getErrorsWarning());
                ++count2;
            }
        }
        Assert.assertEquals(9, count2);
    }

    @Test
    public void test_02_ERROR_CHROMOSOME_NOT_FOUND() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr1";
        String vcf = "tests/missing_chromo.vcf";
        String[] args = new String[]{"-noLog", "-classic", genome, vcf};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        snpEff.setDebug(this.debug);
        SnpEffCmdEff seff = (SnpEffCmdEff)snpEff.cmd();
        List<VcfEntry> vcfEntries = seff.run(true);
        int count2 = 0;
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\t\t" + veff);
                }
                Assert.assertEquals(VariantEffect.ErrorWarningType.ERROR_CHROMOSOME_NOT_FOUND.toString(), veff.getErrorsWarning());
                ++count2;
            }
        }
        Assert.assertEquals(9, count2);
    }
}

