/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval.tree;

import java.io.Serializable;
import java.util.Iterator;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Interval;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.tree.IntervalNode;
import org.snpeff.interval.tree.Itree;

public class IntervalTree
implements Itree,
Serializable {
    private static final long serialVersionUID = 1808077263026999072L;
    protected IntervalNode head;
    protected Markers intervals;
    protected boolean inSync;

    public IntervalTree() {
        this.head = new IntervalNode();
        this.intervals = new Markers();
        this.inSync = true;
    }

    public IntervalTree(Markers intervals) {
        this.head = new IntervalNode(intervals);
        this.intervals = new Markers();
        this.intervals.add(intervals);
        this.inSync = false;
    }

    @Override
    public void add(Marker interval) {
        this.intervals.add(interval);
        this.inSync = false;
    }

    @Override
    public void add(Markers markers) {
        this.intervals.add(markers);
        this.inSync = false;
    }

    @Override
    public void build() {
        if (!this.inSync) {
            this.head = new IntervalNode(this.intervals);
            this.inSync = true;
        }
    }

    @Override
    public Markers getIntervals() {
        return this.intervals;
    }

    @Override
    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    @Override
    public boolean isInSync() {
        return this.inSync;
    }

    @Override
    public Iterator<Marker> iterator() {
        return this.intervals.iterator();
    }

    @Override
    public void load(String fileName, Genome genome) {
        this.intervals.load(fileName, genome);
        this.inSync = false;
    }

    private String nodeString(IntervalNode node, int level) {
        if (node == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            sb.append("\t");
        }
        sb.append(node + "\n");
        sb.append(this.nodeString(node.getLeft(), level + 1));
        sb.append(this.nodeString(node.getRight(), level + 1));
        return sb.toString();
    }

    @Override
    public Markers query(Interval interval) {
        if (!this.inSync) {
            throw new RuntimeException("Interval tree needs to be updated!");
        }
        return this.head.query(interval);
    }

    @Override
    public int size() {
        return this.intervals.size();
    }

    @Override
    public Markers stab(int point) {
        if (!this.inSync) {
            throw new RuntimeException("Interval tree needs to be updated!");
        }
        return this.head.stab(point);
    }

    public String toString() {
        return this.nodeString(this.head, 0);
    }
}

