/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.tool.ast.GrammarAST;

public class Utils {
    public static final int INTEGER_POOL_MAX_VALUE = 1000;
    static Integer[] ints = new Integer[1001];

    public static String stripFileExtension(String name) {
        if (name == null) {
            return null;
        }
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return name;
        }
        return name.substring(0, lastDot);
    }

    public static String join(Object[] a, String separator) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            Object o = a[i];
            buf.append(o.toString());
            if (i + 1 >= a.length) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String sortLinesInString(String s) {
        Object[] lines2 = s.split("\n");
        Arrays.sort(lines2);
        List<Object> linesL = Arrays.asList(lines2);
        StringBuilder buf = new StringBuilder();
        for (String string2 : linesL) {
            buf.append(string2);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static <T extends GrammarAST> List<String> nodesToStrings(List<T> nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList<String> a = new ArrayList<String>();
        for (GrammarAST t : nodes) {
            a.add(t.getText());
        }
        return a;
    }

    public static String capitalize(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String decapitalize(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static <From, To> List<To> select(List<From> list2, Func1<From, To> selector) {
        if (list2 == null) {
            return null;
        }
        ArrayList<To> b = new ArrayList<To>();
        for (From f2 : list2) {
            b.add(selector.exec(f2));
        }
        return b;
    }

    public static <T> T find(List<?> ops2, Class<T> cl) {
        for (Object o : ops2) {
            if (!cl.isInstance(o)) continue;
            return cl.cast(o);
        }
        return null;
    }

    public static <T> int indexOf(List<? extends T> elems, Filter<T> filter2) {
        for (int i = 0; i < elems.size(); ++i) {
            if (!filter2.select(elems.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(List<? extends T> elems, Filter<T> filter2) {
        for (int i = elems.size() - 1; i >= 0; --i) {
            if (!filter2.select(elems.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static void setSize(List<?> list2, int size2) {
        if (size2 < list2.size()) {
            list2.subList(size2, list2.size()).clear();
        } else {
            while (size2 > list2.size()) {
                list2.add(null);
            }
        }
    }

    public static interface Func1<T1, TResult> {
        public TResult exec(T1 var1);
    }

    public static interface Func0<TResult> {
        public TResult exec();
    }

    public static interface Filter<T> {
        public boolean select(T var1);
    }
}

