/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDelayedMergeObject;
import com.typesafe.config.impl.ConfigSubstitution;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfig;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SubstitutionResolver;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class AbstractConfigObject
extends AbstractConfigValue
implements ConfigObject {
    private static final long serialVersionUID = 1L;
    private final SimpleConfig config = new SimpleConfig(this);

    protected AbstractConfigObject(ConfigOrigin configOrigin) {
        super(configOrigin);
    }

    @Override
    public SimpleConfig toConfig() {
        return this.config;
    }

    @Override
    public AbstractConfigObject toFallbackValue() {
        return this;
    }

    @Override
    public abstract AbstractConfigObject withOnlyKey(String var1);

    @Override
    public abstract AbstractConfigObject withoutKey(String var1);

    protected abstract AbstractConfigObject withOnlyPathOrNull(Path var1);

    abstract AbstractConfigObject withOnlyPath(Path var1);

    abstract AbstractConfigObject withoutPath(Path var1);

    protected abstract AbstractConfigValue peek(String var1);

    protected AbstractConfigValue peek(String string2, SubstitutionResolver substitutionResolver, int n, ConfigResolveOptions configResolveOptions) {
        AbstractConfigValue abstractConfigValue = this.peek(string2);
        if (abstractConfigValue != null && substitutionResolver != null) {
            abstractConfigValue = substitutionResolver.resolve(abstractConfigValue, n, configResolveOptions);
        }
        return abstractConfigValue;
    }

    protected AbstractConfigValue peekPath(Path path, SubstitutionResolver substitutionResolver, int n, ConfigResolveOptions configResolveOptions) {
        return AbstractConfigObject.peekPath(this, path, substitutionResolver, n, configResolveOptions);
    }

    AbstractConfigValue peekPath(Path path) {
        return AbstractConfigObject.peekPath(this, path, null, 0, null);
    }

    private static AbstractConfigValue peekPath(AbstractConfigObject abstractConfigObject, Path path, SubstitutionResolver substitutionResolver, int n, ConfigResolveOptions configResolveOptions) {
        String string2 = path.first();
        Path path2 = path.remainder();
        if (path2 == null) {
            AbstractConfigValue abstractConfigValue = abstractConfigObject.peek(string2, substitutionResolver, n, configResolveOptions);
            return abstractConfigValue;
        }
        AbstractConfigValue abstractConfigValue = abstractConfigObject.peek(string2);
        if (abstractConfigValue instanceof ConfigSubstitution && substitutionResolver != null) {
            abstractConfigValue = substitutionResolver.resolve(abstractConfigValue, n, configResolveOptions);
        }
        if (abstractConfigValue instanceof AbstractConfigObject) {
            return AbstractConfigObject.peekPath((AbstractConfigObject)abstractConfigValue, path2, substitutionResolver, n, configResolveOptions);
        }
        return null;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.OBJECT;
    }

    protected abstract AbstractConfigObject newCopy(ResolveStatus var1, boolean var2, ConfigOrigin var3);

    @Override
    protected AbstractConfigObject newCopy(boolean bl, ConfigOrigin configOrigin) {
        return this.newCopy(this.resolveStatus(), bl, configOrigin);
    }

    @Override
    protected final AbstractConfigObject mergedWithTheUnmergeable(Unmergeable unmergeable) {
        if (this.ignoresFallbacks()) {
            throw new ConfigException.BugOrBroken("should not be reached");
        }
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        if (this instanceof Unmergeable) {
            arrayList.addAll(((Unmergeable)((Object)this)).unmergedValues());
        } else {
            arrayList.add(this);
        }
        arrayList.addAll(unmergeable.unmergedValues());
        return new ConfigDelayedMergeObject(AbstractConfigObject.mergeOrigins(arrayList), arrayList, ((AbstractConfigValue)((Object)unmergeable)).ignoresFallbacks());
    }

    @Override
    protected AbstractConfigObject mergedWithObject(AbstractConfigObject abstractConfigObject) {
        if (this.ignoresFallbacks()) {
            throw new ConfigException.BugOrBroken("should not be reached");
        }
        boolean bl = false;
        boolean bl2 = true;
        HashMap<String, AbstractConfigValue> hashMap = new HashMap<String, AbstractConfigValue>();
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.keySet());
        hashSet.addAll(abstractConfigObject.keySet());
        for (String string2 : hashSet) {
            AbstractConfigValue abstractConfigValue = this.peek(string2);
            AbstractConfigValue abstractConfigValue2 = abstractConfigObject.peek(string2);
            AbstractConfigValue abstractConfigValue3 = abstractConfigValue == null ? abstractConfigValue2 : (abstractConfigValue2 == null ? abstractConfigValue : abstractConfigValue.withFallback(abstractConfigValue2));
            hashMap.put(string2, abstractConfigValue3);
            if (abstractConfigValue != abstractConfigValue3) {
                bl = true;
            }
            if (abstractConfigValue3.resolveStatus() != ResolveStatus.UNRESOLVED) continue;
            bl2 = false;
        }
        Object object = ResolveStatus.fromBoolean(bl2);
        boolean bl3 = abstractConfigObject.ignoresFallbacks();
        if (bl) {
            return new SimpleConfigObject(AbstractConfigObject.mergeOrigins(this, abstractConfigObject), (Map<String, AbstractConfigValue>)hashMap, (ResolveStatus)((Object)object), bl3);
        }
        if (object != this.resolveStatus() || bl3 != this.ignoresFallbacks()) {
            return this.newCopy((ResolveStatus)((Object)object), bl3, this.origin());
        }
        return this;
    }

    @Override
    public AbstractConfigObject withFallback(ConfigMergeable configMergeable) {
        return (AbstractConfigObject)super.withFallback(configMergeable);
    }

    static ConfigOrigin mergeOrigins(Collection<? extends AbstractConfigValue> collection) {
        if (collection.isEmpty()) {
            throw new ConfigException.BugOrBroken("can't merge origins on empty list");
        }
        ArrayList<SimpleConfigOrigin> arrayList = new ArrayList<SimpleConfigOrigin>();
        SimpleConfigOrigin simpleConfigOrigin = null;
        int n = 0;
        for (AbstractConfigValue abstractConfigValue : collection) {
            if (simpleConfigOrigin == null) {
                simpleConfigOrigin = abstractConfigValue.origin();
            }
            if (abstractConfigValue instanceof AbstractConfigObject && ((AbstractConfigObject)abstractConfigValue).resolveStatus() == ResolveStatus.RESOLVED && ((ConfigObject)((Object)abstractConfigValue)).isEmpty()) continue;
            arrayList.add(abstractConfigValue.origin());
            ++n;
        }
        if (n == 0) {
            arrayList.add(simpleConfigOrigin);
        }
        return SimpleConfigOrigin.mergeOrigins(arrayList);
    }

    static ConfigOrigin mergeOrigins(AbstractConfigObject ... abstractConfigObjectArray) {
        return AbstractConfigObject.mergeOrigins(Arrays.asList(abstractConfigObjectArray));
    }

    private AbstractConfigObject modify(AbstractConfigValue.Modifier modifier, ResolveStatus resolveStatus) {
        AbstractConfigValue abstractConfigValue;
        HashMap<Object, AbstractConfigValue> hashMap = null;
        for (Object object : this.keySet()) {
            Object object2 = this.peek((String)object);
            abstractConfigValue = modifier.modifyChild((AbstractConfigValue)object2);
            if (abstractConfigValue == object2) continue;
            if (hashMap == null) {
                hashMap = new HashMap<Object, AbstractConfigValue>();
            }
            hashMap.put(object, abstractConfigValue);
        }
        if (hashMap == null) {
            return this.newCopy(resolveStatus, this.ignoresFallbacks(), this.origin());
        }
        HashMap hashMap2 = new HashMap();
        for (Object object2 : this.keySet()) {
            if (hashMap.containsKey(object2)) {
                abstractConfigValue = (AbstractConfigValue)hashMap.get(object2);
                if (abstractConfigValue == null) continue;
                hashMap2.put(object2, abstractConfigValue);
                continue;
            }
            hashMap2.put(object2, this.peek((String)object2));
        }
        return new SimpleConfigObject(this.origin(), hashMap2, resolveStatus, this.ignoresFallbacks());
    }

    @Override
    AbstractConfigObject resolveSubstitutions(final SubstitutionResolver substitutionResolver, final int n, final ConfigResolveOptions configResolveOptions) {
        if (this.resolveStatus() == ResolveStatus.RESOLVED) {
            return this;
        }
        return this.modify(new AbstractConfigValue.Modifier(){

            @Override
            public AbstractConfigValue modifyChild(AbstractConfigValue abstractConfigValue) {
                return substitutionResolver.resolve(abstractConfigValue, n, configResolveOptions);
            }
        }, ResolveStatus.RESOLVED);
    }

    @Override
    AbstractConfigObject relativized(final Path path) {
        return this.modify(new AbstractConfigValue.Modifier(){

            @Override
            public AbstractConfigValue modifyChild(AbstractConfigValue abstractConfigValue) {
                return abstractConfigValue.relativized(path);
            }
        }, this.resolveStatus());
    }

    @Override
    public AbstractConfigValue get(Object object) {
        if (object instanceof String) {
            return this.peek((String)object);
        }
        return null;
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, boolean bl) {
        if (this.isEmpty()) {
            stringBuilder.append("{}");
        } else {
            stringBuilder.append("{");
            if (bl) {
                stringBuilder.append('\n');
            }
            for (String string2 : this.keySet()) {
                AbstractConfigValue abstractConfigValue = this.peek(string2);
                if (bl) {
                    AbstractConfigObject.indent(stringBuilder, n + 1);
                    stringBuilder.append("# ");
                    stringBuilder.append(abstractConfigValue.origin().description());
                    stringBuilder.append("\n");
                    for (String string3 : abstractConfigValue.origin().comments()) {
                        AbstractConfigObject.indent(stringBuilder, n + 1);
                        stringBuilder.append("# ");
                        stringBuilder.append(string3);
                        stringBuilder.append("\n");
                    }
                    AbstractConfigObject.indent(stringBuilder, n + 1);
                }
                abstractConfigValue.render(stringBuilder, n + 1, string2, bl);
                stringBuilder.append(",");
                if (!bl) continue;
                stringBuilder.append('\n');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            if (bl) {
                stringBuilder.setLength(stringBuilder.length() - 1);
                stringBuilder.append("\n");
                AbstractConfigObject.indent(stringBuilder, n);
            }
            stringBuilder.append("}");
        }
    }

    private static boolean mapEquals(Map<String, ConfigValue> map2, Map<String, ConfigValue> map3) {
        Set<String> set;
        Set<String> set2 = map2.keySet();
        if (!((Object)set2).equals(set = map3.keySet())) {
            return false;
        }
        for (String string2 : set2) {
            if (map2.get(string2).equals(map3.get(string2))) continue;
            return false;
        }
        return true;
    }

    private static int mapHash(Map<String, ConfigValue> map2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(map2.keySet());
        Collections.sort(arrayList);
        int n = 0;
        for (String string2 : arrayList) {
            n += map2.get(string2).hashCode();
        }
        return 41 * (41 + ((Object)arrayList).hashCode()) + n;
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof ConfigObject;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConfigObject) {
            return this.canEqual(object) && AbstractConfigObject.mapEquals(this, (ConfigObject)object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return AbstractConfigObject.mapHash(this);
    }

    private static UnsupportedOperationException weAreImmutable(String string2) {
        return new UnsupportedOperationException("ConfigObject is immutable, you can't call Map.'" + string2 + "'");
    }

    @Override
    public void clear() {
        throw AbstractConfigObject.weAreImmutable("clear");
    }

    @Override
    public ConfigValue put(String string2, ConfigValue configValue) {
        throw AbstractConfigObject.weAreImmutable("put");
    }

    @Override
    public void putAll(Map<? extends String, ? extends ConfigValue> map2) {
        throw AbstractConfigObject.weAreImmutable("putAll");
    }

    @Override
    public ConfigValue remove(Object object) {
        throw AbstractConfigObject.weAreImmutable("remove");
    }
}

