/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import org.snpeff.interval.Transcript;
import org.snpeff.interval.VariantBnd;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.Hgvs;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffectFusion;
import org.snpeff.util.Gpr;

public class HgvsProtein
extends Hgvs {
    public static boolean debug = false;
    int codonNum;
    int aaPos;
    String aaNew;
    String aaOld;
    boolean hgvsOneLetterAa;
    boolean hgvsOld;
    int lettersPerAa;
    char stop;

    public HgvsProtein(VariantEffect variantEffect) {
        super(variantEffect);
        this.codonNum = variantEffect.getCodonNum();
        this.hgvsOneLetterAa = Config.get().isHgvs1LetterAA();
        this.hgvsOld = Config.get().isHgvsOld();
        this.stop = (char)(this.hgvsOld ? 88 : 42);
        int n = this.lettersPerAa = this.hgvsOneLetterAa ? 1 : 3;
        if (this.marker != null) {
            if (this.codonNum >= 0) {
                this.aaPos = this.codonNum + 1;
            }
            this.aaNew = this.aaCode(variantEffect.getAaAlt());
            this.aaOld = this.aaCode(variantEffect.getAaRef());
        } else {
            this.aaPos = -1;
            this.aaOld = "";
            this.aaNew = "";
        }
    }

    protected String aaCode(char aa1Letter) {
        return this.aaCode(Character.toString(aa1Letter));
    }

    protected String aaCode(String aa1Letter) {
        if (aa1Letter == null || aa1Letter.isEmpty() || aa1Letter.equals("-")) {
            return "";
        }
        if (this.hgvsOld) {
            return aa1Letter.replace('*', 'X');
        }
        if (this.hgvsOneLetterAa) {
            return aa1Letter;
        }
        return this.marker.codonTable().aaThreeLetterCode(aa1Letter);
    }

    protected String del() {
        return "del";
    }

    protected String delins() {
        return "delins" + this.aaNew;
    }

    protected String dup() {
        return "dup";
    }

    protected String fs() {
        return "fs";
    }

    protected String ins() {
        return "ins" + this.aaNew;
    }

    boolean isDel() {
        return !this.aaOld.isEmpty() && this.aaNew.isEmpty();
    }

    protected boolean isDuplication() {
        String aaRef = this.variantEffect.getAaRef().toUpperCase();
        String aaAlt = this.variantEffect.getAaAlt().toUpperCase();
        String dupAaRef = aaRef + aaRef;
        if (debug) {
            Gpr.debug("AA.Ref: '" + aaRef + "'\tAA.Alt: '" + aaAlt);
        }
        if (aaAlt.equals(dupAaRef)) {
            return true;
        }
        String protein = this.tr.protein();
        if (protein == null) {
            return false;
        }
        aaAlt = this.variantEffect.getAaNetChange();
        int aaEnd = this.variantEffect.getCodonNum();
        int aaStart = aaEnd - aaAlt.length();
        if (aaStart < 0 || aaEnd > protein.length()) {
            return false;
        }
        aaRef = protein.substring(aaStart, aaEnd);
        boolean dup = aaRef.equalsIgnoreCase(aaAlt);
        if (debug) {
            Gpr.debug("SEQUENCE [ " + aaStart + " , " + aaEnd + " ]: '" + aaRef + "'\n\tAA Ref       : '" + this.variantEffect.getAaRef() + "'\n\tAA Alt       : '" + this.variantEffect.getAaAlt() + "'\n\tAA Alt (net) : '" + aaAlt + "'\n\tDup?         : " + dup);
        }
        return dup;
    }

    boolean isFs() {
        return this.variantEffect.hasEffectType(EffectType.FRAME_SHIFT);
    }

    boolean isIns() {
        return this.aaOld.isEmpty() && !this.aaNew.isEmpty();
    }

    protected String pos(int codonNum) {
        Transcript tr = this.variantEffect.getTranscript();
        return this.pos(tr, codonNum);
    }

    protected String pos(int start, int end) {
        Transcript tr = this.variantEffect.getTranscript();
        return this.pos(tr, start, end);
    }

    protected String pos(Transcript tr, int codonNum) {
        if (codonNum < 0 || tr == null) {
            return null;
        }
        String protSeq = tr.protein();
        if (codonNum >= protSeq.length()) {
            return null;
        }
        String aa = this.aaCode(protSeq.charAt(codonNum));
        return aa + (codonNum + 1);
    }

    protected String pos(Transcript tr, int start, int end) {
        String posStart = this.pos(tr, start);
        if (posStart == null) {
            return null;
        }
        if (start == end) {
            return posStart;
        }
        String posEnd = this.pos(tr, end);
        if (posEnd == null) {
            return null;
        }
        return posStart + "_" + posEnd;
    }

    protected String posDel() {
        String posStart = this.pos(this.codonNum);
        if (posStart == null) {
            return null;
        }
        if (this.aaOld == null || this.aaOld.isEmpty() || this.aaOld.equals("-")) {
            return null;
        }
        if (this.aaOld.length() == this.lettersPerAa) {
            return posStart;
        }
        int end = this.codonNum + (this.aaOld.length() - this.aaNew.length()) / this.lettersPerAa - 1;
        String posEnd = this.pos(end);
        if (posEnd == null) {
            return null;
        }
        return posStart + "_" + posEnd;
    }

    protected String posDelIns() {
        String posStart = this.pos(this.codonNum);
        if (posStart == null) {
            return null;
        }
        if (this.variantEffect.hasEffectType(EffectType.FRAME_SHIFT)) {
            return posStart;
        }
        if (this.aaOld == null || this.aaOld.isEmpty() || this.aaOld.equals("-")) {
            this.aaOld = "";
        }
        if (this.aaOld.length() == this.lettersPerAa) {
            return posStart;
        }
        int end = this.codonNum + this.aaOld.length() / this.lettersPerAa - 1;
        String posEnd = this.pos(end);
        if (posEnd == null) {
            return null;
        }
        return posStart + "_" + posEnd;
    }

    protected String posDup() {
        int start;
        int end;
        int netLen = this.aaNew.length() / this.lettersPerAa;
        if (netLen == 1) {
            start = end = this.codonNum - 1;
        } else {
            end = this.codonNum - 1;
            start = end - (netLen - 1);
        }
        return this.pos(start, end);
    }

    protected String posFs() {
        if (this.codonNum < 0) {
            return null;
        }
        Transcript tr = this.variantEffect.getTranscript();
        String protSeq = tr.protein();
        if (this.codonNum >= protSeq.length()) {
            return null;
        }
        if (!this.variant.isMixed()) {
            Transcript newTr = tr.apply(this.variant);
            String newProtSeq = newTr.protein();
            int len = Math.min(protSeq.length(), newProtSeq.length());
            for (int cn = this.codonNum; cn < len; ++cn) {
                char newAa;
                char aa = protSeq.charAt(cn);
                if (aa == (newAa = newProtSeq.charAt(cn))) continue;
                return this.aaCode(aa) + (cn + 1);
            }
        }
        return this.aaCode(protSeq.charAt(this.codonNum)) + (this.codonNum + 1);
    }

    protected String posIns() {
        int start = this.codonNum - 1;
        int end = this.codonNum;
        return this.pos(start, end);
    }

    protected String posSnpOrMnp() {
        return this.pos(this.codonNum);
    }

    void simplifyAminoAcids() {
        this.simplifyAminoAcidsLeft();
        this.simplifyAminoAcidsRight();
    }

    void simplifyAminoAcidsLeft() {
        while (!this.aaOld.isEmpty() && !this.aaNew.isEmpty()) {
            String an;
            String ao = this.aaOld.substring(0, this.lettersPerAa);
            if (ao.equals(an = this.aaNew.substring(0, this.lettersPerAa))) {
                this.aaOld = this.aaOld.substring(this.lettersPerAa);
                this.aaNew = this.aaNew.substring(this.lettersPerAa);
                ++this.codonNum;
                ++this.aaPos;
                continue;
            }
            return;
        }
    }

    void simplifyAminoAcidsRight() {
        while (!this.aaOld.isEmpty() && !this.aaNew.isEmpty()) {
            int lastAaNewIdx;
            String an;
            int lastAaOldIdx = this.aaOld.length() - this.lettersPerAa;
            String ao = this.aaOld.substring(lastAaOldIdx);
            if (ao.equals(an = this.aaNew.substring(lastAaNewIdx = this.aaNew.length() - this.lettersPerAa))) {
                this.aaOld = this.aaOld.substring(0, lastAaOldIdx);
                this.aaNew = this.aaNew.substring(0, lastAaNewIdx);
                continue;
            }
            return;
        }
    }

    protected String snpOrMnp() {
        if (this.variantEffect.getAaRef().isEmpty() && this.variantEffect.getAaAlt().isEmpty()) {
            if (this.codonNum >= 0) {
                return "" + (this.codonNum + 1);
            }
            return null;
        }
        if (this.variantEffect.hasEffectType(EffectType.STOP_GAINED)) {
            return this.aaOld + this.aaPos + this.stop;
        }
        if (this.variantEffect.hasEffectType(EffectType.STOP_LOST)) {
            return this.aaOld + this.aaPos + this.aaNew + "ext" + this.stop + "?";
        }
        if (this.variantEffect.hasEffectType(EffectType.START_LOST) || this.variantEffect.hasEffectType(EffectType.SYNONYMOUS_START) || this.variantEffect.hasEffectType(EffectType.NON_SYNONYMOUS_START)) {
            return this.aaOld + "1?";
        }
        if (this.variantEffect.hasEffectType(EffectType.SYNONYMOUS_CODING) || this.variantEffect.hasEffectType(EffectType.SYNONYMOUS_STOP)) {
            return this.aaOld + this.aaPos + this.aaNew;
        }
        return this.aaOld + this.aaPos + this.aaNew;
    }

    public String toString() {
        if (this.variant == null || this.marker == null) {
            return null;
        }
        if (this.variantEffect.getEffectType() == EffectType.TRANSCRIPT_DELETED) {
            return this.typeOfReference() + "0?";
        }
        if (!this.variant.isSnp()) {
            this.simplifyAminoAcids();
        }
        String pos = "";
        String protChange = "";
        String prefix = "";
        String suffix = "";
        switch (this.variant.getVariantType()) {
            case INTERVAL: {
                return "";
            }
            case SNP: 
            case MNP: {
                protChange = this.snpOrMnp();
                pos = "";
                break;
            }
            case INV: {
                return "";
            }
            case BND: {
                return this.translocation();
            }
            default: {
                if (this.isFs()) {
                    protChange = this.fs();
                    pos = this.posFs();
                    break;
                }
                if (this.isIns()) {
                    this.duplication = this.isDuplication();
                    if (this.duplication) {
                        protChange = this.dup();
                        pos = this.posDup();
                        break;
                    }
                    protChange = this.ins();
                    pos = this.posIns();
                    break;
                }
                if (this.isDel()) {
                    protChange = this.del();
                    pos = this.posDel();
                    break;
                }
                protChange = this.delins();
                pos = this.posDelIns();
            }
        }
        if (protChange == null || pos == null) {
            return null;
        }
        return prefix + this.typeOfReference() + pos + protChange + suffix;
    }

    protected String translocation() {
        if (!(this.variantEffect instanceof VariantEffectFusion)) {
            return "";
        }
        VariantBnd vtr = (VariantBnd)this.variant;
        VariantEffectFusion veffFusion = (VariantEffectFusion)this.variantEffect;
        if (veffFusion.getTrLeft() == null && veffFusion.getTrRight() == null) {
            return "";
        }
        String chrCoords = "(" + vtr.getChromosomeName() + ";" + vtr.getEndPoint().getChromosomeName() + ")";
        String trLeftStr = "";
        if (veffFusion.getTrLeft() != null) {
            trLeftStr = veffFusion.getTrLeft().getId() + ":" + this.pos(veffFusion.getTrLeft(), veffFusion.getAaNumLeftStart(), veffFusion.getAaNumLeftEnd());
        }
        String trRightStr = "";
        if (veffFusion.getTrRight() != null) {
            trRightStr = veffFusion.getTrRight().getId() + ":" + this.pos(veffFusion.getTrRight(), veffFusion.getAaNumRightStart(), veffFusion.getAaNumRightEnd());
        }
        return "t" + chrCoords + "(" + trLeftStr + ";" + trRightStr + ")";
    }

    protected String typeOfReference() {
        if (!this.hgvsTrId || this.tr == null) {
            return "p.";
        }
        String ver = this.tr.getVersion();
        return this.tr.getId() + (ver.isEmpty() ? "" : "." + ver) + ":p.";
    }
}

