/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jsp;

import freemarker.core.Environment;
import freemarker.ext.jsp.EventForwarding;
import freemarker.ext.jsp.JspTagModelBase;
import freemarker.ext.jsp.SimpleTagDirectiveModel;
import freemarker.ext.jsp.TagTransformModel;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.log.Logger;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.StringUtil;
import java.beans.IntrospectionException;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TaglibFactory
implements TemplateHashModel {
    private static final Logger logger = Logger.getLogger("freemarker.jsp");
    private static final String DEFAULT_JAR_TLD = "META-INF/taglib.tld";
    private static final int LOOKUP_NONE = 0;
    private static final int LOOKUP_WEB_XML = 1;
    private static final int LOOKUP_WEB_APP = 2;
    private static final int ABS_URI = 0;
    private static final int ROOT_REL_URI = 1;
    private static final int NOROOT_REL_URI = 2;
    private final ServletContext ctx;
    private final Map taglibs = new HashMap();
    private final Map locations = new HashMap();
    private int lookupPhase = 0;
    private static final Map dtds = new HashMap();
    static /* synthetic */ Class class$freemarker$ext$jsp$EventForwarding;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$Tag;

    public TaglibFactory(ServletContext ctx) {
        this.ctx = ctx;
    }

    public TemplateModel get(String uri) throws TemplateModelException {
        Map map2 = this.taglibs;
        synchronized (map2) {
            Taglib taglib = (Taglib)this.taglibs.get(uri);
            if (taglib != null) {
                return taglib;
            }
            try {
                TldPath path;
                if (this.lookupPhase == 0) {
                    this.addLocationsFromWebXml();
                    this.lookupPhase = 1;
                }
                if ((path = (TldPath)this.locations.get(uri)) != null) {
                    return this.loadTaglib(path, uri);
                }
                if (this.lookupPhase == 1) {
                    this.addLocationsFromWebApp();
                    this.lookupPhase = 2;
                    path = (TldPath)this.locations.get(uri);
                    if (path != null) {
                        return this.loadTaglib(path, uri);
                    }
                }
                switch (TaglibFactory.getUriType(uri)) {
                    case 0: {
                        throw new TemplateModelException("No mapping defined for " + uri);
                    }
                    case 2: {
                        uri = TaglibFactory.resolveRelativeUri(uri);
                    }
                    case 1: {
                        if (uri.endsWith(".jar") || uri.endsWith(".zip")) {
                            return this.loadTaglib(new TldPath(uri, DEFAULT_JAR_TLD), uri);
                        }
                        return this.loadTaglib(new TldPath(uri), uri);
                    }
                }
                throw new RuntimeException("Cannot happen");
            }
            catch (TemplateModelException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TemplateModelException("Could not load taglib information for " + uri, e);
            }
        }
    }

    private TemplateModel loadTaglib(TldPath tldPath, String uri) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading taglib " + StringUtil.jQuoteNoXSS(uri) + " from location " + StringUtil.jQuoteNoXSS(tldPath));
        }
        Taglib taglib = new Taglib(this.ctx, tldPath, uri);
        this.taglibs.put(uri, taglib);
        this.locations.remove(uri);
        return taglib;
    }

    private static int getUriType(String uri) throws TemplateModelException {
        if (uri == null) {
            throw new TemplateModelException("null is not a valid URI");
        }
        if (uri.length() == 0) {
            throw new TemplateModelException("empty string is not a valid URI");
        }
        char c0 = uri.charAt(0);
        if (c0 == '/') {
            return 1;
        }
        if (c0 < 'a' || c0 > 'z') {
            return 2;
        }
        int colon2 = uri.indexOf(58);
        if (colon2 == -1) {
            return 2;
        }
        for (int i = 1; i < colon2; ++i) {
            char c = uri.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '+' || c == '-' || c == '.') continue;
            return 2;
        }
        return 0;
    }

    public boolean isEmpty() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationsFromWebXml() throws Exception {
        WebXmlParser webXmlParser = new WebXmlParser();
        InputStream in = this.ctx.getResourceAsStream("/WEB-INF/web.xml");
        if (in == null) {
            return;
        }
        try {
            TaglibFactory.parseXml(in, this.ctx.getResource("/WEB-INF/web.xml").toExternalForm(), webXmlParser);
        }
        finally {
            in.close();
        }
    }

    private void addLocationsFromWebApp() throws Exception {
        String path;
        Iterator iter2;
        Set libs = this.ctx.getResourcePaths("/WEB-INF/lib");
        if (libs != null) {
            iter2 = libs.iterator();
            while (iter2.hasNext()) {
                path = (String)iter2.next();
                if (path.endsWith(".jar") || path.endsWith(".zip")) {
                    this.addLocationsFromJarFile(path);
                    continue;
                }
                if (!path.endsWith(".tld")) continue;
                this.addLocationFromTldFile(path);
            }
        }
        if ((libs = this.ctx.getResourcePaths("/WEB-INF")) != null) {
            iter2 = libs.iterator();
            while (iter2.hasNext()) {
                path = (String)iter2.next();
                if (!path.endsWith(".tld")) continue;
                this.addLocationFromTldFile(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationsFromJarFile(String path) throws Exception {
        ZipInputStream zin = new ZipInputStream(this.ctx.getResourceAsStream(path));
        FilterInputStream uin = new FilterInputStream(zin){

            public void close() {
            }
        };
        try {
            ZipEntry ze;
            while ((ze = zin.getNextEntry()) != null) {
                String zname = ze.getName();
                if (!zname.startsWith("META-INF/") || !zname.endsWith(".tld")) continue;
                String url = "jar:" + this.ctx.getResource(path).toExternalForm() + "!" + zname;
                this.addLocationFromTldResource(uin, path, zname, url);
            }
        }
        finally {
            zin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationFromTldFile(String path) throws Exception {
        InputStream in = this.ctx.getResourceAsStream(path);
        try {
            this.addLocationFromTldResource(in, path, null, this.ctx.getResource(path).toExternalForm());
        }
        finally {
            in.close();
        }
    }

    private void addLocationFromTldResource(InputStream uin, String path, String zname, String url) throws Exception {
        String uri = this.getTldUri(uin, url);
        if (uri != null) {
            this.addLocation(zname == null ? "tld file" : "jar file", path, zname, uri);
        }
    }

    private void addLocation(String source, String filePath, String jarItemPath, String uri) {
        TldPath tldPath = new TldPath(filePath, jarItemPath);
        if (this.locations.containsKey(uri)) {
            logger.debug("Ignored duplicate URI " + StringUtil.jQuoteNoXSS(uri) + " in " + source + " " + StringUtil.jQuoteNoXSS(tldPath));
        } else {
            this.locations.put(uri, tldPath);
            if (logger.isDebugEnabled()) {
                logger.debug(source + " assigned URI " + StringUtil.jQuoteNoXSS(uri) + " to location " + StringUtil.jQuoteNoXSS(tldPath));
            }
        }
    }

    private String getTldUri(InputStream in, String url) throws Exception {
        TldUriReader tur = new TldUriReader();
        TaglibFactory.parseXml(in, url, tur);
        return tur.getUri();
    }

    private static void parseXml(InputStream in, String url, DefaultHandler handler) throws Exception {
        InputSource is = new InputSource();
        is.setByteStream(in);
        is.setSystemId(url);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        XMLReader reader = factory.newSAXParser().getXMLReader();
        reader.setEntityResolver(new LocalTaglibDtds());
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.parse(is);
    }

    private static String resolveRelativeUri(String uri) throws TemplateModelException {
        TemplateModel reqHash = Environment.getCurrentEnvironment().getVariable("__FreeMarkerServlet.Request__");
        if (reqHash instanceof HttpRequestHashModel) {
            int lastSlash;
            HttpServletRequest req = ((HttpRequestHashModel)reqHash).getRequest();
            String pi = req.getPathInfo();
            String reqPath = req.getServletPath();
            if (reqPath == null) {
                reqPath = "";
            }
            if ((lastSlash = (reqPath = reqPath + (pi == null ? "" : pi)).lastIndexOf(47)) != -1) {
                return reqPath.substring(0, lastSlash + 1) + uri;
            }
            return '/' + uri;
        }
        throw new TemplateModelException("Can't resolve relative URI " + uri + " as request URL information is unavailable.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        dtds.put("http://java.sun.com/xml/ns/jee/web-jsptaglibrary_2_1.xsd", "web-jsptaglibrary_2_1.xsd");
        dtds.put("http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd", "web-jsptaglibrary_2_0.xsd");
        dtds.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "web-jsptaglibrary_1_2.dtd");
        dtds.put("http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd", "web-jsptaglibrary_1_2.dtd");
        dtds.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", "web-jsptaglibrary_1_1.dtd");
        dtds.put("http://java.sun.com/j2ee/dtds/web-jsptaglibrary_1_1.dtd", "web-jsptaglibrary_1_1.dtd");
        dtds.put("http://java.sun.com/xml/ns/jee/web-app_2_5.xsd", "web-app_2_5.xsd");
        dtds.put("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", "web-app_2_4.xsd");
        dtds.put("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-app_2_3.dtd");
        dtds.put("http://java.sun.com/dtd/web-app_2_3.dtd", "web-app_2_3.dtd");
        dtds.put("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "web-app_2_2.dtd");
        dtds.put("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd", "web-app_2_2.dtd");
    }

    private static final class LocalTaglibDtds
    implements EntityResolver {
        private LocalTaglibDtds() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            String resourceName = (String)dtds.get(publicId);
            if (resourceName == null) {
                resourceName = (String)dtds.get(systemId);
            }
            InputStream resourceStream = resourceName != null ? this.getClass().getResourceAsStream(resourceName) : new ByteArrayInputStream(new byte[0]);
            InputSource is = new InputSource();
            is.setPublicId(publicId);
            is.setSystemId(systemId);
            is.setByteStream(resourceStream);
            return is;
        }
    }

    private static final class TldParser
    extends DefaultHandler {
        private final Map tags = new HashMap();
        private final List listeners = new ArrayList();
        private Locator locator;
        private StringBuffer buf;
        private String tagName;
        private String tagClassName;

        private TldParser() {
        }

        Map getTags() {
            return this.tags;
        }

        List getListeners() {
            return this.listeners;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String nsuri, String localName, String qName, Attributes atts) {
            if ("name".equals(qName) || "tagclass".equals(qName) || "tag-class".equals(qName) || "listener-class".equals(qName)) {
                this.buf = new StringBuffer();
            }
        }

        public void characters(char[] chars, int off, int len) {
            if (this.buf != null) {
                this.buf.append(chars, off, len);
            }
        }

        public void endElement(String nsuri, String localName, String qName) throws SAXParseException {
            if ("name".equals(qName)) {
                if (this.tagName == null) {
                    this.tagName = this.buf.toString().trim();
                }
                this.buf = null;
            } else if ("tagclass".equals(qName) || "tag-class".equals(qName)) {
                this.tagClassName = this.buf.toString().trim();
                this.buf = null;
            } else {
                if ("tag".equals(qName)) {
                    try {
                        Class tagClass = ClassUtil.forName(this.tagClassName);
                        JspTagModelBase impl = (class$javax$servlet$jsp$tagext$Tag == null ? (class$javax$servlet$jsp$tagext$Tag = TaglibFactory.class$("javax.servlet.jsp.tagext.Tag")) : class$javax$servlet$jsp$tagext$Tag).isAssignableFrom(tagClass) ? new TagTransformModel(tagClass) : new SimpleTagDirectiveModel(tagClass);
                        this.tags.put(this.tagName, impl);
                        this.tagName = null;
                        this.tagClassName = null;
                    }
                    catch (IntrospectionException e) {
                        throw new SAXParseException("Can't introspect tag class " + this.tagClassName, this.locator, e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new SAXParseException("Can't find tag class " + this.tagClassName, this.locator, e);
                    }
                }
                if ("listener-class".equals(qName)) {
                    String listenerClass = this.buf.toString().trim();
                    this.buf = null;
                    try {
                        this.listeners.add(ClassUtil.forName(listenerClass).newInstance());
                    }
                    catch (Exception e) {
                        throw new SAXParseException("Can't instantiate listener class " + listenerClass, this.locator, e);
                    }
                }
            }
        }
    }

    private static final class Taglib
    implements TemplateHashModel {
        private final Map tags;

        Taglib(ServletContext ctx, TldPath tldPath, String uri) throws Exception {
            this.tags = Taglib.loadTaglib(ctx, tldPath, uri);
        }

        public TemplateModel get(String key) {
            return (TemplateModel)this.tags.get(key);
        }

        public boolean isEmpty() {
            return this.tags.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Map loadTaglib(ServletContext ctx, TldPath tldPath, String uri) throws Exception {
            TldParser tldParser = new TldParser();
            String filePath = tldPath.filePath;
            InputStream in = ctx.getResourceAsStream(filePath);
            if (in == null) {
                throw new TemplateModelException("Could not find webapp resource " + filePath + " for URI " + uri);
            }
            String fileUrl = ctx.getResource(filePath).toExternalForm();
            try {
                String jarItemPath = tldPath.jarItemPath;
                if (jarItemPath != null) {
                    ZipEntry ze;
                    String zname;
                    ZipInputStream zin = new ZipInputStream(in);
                    do {
                        if ((ze = zin.getNextEntry()) != null) continue;
                        throw new TemplateModelException("Could not find JAR entry " + jarItemPath + " inside webapp resource " + filePath + " for URI " + uri);
                    } while (!(zname = ze.getName()).equals(jarItemPath));
                    TaglibFactory.parseXml(zin, "jar:" + fileUrl + "!" + zname, tldParser);
                } else {
                    TaglibFactory.parseXml(in, fileUrl, tldParser);
                }
            }
            finally {
                in.close();
            }
            EventForwarding eventForwarding = EventForwarding.getInstance(ctx);
            if (eventForwarding != null) {
                eventForwarding.addListeners(tldParser.getListeners());
            } else if (tldParser.getListeners().size() > 0) {
                throw new TemplateModelException("Event listeners specified in the TLD could not be  registered since the web application doesn't have a listener of class " + (class$freemarker$ext$jsp$EventForwarding == null ? (class$freemarker$ext$jsp$EventForwarding = TaglibFactory.class$("freemarker.ext.jsp.EventForwarding")) : class$freemarker$ext$jsp$EventForwarding).getName() + ". To remedy this, add this element to web.xml:\n" + "| <listener>\n" + "|   <listener-class>" + (class$freemarker$ext$jsp$EventForwarding == null ? (class$freemarker$ext$jsp$EventForwarding = TaglibFactory.class$("freemarker.ext.jsp.EventForwarding")) : class$freemarker$ext$jsp$EventForwarding).getName() + "</listener-class>\n" + "| </listener>");
            }
            return tldParser.getTags();
        }
    }

    private static class TldUriReader
    extends DefaultHandler {
        private StringBuffer buf;
        private String uri;

        TldUriReader() {
        }

        String getUri() {
            return this.uri;
        }

        public void startElement(String nsuri, String localName, String qName, Attributes atts) {
            if ("uri".equals(qName)) {
                this.buf = new StringBuffer();
            }
        }

        public void characters(char[] chars, int off, int len) {
            if (this.buf != null) {
                this.buf.append(chars, off, len);
            }
        }

        public void endElement(String nsuri, String localName, String qName) {
            if ("uri".equals(qName)) {
                this.uri = this.buf.toString().trim();
                this.buf = null;
            }
        }
    }

    private class WebXmlParser
    extends DefaultHandler {
        private StringBuffer buf;
        private String uri;
        private String location;
        private Locator locator;

        private WebXmlParser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String nsuri, String localName, String qName, Attributes atts) {
            if ("taglib-uri".equals(qName) || "taglib-location".equals(qName)) {
                this.buf = new StringBuffer();
            }
        }

        public void characters(char[] chars, int off, int len) {
            if (this.buf != null) {
                this.buf.append(chars, off, len);
            }
        }

        public void endElement(String nsuri, String localName, String qName) throws SAXParseException {
            if ("taglib-uri".equals(qName)) {
                this.uri = this.buf.toString().trim();
                this.buf = null;
            } else if ("taglib-location".equals(qName)) {
                this.location = this.buf.toString().trim();
                try {
                    if (TaglibFactory.getUriType(this.location) == 2) {
                        this.location = "/WEB-INF/" + this.location;
                    }
                }
                catch (TemplateModelException e) {
                    throw new SAXParseException(e.getMessage(), this.locator, e);
                }
                this.buf = null;
            } else if ("taglib".equals(qName)) {
                String zname = this.location.endsWith(".jar") || this.location.endsWith(".zip") ? TaglibFactory.DEFAULT_JAR_TLD : null;
                TaglibFactory.this.addLocation("web.xml", this.location, zname, this.uri);
            }
        }
    }

    private static class TldPath {
        final String filePath;
        final String jarItemPath;

        TldPath(String filePath) {
            this(filePath, null);
        }

        TldPath(String filePath, String jarItemPath) {
            this.filePath = filePath;
            this.jarItemPath = jarItemPath;
        }

        public String toString() {
            if (this.jarItemPath == null) {
                return this.filePath;
            }
            return this.filePath + "!" + this.jarItemPath;
        }
    }
}

