/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.exponential;
import DistLib.poisson;
import DistLib.uniform;

public class geometric {
    public static double density(double x2, double p) {
        if (Double.isNaN(x2) || Double.isNaN(p)) {
            return x2 + p;
        }
        if (p <= 0.0 || p >= 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if ((x2 = Math.floor(x2 + 0.5)) < 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(x2)) {
            return 1.0;
        }
        return p * Math.pow(1.0 - p, x2);
    }

    public static double cumulative(double x2, double p) {
        if (Double.isNaN(x2) || Double.isNaN(p)) {
            return x2 + p;
        }
        x2 = Math.floor(x2);
        if (p <= 0.0 || p >= 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(x2)) {
            return 1.0;
        }
        return 1.0 - Math.pow(1.0 - p, x2 + 1.0);
    }

    public static double quantile(double x2, double p) {
        if (Double.isNaN(x2) || Double.isNaN(p)) {
            return x2 + p;
        }
        if (x2 < 0.0 || x2 > 1.0 || p <= 0.0 || p > 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (x2 < 0.0 || x2 >= 1.0 || p <= 0.0 || p > 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 == 0.0) {
            return 0.0;
        }
        return Math.ceil(Math.log(1.0 - x2) / Math.log(1.0 - p) - 1.0);
    }

    public static double random(double p, uniform PRNG) {
        if (Double.isNaN(p) || p <= 0.0 || p >= 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        return poisson.random(exponential.random(PRNG) * ((1.0 - p) / p), PRNG);
    }
}

