/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.samtools.SAMBinaryTagAndUnsignedArrayValue;
import net.sf.samtools.SAMBinaryTagAndValue;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.TagValueAndUnsignedArrayFlag;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.StringUtil;

class BinaryTagCodec {
    private static final int FIXED_TAG_SIZE = 3;
    private static final int FIXED_BINARY_ARRAY_TAG_SIZE = 5;
    private static final long MAX_INT = Integer.MAX_VALUE;
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private static final long MAX_SHORT = 32767L;
    private static final long MAX_USHORT = 65535L;
    private static final long MAX_BYTE = 127L;
    private static final long MAX_UBYTE = 255L;
    final BinaryCodec binaryCodec;

    BinaryTagCodec(BinaryCodec binaryCodec) {
        this.binaryCodec = binaryCodec;
    }

    private static int getBinaryValueSize(Object attributeValue) {
        switch (BinaryTagCodec.getTagValueType(attributeValue)) {
            case 'Z': {
                return ((String)attributeValue).length() + 1;
            }
            case 'A': {
                return 1;
            }
            case 'I': 
            case 'i': {
                return 4;
            }
            case 'S': 
            case 's': {
                return 2;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'f': {
                return 4;
            }
            case 'H': {
                byte[] byteArray = (byte[])attributeValue;
                return byteArray.length * 2 + 1;
            }
            case 'B': {
                int elementSize;
                int numElements = Array.getLength(attributeValue);
                if (attributeValue instanceof byte[]) {
                    elementSize = 1;
                } else if (attributeValue instanceof short[]) {
                    elementSize = 2;
                } else if (attributeValue instanceof int[]) {
                    elementSize = 4;
                } else if (attributeValue instanceof float[]) {
                    elementSize = 4;
                } else {
                    throw new IllegalArgumentException("Unsupported array type: " + attributeValue.getClass());
                }
                return numElements * elementSize + 5;
            }
        }
        throw new IllegalArgumentException("When writing BAM, unrecognized tag type " + attributeValue.getClass().getName());
    }

    static int getTagSize(Object value2) {
        return 3 + BinaryTagCodec.getBinaryValueSize(value2);
    }

    static char getTagValueType(Object value2) {
        if (value2 instanceof String) {
            return 'Z';
        }
        if (value2 instanceof Character) {
            return 'A';
        }
        if (value2 instanceof Float) {
            return 'f';
        }
        if (value2 instanceof Number) {
            if (!(value2 instanceof Byte || value2 instanceof Short || value2 instanceof Integer || value2 instanceof Long)) {
                throw new IllegalArgumentException("Unrecognized tag type " + value2.getClass().getName());
            }
            return BinaryTagCodec.getIntegerType(((Number)value2).longValue());
        }
        if (value2 instanceof byte[] || value2 instanceof short[] || value2 instanceof int[] || value2 instanceof float[]) {
            return 'B';
        }
        throw new IllegalArgumentException("When writing BAM, unrecognized tag type " + value2.getClass().getName());
    }

    private static char getIntegerType(long val) {
        if (val > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Integer attribute value too large to be encoded in BAM");
        }
        if (val > Integer.MAX_VALUE) {
            return 'I';
        }
        if (val > 65535L) {
            return 'i';
        }
        if (val > 32767L) {
            return 'S';
        }
        if (val > 255L) {
            return 's';
        }
        if (val > 127L) {
            return 'C';
        }
        if (val >= -128L) {
            return 'c';
        }
        if (val >= -32768L) {
            return 's';
        }
        if (val >= Integer.MIN_VALUE) {
            return 'i';
        }
        throw new IllegalArgumentException("Integer attribute value too negative to be encoded in BAM");
    }

    void writeTag(short tag, Object value2, boolean isUnsignedArray) {
        this.binaryCodec.writeShort(tag);
        char tagValueType = BinaryTagCodec.getTagValueType(value2);
        this.binaryCodec.writeByte(tagValueType);
        switch (tagValueType) {
            case 'Z': {
                this.binaryCodec.writeString((String)value2, false, true);
                break;
            }
            case 'A': {
                this.binaryCodec.writeByte(((Character)value2).charValue());
                break;
            }
            case 'I': {
                this.binaryCodec.writeUInt((Long)value2);
                break;
            }
            case 'i': {
                this.binaryCodec.writeInt(((Number)value2).intValue());
                break;
            }
            case 's': {
                this.binaryCodec.writeShort(((Number)value2).shortValue());
                break;
            }
            case 'S': {
                this.binaryCodec.writeUShort(((Number)value2).intValue());
                break;
            }
            case 'c': {
                this.binaryCodec.writeByte(((Number)value2).byteValue());
                break;
            }
            case 'C': {
                this.binaryCodec.writeUByte(((Integer)value2).shortValue());
                break;
            }
            case 'f': {
                this.binaryCodec.writeFloat(((Float)value2).floatValue());
                break;
            }
            case 'B': {
                this.writeArray(value2, isUnsignedArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("When writing BAM, unrecognized tag type " + value2.getClass().getName());
            }
        }
    }

    private void writeArray(Object value2, boolean isUnsignedArray) {
        if (value2 instanceof byte[]) {
            this.binaryCodec.writeByte(isUnsignedArray ? 67 : 99);
            byte[] array = (byte[])value2;
            this.binaryCodec.writeInt(array.length);
            for (byte element : array) {
                this.binaryCodec.writeByte(element);
            }
        } else if (value2 instanceof short[]) {
            this.binaryCodec.writeByte(isUnsignedArray ? 83 : 115);
            short[] array = (short[])value2;
            this.binaryCodec.writeInt(array.length);
            for (short element : array) {
                this.binaryCodec.writeShort(element);
            }
        } else if (value2 instanceof int[]) {
            this.binaryCodec.writeByte(isUnsignedArray ? 73 : 105);
            int[] array = (int[])value2;
            this.binaryCodec.writeInt(array.length);
            for (int element : array) {
                this.binaryCodec.writeInt(element);
            }
        } else if (value2 instanceof float[]) {
            this.binaryCodec.writeByte(102);
            float[] array = (float[])value2;
            this.binaryCodec.writeInt(array.length);
            for (float element : array) {
                this.binaryCodec.writeFloat(element);
            }
        } else {
            throw new SAMException("Unrecognized array value type: " + value2.getClass());
        }
    }

    static SAMBinaryTagAndValue readTags(byte[] binaryRep, int offset, int length, SAMFileReader.ValidationStringency validationStringency) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(binaryRep, offset, length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        SAMBinaryTagAndValue head2 = null;
        SAMBinaryTagAndValue tail2 = null;
        while (byteBuffer.hasRemaining()) {
            SAMBinaryTagAndValue tmp;
            short tag = byteBuffer.getShort();
            byte tagType = byteBuffer.get();
            if (tagType != 66) {
                tmp = new SAMBinaryTagAndValue(tag, BinaryTagCodec.readSingleValue(tagType, byteBuffer, validationStringency));
            } else {
                TagValueAndUnsignedArrayFlag valueAndFlag = BinaryTagCodec.readArray(byteBuffer, validationStringency);
                tmp = valueAndFlag.isUnsignedArray ? new SAMBinaryTagAndUnsignedArrayValue(tag, valueAndFlag.value) : new SAMBinaryTagAndValue(tag, valueAndFlag.value);
            }
            if (head2 == null) {
                head2 = tmp;
                tail2 = tmp;
                continue;
            }
            if (tmp.tag > tail2.tag) {
                tail2.insert(tmp);
                tail2 = tmp;
                continue;
            }
            head2 = head2.insert(tmp);
        }
        return head2;
    }

    private static Object readSingleValue(byte tagType, ByteBuffer byteBuffer, SAMFileReader.ValidationStringency validationStringency) {
        switch (tagType) {
            case 90: {
                return BinaryTagCodec.readNullTerminatedString(byteBuffer);
            }
            case 65: {
                return Character.valueOf((char)byteBuffer.get());
            }
            case 73: {
                long val = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                if (val <= Integer.MAX_VALUE) {
                    return (int)val;
                }
                SAMUtils.processValidationError(new SAMValidationError(SAMValidationError.Type.TAG_VALUE_TOO_LARGE, "Tag value " + val + " too large to store as signed integer.", null), validationStringency);
                return val;
            }
            case 105: {
                return byteBuffer.getInt();
            }
            case 115: {
                return (int)byteBuffer.getShort();
            }
            case 83: {
                return byteBuffer.getShort() & 0xFFFF;
            }
            case 99: {
                return (int)byteBuffer.get();
            }
            case 67: {
                return byteBuffer.get() & 0xFF;
            }
            case 102: {
                return Float.valueOf(byteBuffer.getFloat());
            }
            case 72: {
                String hexRep = BinaryTagCodec.readNullTerminatedString(byteBuffer);
                return StringUtil.hexStringToBytes(hexRep);
            }
        }
        throw new SAMFormatException("Unrecognized tag type: " + (char)tagType);
    }

    private static TagValueAndUnsignedArrayFlag readArray(ByteBuffer byteBuffer, SAMFileReader.ValidationStringency validationStringency) {
        Object[] value2;
        byte arrayType = byteBuffer.get();
        boolean isUnsigned = Character.isUpperCase(arrayType);
        int length = byteBuffer.getInt();
        switch (Character.toLowerCase(arrayType)) {
            case 99: {
                byte[] array;
                value2 = array = new byte[length];
                byteBuffer.get(array);
                break;
            }
            case 115: {
                short[] array = new short[length];
                value2 = array;
                for (int i = 0; i < length; ++i) {
                    array[i] = byteBuffer.getShort();
                }
                break;
            }
            case 105: {
                int[] array = new int[length];
                value2 = array;
                for (int i = 0; i < length; ++i) {
                    array[i] = byteBuffer.getInt();
                }
                break;
            }
            case 102: {
                float[] array = new float[length];
                value2 = array;
                for (int i = 0; i < length; ++i) {
                    array[i] = byteBuffer.getFloat();
                }
                break;
            }
            default: {
                throw new SAMFormatException("Unrecognized tag array type: " + (char)arrayType);
            }
        }
        return new TagValueAndUnsignedArrayFlag(value2, isUnsigned);
    }

    private static String readNullTerminatedString(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        int startPosition = byteBuffer.position();
        while (byteBuffer.get() != 0) {
        }
        int endPosition = byteBuffer.position();
        byte[] buf = new byte[endPosition - startPosition - 1];
        byteBuffer.reset();
        byteBuffer.get(buf);
        byteBuffer.get();
        return StringUtil.bytesToString(buf);
    }
}

