/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.Marker;
import com.googlecode.charts4j.Priority;
import com.googlecode.charts4j.Shape;
import com.googlecode.charts4j.ShapeMarker;
import com.googlecode.charts4j.TextMarker;
import com.googlecode.charts4j.collect.Preconditions;

public final class Markers {
    private Markers() {
        throw new AssertionError();
    }

    public static Marker newTextMarker(String text2, Color color, int size2) {
        Preconditions.checkNotNull(text2, "text cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size2 > 0, "The size of this marker has to be > 0");
        return new TextMarker(text2, color, size2, Priority.NORMAL, false);
    }

    public static Marker newFlaggedTextMarker(String text2, Color color, int size2) {
        Preconditions.checkNotNull(text2, "text cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size2 > 0, "The size of this marker has to be > 0");
        return new TextMarker(text2, color, size2, Priority.NORMAL, true);
    }

    public static Marker newShapeMarker(Shape shape, Color color, int size2) {
        Preconditions.checkNotNull(shape, "shape cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size2 > 0, "The size of this marker has to be > 0");
        return new ShapeMarker(shape, color, size2);
    }

    public static Marker newTextMarker(String text2, Color color, int size2, Priority priority) {
        Preconditions.checkNotNull(text2, "text cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size2 > 0, "The size of this marker has to be > 0");
        return new TextMarker(text2, color, size2, priority, false);
    }

    public static Marker newFlaggedTextMarker(String text2, Color color, int size2, Priority priority) {
        Preconditions.checkNotNull(text2, "text cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size2 > 0, "The size of this marker has to be > 0");
        return new TextMarker(text2, color, size2, priority, true);
    }

    public static Marker newShapeMarker(Shape shape, Color color, int size2, Priority priority) {
        Preconditions.checkNotNull(shape, "shape cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size2 > 0, "The size of this marker has to be > 0");
        return new ShapeMarker(shape, color, size2, priority);
    }
}

