/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import java.security.MessageDigest;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DigestScheme
extends RFC2617Scheme {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$auth$DigestScheme != null ? class$org$apache$commons$httpclient$auth$DigestScheme : (class$org$apache$commons$httpclient$auth$DigestScheme = DigestScheme.class$("org.apache.commons.httpclient.auth.DigestScheme")));
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$DigestScheme;

    public DigestScheme(String challenge) throws MalformedChallengeException {
        super(challenge);
        this.getParameters().put("nc", "00000001");
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        LOG.trace("enter DigestScheme.authenticate(Credentials, String, String)");
        UsernamePasswordCredentials usernamepassword = null;
        try {
            usernamepassword = (UsernamePasswordCredentials)credentials;
        }
        catch (ClassCastException classCastException) {
            throw new AuthenticationException("Credentials cannot be used for basic authentication: " + credentials.toString());
        }
        this.getParameters().put("cnonce", DigestScheme.createCnonce());
        this.getParameters().put("methodname", method);
        this.getParameters().put("uri", uri);
        return DigestScheme.authenticate(usernamepassword, this.getParameters());
    }

    public static String authenticate(UsernamePasswordCredentials credentials, Map params) throws AuthenticationException {
        LOG.trace("enter DigestScheme.authenticate(UsernamePasswordCredentials, Map)");
        String digest = DigestScheme.createDigest(credentials.getUserName(), credentials.getPassword(), params);
        return "Digest " + DigestScheme.createDigestHeader(credentials.getUserName(), params, digest);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static String createCnonce() throws AuthenticationException {
        MessageDigest md5Helper;
        LOG.trace("enter DigestScheme.createCnonce()");
        String digAlg = "MD5";
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new AuthenticationException("Unsupported algorithm in HTTP Digest authentication: MD5");
        }
        String cnonce = Long.toString(System.currentTimeMillis());
        cnonce = DigestScheme.encode(md5Helper.digest(HttpConstants.getBytes(cnonce)));
        return cnonce;
    }

    public static String createDigest(String uname, String pwd, Map params) throws AuthenticationException {
        MessageDigest md5Helper;
        LOG.trace("enter DigestScheme.createDigest(String, String, Map)");
        String digAlg = "MD5";
        String uri = (String)params.get("uri");
        String realm = (String)params.get("realm");
        String nonce = (String)params.get("nonce");
        String nc = (String)params.get("nc");
        String cnonce = (String)params.get("cnonce");
        String qop = (String)params.get("qop");
        String method = (String)params.get("methodname");
        if (qop != null) {
            qop = "auth";
        }
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new AuthenticationException("Unsupported algorithm in HTTP Digest authentication: MD5");
        }
        String a2 = String.valueOf(method) + ":" + uri;
        String md5a2 = DigestScheme.encode(md5Helper.digest(HttpConstants.getBytes(a2)));
        String digestValue = String.valueOf(uname) + ":" + realm + ":" + pwd;
        String md5a1 = DigestScheme.encode(md5Helper.digest(HttpConstants.getBytes(digestValue)));
        String serverDigestValue = qop == null ? String.valueOf(md5a1) + ":" + nonce + ":" + md5a2 : String.valueOf(md5a1) + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
        String serverDigest = DigestScheme.encode(md5Helper.digest(HttpConstants.getBytes(serverDigestValue)));
        return serverDigest;
    }

    public static String createDigestHeader(String uname, Map params, String digest) {
        LOG.trace("enter DigestScheme.createDigestHeader(String, Map, String)");
        StringBuffer sb = new StringBuffer();
        String uri = (String)params.get("uri");
        String realm = (String)params.get("realm");
        String nonce = (String)params.get("nonce");
        String nc = (String)params.get("nc");
        String cnonce = (String)params.get("cnonce");
        String opaque = (String)params.get("opaque");
        String response = digest;
        String qop = (String)params.get("qop");
        if (qop != null) {
            qop = "auth";
        }
        String algorithm = "MD5";
        sb.append("username=\"" + uname + "\"").append(", realm=\"" + realm + "\"").append(", nonce=\"" + nonce + "\"").append(", uri=\"" + uri + "\"").append(qop == null ? "" : ", qop=\"" + qop + "\"").append(", algorithm=\"" + algorithm + "\"").append(qop == null ? "" : ", nc=" + nc).append(qop == null ? "" : ", cnonce=\"" + cnonce + "\"").append(", response=\"" + response + "\"").append(opaque == null ? "" : ", opaque=\"" + opaque + "\"");
        return sb.toString();
    }

    private static String encode(byte[] binaryData) {
        LOG.trace("enter DigestScheme.encode(byte[])");
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        int i = 0;
        while (i < 16) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
            ++i;
        }
        return new String(buffer);
    }

    public String getSchemeName() {
        return "digest";
    }
}

