/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

import java.io.IOException;
import java.io.Reader;
import neobio.alignment.IncompatibleScoringSchemeException;
import neobio.alignment.InvalidSequenceException;
import neobio.alignment.PairwiseAlignment;
import neobio.alignment.ScoringScheme;

public abstract class PairwiseAlignmentAlgorithm {
    protected static final char MATCH_TAG = '|';
    protected static final char APPROXIMATE_MATCH_TAG = '+';
    protected static final char MISMATCH_TAG = ' ';
    protected static final char GAP_TAG = ' ';
    protected static final char GAP_CHARACTER = '-';
    protected boolean use_match_tag;
    protected ScoringScheme scoring;
    protected PairwiseAlignment alignment;
    protected int score;
    protected boolean score_computed = false;
    protected boolean sequences_loaded = false;

    public void setScoringScheme(ScoringScheme scoringScheme) {
        if (scoringScheme == null) {
            throw new IllegalArgumentException("Null scoring scheme object.");
        }
        this.scoring = scoringScheme;
        this.use_match_tag = !scoringScheme.isPartialMatchSupported();
        this.alignment = null;
        this.score_computed = false;
    }

    protected boolean useMatchTag() {
        return this.use_match_tag;
    }

    public void loadSequences(Reader reader, Reader reader2) throws IOException, InvalidSequenceException {
        this.alignment = null;
        this.score_computed = false;
        this.sequences_loaded = false;
        this.loadSequencesInternal(reader, reader2);
        this.sequences_loaded = true;
    }

    public void unloadSequences() {
        this.alignment = null;
        this.score_computed = false;
        this.unloadSequencesInternal();
        this.sequences_loaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PairwiseAlignment getPairwiseAlignment() throws IncompatibleScoringSchemeException {
        if (!this.sequences_loaded) {
            throw new IllegalStateException("Sequences have not been loaded.");
        }
        if (this.scoring == null) {
            throw new IllegalStateException("Scoring scheme has not been set.");
        }
        if (this.alignment == null) {
            ScoringScheme scoringScheme = this.scoring;
            synchronized (scoringScheme) {
                this.alignment = this.computePairwiseAlignment();
            }
            this.score = this.alignment.getScore();
            this.score_computed = true;
        }
        return this.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScore() throws IncompatibleScoringSchemeException {
        if (!this.sequences_loaded) {
            throw new IllegalStateException("Sequences have not been loaded.");
        }
        if (this.scoring == null) {
            throw new IllegalStateException("Scoring scheme has not been set.");
        }
        if (!this.score_computed) {
            ScoringScheme scoringScheme = this.scoring;
            synchronized (scoringScheme) {
                this.score = this.computeScore();
            }
            this.score_computed = true;
        }
        return this.score;
    }

    protected abstract void loadSequencesInternal(Reader var1, Reader var2) throws IOException, InvalidSequenceException;

    protected abstract void unloadSequencesInternal();

    protected abstract PairwiseAlignment computePairwiseAlignment() throws IncompatibleScoringSchemeException;

    protected abstract int computeScore() throws IncompatibleScoringSchemeException;

    protected final int scoreSubstitution(char c, char c2) throws IncompatibleScoringSchemeException {
        return this.scoring.scoreSubstitution(c, c2);
    }

    protected final int scoreInsertion(char c) throws IncompatibleScoringSchemeException {
        return this.scoring.scoreInsertion(c);
    }

    protected final int scoreDeletion(char c) throws IncompatibleScoringSchemeException {
        return this.scoring.scoreDeletion(c);
    }

    protected final int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    protected final int max(int n, int n2, int n3) {
        return n >= n2 ? (n >= n3 ? n : n3) : (n2 >= n3 ? n2 : n3);
    }

    protected final int max(int n, int n2, int n3, int n4) {
        int n5 = n >= n2 ? n : n2;
        int n6 = n3 >= n4 ? n3 : n4;
        return n5 >= n6 ? n5 : n6;
    }
}

