/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.ports;

import edsim51sh.ports.Port;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PortPinsDescFrame
extends JFrame
implements MouseListener {
    private Port port;
    private JLabel[] descriptionsLabels = new JLabel[8];
    private JPanel panel = new JPanel();
    private JTextField[] fields = new JTextField[8];
    private JCheckBox alwaysOnTopCheckbox = new JCheckBox();

    public PortPinsDescFrame(boolean isDI, int portNumber, Port port, String[] descriptions, String[] toolTips) {
        int i;
        this.port = port;
        for (int i2 = 0; i2 < 8; ++i2) {
            this.descriptionsLabels[i2] = new JLabel(descriptions[i2]);
            this.descriptionsLabels[i2].setToolTipText(toolTips[i2]);
        }
        this.panel.setBackground(Color.WHITE);
        this.panel.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        Font font = new Font("Monospaced", 1, 14);
        JLabel label = new JLabel("PORT " + portNumber);
        label.setFont(font);
        label.setForeground(Color.BLUE);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.gridwidth = 3;
        this.panel.add((Component)label, gbc);
        for (i = 0; i < 8; ++i) {
            JTextField field = new JTextField();
            field.setEditable(false);
            field.setFont(font);
            field.setHorizontalAlignment(0);
            field.setPreferredSize(new Dimension(30, 30));
            this.fields[i] = field;
        }
        for (i = 0; i < 8; ++i) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = i + 1;
            gbc.insets = insets;
            label = new JLabel("P" + portNumber + "." + (7 - i));
            label.setFont(font);
            this.panel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = i + 1;
            gbc.insets = insets;
            this.panel.add((Component)this.fields[7 - i], gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = i + 1;
            gbc.insets = insets;
            gbc.anchor = 17;
            label = this.descriptionsLabels[7 - i];
            label.setFont(font);
            this.panel.add((Component)label, gbc);
        }
        this.setPinsStates();
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setBackground(Color.WHITE);
        label = new JLabel("always on top");
        label.setFont(font);
        label.setForeground(Color.BLUE);
        checkBoxPanel.add(label);
        this.alwaysOnTopCheckbox.setSelected(true);
        this.alwaysOnTopCheckbox.addMouseListener(this);
        checkBoxPanel.add(this.alwaysOnTopCheckbox);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 3;
        this.panel.add((Component)checkBoxPanel, gbc);
        this.getContentPane().add(this.panel);
        if (isDI) {
            this.setTitle("EdSim51DI - Port " + portNumber);
        } else {
            this.setTitle("EdSim51SH - Port " + portNumber);
        }
        this.pack();
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    public JCheckBox getCheckBox() {
        return this.alwaysOnTopCheckbox;
    }

    public void setPinDescription(int pinNumber, String description) {
        if (pinNumber >= 0 && pinNumber <= 7) {
            this.descriptionsLabels[pinNumber].setText(description);
        }
    }

    public void setPinToolTip(int pinNumber, String tooltip) {
        if (pinNumber >= 0 && pinNumber <= 7) {
            this.descriptionsLabels[pinNumber].setToolTipText(tooltip);
        }
    }

    public void setPinsStates() {
        for (int i = 0; i < 8; ++i) {
            if (this.port.getPortPin(i) == 1) {
                this.fields[i].setText("1");
                continue;
            }
            this.fields[i].setText("0");
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.setAlwaysOnTop(!this.isAlwaysOnTop());
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

