/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh;

import edsim51sh.Aliases;
import edsim51sh.MainPanel;
import edsim51sh.Memory;
import edsim51sh.Text;
import edsim51sh.exceptions.AddressAccessException;
import edsim51sh.exceptions.BitAddressAccessException;
import edsim51sh.exceptions.DuplicateLabelException;
import edsim51sh.exceptions.SyntaxErrorException;
import edsim51sh.exceptions.UnknownLabelException;
import edsim51sh.exceptions.WrongOperandTypeException;
import edsim51sh.instructions.Dummy;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.InstructionInfo;
import edsim51sh.instructions.InstructionSelector;
import edsim51sh.instructions.Operand;
import edsim51sh.instructions.branches.Acall;
import edsim51sh.instructions.branches.Ajmp;
import edsim51sh.instructions.branches.Branch;
import edsim51sh.instructions.branches.Lcall;
import edsim51sh.instructions.branches.Ljmp;
import edsim51sh.instructions.branches.Sjmp;
import edsim51sh.instructions.misc.Db;
import edsim51sh.instructions.misc.Nop;
import java.util.StringTokenizer;
import java.util.Vector;

public class Assembler {
    public static final String[] SFRS = new String[]{"P0", "SP", "DPL", "DPH", "", "", "", "PCON", "TCON", "TMOD", "TL0", "TL1", "TH0", "TH1", "", "", "P1", "", "", "", "", "", "", "", "SCON", "SBUF", "", "", "", "", "", "", "P2", "", "", "", "", "", "", "", "IE", "", "", "", "", "", "", "", "P3", "", "", "", "", "", "", "", "IP", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "PSW", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "ACC", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "B", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    public static final String[] SBITS = new String[]{"P0.0", "P0.1", "P0.2", "P0.3", "P0.4", "P0.5", "P0.6", "P0.7", "IT0", "IE0", "IT1", "IE1", "TR0", "TF0", "TR1", "TF1", "P1.0", "P1.1", "P1.2", "P1.3", "P1.4", "P1.5", "P1.6", "P1.7", "RI", "TI", "RB8", "TB8", "REN", "SM2", "SM1", "SM0", "P2.0", "P2.1", "P2.2", "P2.3", "P2.4", "P2.5", "P2.6", "P2.7", "EX0", "ET0", "EX1", "ET1", "ES", "", "", "EA", "P3.0", "P3.1", "P3.2", "P3.3", "P3.4", "P3.5", "P3.6", "P3.7", "PX0", "PT0", "PX1", "PT1", "PS", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "P", "", "OV", "RS0", "RS1", "F0", "AC", "CY", "", "", "", "", "", "", "", "", "ACC.0", "ACC.1", "ACC.2", "ACC.3", "ACC.4", "ACC.5", "ACC.6", "ACC.7", "", "", "", "", "", "", "", "", "B.0", "B.1", "B.2", "B.3", "B.4", "B.5", "B.6", "B.7", "", "", "", "", "", "", "", ""};
    public static final String[] ALT_SBITS = new String[]{"P0.0", "P0.1", "P0.2", "P0.3", "P0.4", "P0.5", "P0.6", "P0.7", "TCON.0", "TCON.1", "TCON.2", "TCON.3", "TCON.4", "TCON.5", "TCON.6", "TCON.7", "P1.0", "P1.1", "P1.2", "P1.3", "P1.4", "P1.5", "P1.6", "P1.7", "SCON.0", "SCON.1", "SCON.2", "SCON.3", "SCON.4", "SCON.5", "SCON.6", "SCON.7", "P2.0", "P2.1", "P2.2", "P2.3", "P2.4", "P2.5", "P2.6", "P2.7", "IE.0", "IE.1", "IE.2", "IE.3", "IE.4", "IE.5", "IE.6", "IE.7", "P3.0", "P3.1", "P3.2", "P3.3", "P3.4", "P3.5", "P3.6", "P3.7", "IP.0", "IP.1", "IP.2", "IP.3", "IP.4", "IP.5", "IP.6", "IP.7", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "PSW.0", "PSW.1", "PSW.2", "PSW.3", "PSW.4", "PSW.5", "PSW.6", "PSW.7", "", "", "", "", "", "", "", "", "ACC.0", "ACC.1", "ACC.2", "ACC.3", "ACC.4", "ACC.5", "ACC.6", "ACC.7", "", "", "", "", "", "", "", "", "B.0", "B.1", "B.2", "B.3", "B.4", "B.5", "B.6", "B.7", "", "", "", "", "", "", "", ""};
    public static final String[] MNEUMONICS = new String[]{"ADD", "ANL", "CLR", "CPL", "DEC", "INC", "MOV", "MOVC", "MOVX", "ORL", "RL", "RLC", "RR", "RRC", "SETB", "SUBB", "XCH", "XRL", "JMP", "SJMP", "AJMP", "LJMP", "CALL", "ACALL", "LCALL", "CJNE", "DJNZ", "JB", "JNB", "JC", "JNC", "JZ", "JNZ", "RET", "RETI", "DA", "DIV", "MUL", "PUSH", "POP", "SWAP", "NOP"};
    public static final String[] KEYWORDS = new String[]{"DB", "HIGH", "LOW", "ORG", "USING", "EQU", "SET"};
    public static final String[] ADDRESS_OF_REGISTERS = new String[]{"AR0", "AR1", "AR2", "AR3", "AR4", "AR5", "AR6", "AR7"};
    private Vector usingStatements = new Vector();
    private int maxPc = 0;
    private Vector lines = null;
    private Vector labels = new Vector();
    private Vector setLabels = new Vector();
    private boolean isSetStatement = false;
    private Aliases equAliases = new Aliases();
    private Aliases setAliases = new Aliases();
    private boolean isDbStatement = false;
    private String preAssembledLine;
    private MainPanel sim;
    public String codeWithPc = "";

    public Assembler(MainPanel sim, String code) {
        this.sim = sim;
        this.lines = new Vector();
        if (code != null && !code.equals("")) {
            code = Text.putSpaceBetweenDoubleNewLines(code);
            StringTokenizer st = new StringTokenizer(code, "\n");
            int numberOfLines = st.countTokens();
            for (int i = 0; i < numberOfLines; ++i) {
                this.lines.addElement(st.nextToken());
            }
        } else {
            this.lines.addElement("NOP");
        }
    }

    public static boolean isRegister(String s) {
        return s.equals("A") || s.length() == 2 && s.charAt(0) == 'R' && s.charAt(1) >= '0' && s.charAt(1) <= '7';
    }

    private Instruction[] firstPass() throws Exception {
        int i;
        int pc = 0;
        Instruction[] code = new Instruction[65536];
        InstructionSelector selector = new InstructionSelector();
        String spaces = "      ";
        for (i = 0; i < 65536; ++i) {
            code[i] = new Dummy();
        }
        for (i = 0; i < this.lines.size(); ++i) {
            Instruction instruction;
            String line;
            this.preAssembledLine = line = (String)this.lines.elementAt(i);
            if ((line = line.trim()).equals("")) {
                this.codeWithPc = this.codeWithPc + spaces + this.preAssembledLine + "\n";
                continue;
            }
            if ((line = this.removeComment(line)).equals("")) {
                this.codeWithPc = this.codeWithPc + spaces + this.preAssembledLine + "\n";
                continue;
            }
            line = Text.toUpperCaseExceptingQuotedText(line);
            line = this.removeSpacesAroundCommas(line);
            if ((line = this.removeExtraSpaces(line)).equals("END")) {
                this.codeWithPc = this.codeWithPc + spaces + this.preAssembledLine + "\n";
                return code;
            }
            int newPc = this.parseOrgStatement(line);
            if (newPc != -1) {
                pc = newPc;
                if (pc > this.maxPc) {
                    this.maxPc = pc;
                }
                this.codeWithPc = this.codeWithPc + spaces + this.preAssembledLine + "\n";
                continue;
            }
            int temp = this.parseUsingStatement(line);
            if (temp != -1) {
                this.usingStatements.addElement(new Using(temp, pc));
                this.codeWithPc = this.codeWithPc + spaces + this.preAssembledLine + "\n";
                continue;
            }
            if ((line = this.extractLabel(line, this.preAssembledLine, pc)).equals("")) {
                this.codeWithPc = this.codeWithPc + spaces + this.preAssembledLine + "\n";
                continue;
            }
            if ((line = this.extractEquStatement(line, this.preAssembledLine)).equals("")) {
                this.codeWithPc = this.codeWithPc + spaces + this.preAssembledLine + "\n";
                continue;
            }
            this.extractSetStatement(line, this.preAssembledLine, pc);
            if (this.isSetStatement) {
                this.isSetStatement = false;
                this.codeWithPc = this.codeWithPc + spaces + this.preAssembledLine + "\n";
                continue;
            }
            String[] ss = this.extractDbStatement(line);
            while (ss[0] != null) {
                this.isDbStatement = true;
                code[pc] = new Db(Text.parseNumericData(ss[0]));
                if (++pc > this.maxPc) {
                    this.maxPc = pc;
                }
                if (pc > 65535) {
                    return code;
                }
                if (ss[1].equals("")) break;
                ss = this.extractDbStatement(ss[1]);
            }
            if (this.isDbStatement) {
                this.isDbStatement = false;
                this.codeWithPc = this.codeWithPc + spaces + this.preAssembledLine + "\n";
                continue;
            }
            String s = this.equAliases.replaceAlias(line);
            if (s.equals(line)) {
                s = this.setAliases.replaceAlias(line);
            }
            if ((instruction = selector.getInstruction(line = s)) == null) {
                throw new SyntaxErrorException(this.preAssembledLine);
            }
            instruction.preAssembledLine = this.preAssembledLine;
            instruction.extractOperand0String(line);
            instruction.extractOperand1String(line);
            this.codeWithPc = this.codeWithPc + Text.inHex(pc, false, 4) + "| " + this.preAssembledLine + "\n";
            code[pc] = instruction;
            this.reserveOperandPositions(code, pc, instruction.size);
            if ((pc += instruction.size) > this.maxPc) {
                this.maxPc = pc;
            }
            if (pc <= 65535) continue;
            return code;
        }
        return code;
    }

    private void reserveOperandPositions(Instruction[] code, int pc, int instructionSize) {
        if (++pc == 65536) {
            pc = 0;
        }
        for (int i = 1; i < instructionSize; ++i) {
            Nop nop = new Nop();
            code[pc] = nop;
            if (++pc != 65536) continue;
            pc = 0;
        }
    }

    private InstructionInfo[] secondPass(Instruction[] code) throws Exception {
        InstructionInfo[] allInstructions = new InstructionInfo[65536];
        for (int i = 0; i < 65536; ++i) {
            allInstructions[i] = new InstructionInfo("DUMMY", 0);
        }
        for (int pc = 0; pc < this.maxPc; ++pc) {
            Operand operand;
            Instruction instruction;
            if (pc == 65536) {
                return allInstructions;
            }
            try {
                instruction = null;
                Branch branch = (Branch)code[pc];
                this.preAssembledLine = branch.preAssembledLine;
                if (branch.size == 1) {
                    allInstructions[pc] = new InstructionInfo(branch.preAssembledLine, branch.getOpcode());
                    continue;
                }
                String addressString = branch.size == 3 ? branch.getOperand1String() : branch.getOperand0String();
                int address = Text.parseNumericData(addressString, true);
                if (address != 0x1000000) {
                    instruction = this.reformatBranch(branch, pc, address);
                } else if (addressString.equals("$")) {
                    instruction = this.reformatBranch(branch, pc);
                } else {
                    for (int i = 0; i < this.labels.size(); ++i) {
                        if (!addressString.equals(((Label)this.labels.elementAt((int)i)).label)) continue;
                        instruction = this.reformatBranch(branch, addressString, pc, ((Label)this.labels.elementAt((int)i)).value);
                        break;
                    }
                }
                if (instruction == null) {
                    throw new UnknownLabelException(branch.preAssembledLine, addressString);
                }
                allInstructions[pc] = new InstructionInfo(branch.preAssembledLine, instruction.getOpcode());
                operand = new Operand(instruction.operand0);
                if (++pc == 65536) {
                    return allInstructions;
                }
                allInstructions[pc] = new InstructionInfo("", operand.getValue());
                if (instruction.size != 3) continue;
                operand = new Operand(instruction.operand1);
                if (++pc == 65536) {
                    return allInstructions;
                }
                allInstructions[pc] = new InstructionInfo("", operand.getValue());
                continue;
            }
            catch (ClassCastException ex) {
                instruction = code[pc];
                this.preAssembledLine = instruction.preAssembledLine;
                allInstructions[pc] = new InstructionInfo(this.preAssembledLine, instruction.getOpcode());
                if (instruction.size > 1) {
                    operand = new Operand(this.decodeOperand(instruction.getOperand0String(), this.preAssembledLine, instruction.isByteInstruction, pc));
                    if (++pc == 65536) {
                        return allInstructions;
                    }
                    allInstructions[pc] = new InstructionInfo("", operand.getValue());
                }
                if (instruction.size <= 2) continue;
                operand = new Operand(this.decodeOperand(instruction.getOperand1String(), instruction.preAssembledLine, instruction.isByteInstruction, pc));
                if (++pc == 65536) {
                    return allInstructions;
                }
                allInstructions[pc] = new InstructionInfo("", operand.getValue());
            }
        }
        return allInstructions;
    }

    public InstructionInfo[] assemble() throws Exception {
        this.sim.instructions = null;
        Instruction[] code = this.firstPass();
        InstructionInfo[] codeBytes = this.secondPass(code);
        this.sim.instructions = code;
        return codeBytes;
    }

    public static int getSfrAddress(String name) {
        if (name == null || name.equals("")) {
            return -1;
        }
        for (int i = 0; i < SFRS.length; ++i) {
            if (!name.equals(SFRS[i])) continue;
            return i + 128;
        }
        return -1;
    }

    public static String getSfrName(int address) {
        if (address < 128 || address > 255) {
            return "";
        }
        return SFRS[address - 128];
    }

    public static int getSbitAddress(String name) {
        int i;
        if (name == null || name.equals("")) {
            return -1;
        }
        for (i = 0; i < SBITS.length; ++i) {
            if (!name.equals(SBITS[i])) continue;
            return i + 128;
        }
        for (i = 0; i < ALT_SBITS.length; ++i) {
            if (!name.equals(ALT_SBITS[i])) continue;
            return i + 128;
        }
        return -1;
    }

    public static String getSbitName(int address) {
        if (address < 128 || address > 255) {
            return "";
        }
        return SBITS[address - 128];
    }

    public int getAddress(String name) throws AddressAccessException {
        int address = Assembler.getSfrAddress(name = name.trim().toUpperCase());
        if (address == -1) {
            address = Assembler.getSbitAddress(name);
        }
        if (address == -1) {
            throw new AddressAccessException(name);
        }
        return address;
    }

    private String replaceDollarSymbol(String s) {
        String temp = s.replaceFirst("SJMP", "").trim();
        if (temp.equals("$")) {
            return "-2";
        }
        return s;
    }

    private String removeComment(String s) {
        int semicolonIndex = s.indexOf(59);
        if (semicolonIndex == -1) {
            return s;
        }
        if (semicolonIndex == 0) {
            return "";
        }
        return s.substring(0, semicolonIndex).trim();
    }

    private String removeExtraSpaces(String s) {
        int errorIndex = (s = s.replace('\t', ' ')).indexOf(32);
        if (errorIndex == -1) {
            return s;
        }
        return s.substring(0, errorIndex) + " " + s.substring(errorIndex).trim();
    }

    private String removeSpacesAroundCommas(String s) {
        String result = "";
        StringTokenizer st = new StringTokenizer(s, ",", true);
        int count = st.countTokens();
        for (int i = 0; i < count; ++i) {
            result = result + st.nextToken().trim();
        }
        return result;
    }

    private Instruction reformatBranch(Branch branch, int currentPc, int destinationAddress) throws Exception {
        return this.reformatBranch(branch, "", currentPc, destinationAddress, false);
    }

    private Instruction reformatBranch(Branch branch, int currentPc) throws Exception {
        return this.reformatBranch(branch, "$", currentPc, -1, true);
    }

    private Instruction reformatBranch(Branch branch, String label, int currentPc, int address) throws Exception {
        return this.reformatBranch(branch, label, currentPc, address, true);
    }

    private Instruction reformatBranch(Branch branch, String label, int currentPc, int address, boolean isLabelAddress) throws Exception {
        int rel;
        if (branch.mneumonic.equals("JMP")) {
            if (label.equals("$")) {
                Sjmp sjmp = new Sjmp();
                sjmp.operand0 = -2;
                return sjmp;
            }
            int rel2 = isLabelAddress ? address - (currentPc + 2) : address;
            if (rel2 > -128 && rel2 < 127) {
                Sjmp sjmp = new Sjmp();
                sjmp.operand0 = rel2;
                return sjmp;
            }
            if (address < 0 || address > 65535) {
                throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String());
            }
            if ((currentPc + 2) / 2048 == address / 2048) {
                Ajmp ajmp = new Ajmp(address >> 8 & 7);
                ajmp.operand0 = address & 0xFF;
                return ajmp;
            }
            throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String() + " - target out of range");
        }
        if (branch.mneumonic.equals("CALL")) {
            if (label.equals("$")) {
                Acall acall = new Acall(currentPc >> 8 & 7);
                acall.operand0 = currentPc & 0xFF;
                return acall;
            }
            if (address < 0 || address > 65535) {
                throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String());
            }
            if ((currentPc + 2) / 2048 == address / 2048) {
                Acall acall = new Acall(address >> 8 & 7);
                acall.operand0 = address & 0xFF;
                return acall;
            }
            throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String() + " - target out of range");
        }
        if (branch.mneumonic.equals("SJMP")) {
            int rel3;
            Sjmp sjmp = new Sjmp();
            if (label.equals("$")) {
                sjmp.operand0 = -2;
                return sjmp;
            }
            if (isLabelAddress) {
                rel3 = address - (currentPc + 2);
                if (rel3 < -128 || rel3 > 127) {
                    throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String() + " - target out of range");
                }
            } else {
                rel3 = address;
            }
            sjmp.operand0 = rel3;
            return sjmp;
        }
        if (branch.mneumonic.equals("AJMP")) {
            if (address < 0 || address > 65535) {
                throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String());
            }
            if (label.equals("$")) {
                Ajmp ajmp = new Ajmp(currentPc >> 8 & 7);
                ajmp.operand0 = currentPc & 0xFF;
                return ajmp;
            }
            if (isLabelAddress) {
                if ((currentPc + 2) / 2048 == address / 2048) {
                    Ajmp ajmp = new Ajmp(address >> 8 & 7);
                    ajmp.operand0 = address & 0xFF;
                    return ajmp;
                }
                throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String() + " - target out of range");
            }
            Ajmp ajmp = new Ajmp(address >> 8 & 7);
            ajmp.operand0 = address & 0xFF;
            return ajmp;
        }
        if (branch.mneumonic.equals("LJMP")) {
            if (address < 0 || address > 65535) {
                throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String());
            }
            Ljmp ljmp = new Ljmp();
            if (label.equals("$")) {
                ljmp.operand0 = currentPc >> 8;
                ljmp.operand1 = currentPc & 0xFF;
                return ljmp;
            }
            ljmp.operand0 = address >> 8;
            ljmp.operand1 = address & 0xFF;
            return ljmp;
        }
        if (branch.mneumonic.equals("ACALL")) {
            if (address < 0 || address > 65535) {
                throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String());
            }
            if (label.equals("$")) {
                Acall acall = new Acall(currentPc >> 8 & 7);
                acall.operand0 = currentPc & 0xFF;
                return acall;
            }
            if (isLabelAddress) {
                if ((currentPc + 2) / 2048 == address / 2048) {
                    Acall acall = new Acall(address >> 8 & 7);
                    acall.operand0 = address & 0xFF;
                    return acall;
                }
                throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String() + " - target out of range");
            }
            Acall acall = new Acall(address >> 8 & 7);
            acall.operand0 = address & 0xFF;
            return acall;
        }
        if (branch.mneumonic.equals("LCALL")) {
            if (address < 0 || address > 65535) {
                throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String());
            }
            Lcall lcall = new Lcall();
            if (label.equals("$")) {
                lcall.operand0 = currentPc >> 8;
                lcall.operand1 = currentPc & 0xFF;
                return lcall;
            }
            lcall.operand0 = address >> 8;
            lcall.operand1 = address & 0xFF;
            return lcall;
        }
        if (branch.size == 2) {
            int rel4;
            if (label.equals("$")) {
                branch.operand0 = -2;
                return branch;
            }
            if (isLabelAddress) {
                rel4 = address - (currentPc + 2);
                if (rel4 < -128 || rel4 > 127) {
                    throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String() + " - target out of range");
                }
            } else {
                rel4 = address;
            }
            branch.operand0 = rel4;
            return branch;
        }
        branch.operand0 = this.decodeOperand(branch.getOperand0String(), branch.preAssembledLine, branch.isByteInstruction, currentPc);
        if (label.equals("$")) {
            branch.operand1 = -3;
            return branch;
        }
        if (isLabelAddress) {
            rel = address - (currentPc + 3);
            if (rel < -128 || rel > 127) {
                throw new SyntaxErrorException(branch.mneumonic.trim() + " " + branch.getOperand0String() + "," + branch.getOperand1String() + " - target out of range");
            }
        } else {
            rel = address;
        }
        branch.operand1 = rel;
        return branch;
    }

    public int toSignedNumber(int unsignedData) {
        if (unsignedData >= 0 && unsignedData <= 127) {
            return unsignedData;
        }
        return unsignedData - 256;
    }

    private String extractLabel(String line, String preAssembledLine, int pc) throws Exception {
        int colonIndex = line.indexOf(58);
        if (colonIndex != -1) {
            String label = line.substring(0, colonIndex).trim();
            if (!this.isValidLabel(label)) {
                throw new UnknownLabelException(preAssembledLine, label, true);
            }
            if (this.labelExists(label)) {
                throw new DuplicateLabelException(preAssembledLine, label);
            }
            Label l = new Label(label, pc);
            this.labels.addElement(l);
            line = colonIndex == line.length() - 1 ? "" : line.substring(colonIndex + 1).trim();
        }
        return line;
    }

    private boolean isValidLabel(String label) {
        if (label.length() == 0 || Assembler.isRegister(label) || this.isKeywordOrSfr(label) || label.charAt(0) >= '0' && label.charAt(0) <= '9') {
            return false;
        }
        for (int i = 0; i < label.length(); ++i) {
            if (label.charAt(i) >= 'A' && label.charAt(i) <= 'Z' || label.charAt(i) >= '0' && label.charAt(i) <= '9' || label.charAt(i) == '_') continue;
            return false;
        }
        return true;
    }

    private String escapeQuotesFromDb(String s) {
        String temp = s;
        if ((s = s.replaceFirst("DB ", "").trim()).length() < 4) {
            return temp;
        }
        Vector<Character> v = new Vector<Character>();
        for (int i = 1; i < s.length() - 2; ++i) {
            if (s.charAt(i) == '\\' && s.charAt(i + 1) == '\"') continue;
            v.addElement(new Character(s.charAt(i)));
        }
        char[] cs = new char[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            cs[i] = ((Character)v.elementAt(i)).charValue();
        }
        return "DB \"" + new String(cs) + s.charAt(s.length() - 2) + "\"";
    }

    private String[] extractDbStatement(String line) throws Exception {
        if (line.startsWith("DB \"") && line.endsWith("\"")) {
            line = this.escapeQuotesFromDb(line);
        }
        String[] result = new String[2];
        if (line.startsWith("DB ")) {
            String s = line.replaceFirst("DB ", "").trim();
            if (s.equals("\"\"")) {
                result[1] = "";
                return result;
            }
            if (s.length() > 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
                result[0] = String.valueOf((int)s.charAt(1));
                result[1] = "DB \"" + s.substring(2);
                return result;
            }
            String temp = s;
            int spaceIndex = s.indexOf(44);
            if (spaceIndex != -1) {
                temp = "DB " + s.substring(spaceIndex + 1).trim();
                s = s.substring(0, spaceIndex).trim();
            } else {
                temp = "";
            }
            if (this.isKeyword(s)) {
                throw new SyntaxErrorException(s + " (keyword) cannot be used in DB");
            }
            int value = Text.parseNumericData(s);
            if (value == 0x1000000) {
                value = Assembler.getSfrAddress(s);
                if (value == -1) {
                    value = Assembler.getSbitAddress(s);
                }
                if (value == -1) {
                    Label l = this.getLabel(s);
                    if (l == null) {
                        throw new SyntaxErrorException("DB statement - " + line);
                    }
                    value = l.value;
                }
            }
            if ((value &= 0xFF) < 0) {
                value = 256 + value;
            }
            result[0] = String.valueOf(value);
            result[1] = temp;
            return result;
        }
        result[0] = null;
        result[1] = line;
        return result;
    }

    private void extractSetStatement(String line, String preAssembledLine, int pc) throws Exception {
        String s = line;
        if (s.indexOf(" SET ") != -1) {
            s = s.replaceFirst(" SET", "");
            int spaceIndex = s.indexOf(32);
            String label = s.substring(0, spaceIndex).trim();
            s = s.substring(spaceIndex, s.length()).trim();
            if (!this.isValidLabel(label)) {
                throw new SyntaxErrorException(line);
            }
            if (this.labelExists(label) || this.equAliases.aliasAlreadyExists(label)) {
                throw new DuplicateLabelException(preAssembledLine, label);
            }
            this.setAliases.removePreviousAlias(label);
            if (Assembler.isRegister(s)) {
                this.setAliases.addAlias(s, label);
            } else {
                int data = Assembler.getSfrAddress(s);
                if (data == -1) {
                    data = Assembler.getSbitAddress(s);
                }
                if (data == -1) {
                    data = Text.parseNumericData(s, true);
                }
                if (data == 0x1000000) {
                    throw new SyntaxErrorException(line);
                }
                SetLabel sl = this.getSetLabel(label);
                if (sl == null) {
                    sl = new SetLabel(label, data, pc);
                    this.setLabels.addElement(sl);
                } else {
                    sl.addValue(data, pc);
                }
            }
            this.isSetStatement = true;
        }
    }

    private String extractEquStatement(String line, String preAssembledLine) throws Exception {
        String s = line;
        if (s.indexOf(" EQU ") != -1) {
            int spaceIndex = (s = s.replaceFirst(" EQU", "")).indexOf(32);
            if (spaceIndex == -1) {
                throw new SyntaxErrorException(line);
            }
            String label = s.substring(0, spaceIndex).trim();
            s = s.substring(spaceIndex, s.length()).trim();
            if (!this.isValidLabel(label)) {
                throw new UnknownLabelException(preAssembledLine, label, true);
            }
            if (this.labelExists(label) || this.setLabelExists(label) || this.equAliases.aliasAlreadyExists(label) || this.setAliases.aliasAlreadyExists(label)) {
                throw new DuplicateLabelException(preAssembledLine, label);
            }
            if (Assembler.isRegister(s)) {
                this.equAliases.addAlias(s, label);
                line = "";
            } else {
                int data = Assembler.getSfrAddress(s);
                if (data == -1) {
                    data = Assembler.getSbitAddress(s);
                }
                if (data == -1) {
                    data = Text.parseNumericData(s, true);
                }
                if (data == 0x1000000) {
                    throw new SyntaxErrorException(line);
                }
                Label l = new Label(label, data);
                this.labels.addElement(l);
                line = "";
            }
        }
        return line;
    }

    private boolean labelExists(String label) {
        if (this.labels == null) {
            return false;
        }
        for (int i = 0; i < this.labels.size(); ++i) {
            String s = ((Label)this.labels.elementAt((int)i)).label;
            if (!label.trim().equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean setLabelExists(String label) {
        if (this.setLabels == null) {
            return false;
        }
        for (int i = 0; i < this.setLabels.size(); ++i) {
            String s = ((SetLabel)this.setLabels.elementAt((int)i)).label;
            if (!label.trim().equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean isKeyword(String s) {
        int i;
        for (i = 0; i < KEYWORDS.length; ++i) {
            if (!KEYWORDS[i].equals(s)) continue;
            return true;
        }
        for (i = 0; i < MNEUMONICS.length; ++i) {
            if (!MNEUMONICS[i].equals(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isKeywordOrSfr(String s) {
        if (this.isKeyword(s)) {
            return true;
        }
        return Assembler.getSfrAddress(s) != -1 || Assembler.getSbitAddress(s) != -1;
    }

    private int decodeOperand(String operandString, String preAssembledLine, boolean isByteInstruction, int pc) throws Exception {
        int dotIndex;
        int operand;
        if (isByteInstruction) {
            operand = Assembler.getSfrAddress(operandString);
            if (operand == -1 && Assembler.getSbitAddress(operandString) != -1) {
                throw new WrongOperandTypeException(preAssembledLine, true);
            }
            if (operand == -1) {
                operand = this.decodeAddressOfRegister(operandString, pc);
            }
        } else {
            operand = Assembler.getSbitAddress(operandString);
            if (operand == -1 && Assembler.getSfrAddress(operandString) != -1) {
                throw new WrongOperandTypeException(preAssembledLine, false);
            }
        }
        if (operand != -1) {
            return operand;
        }
        boolean isHighByte = false;
        if (operandString.length() > 5 && operandString.startsWith("LOW(") && operandString.endsWith(")")) {
            operandString = operandString.substring(4, operandString.length() - 1).trim();
        } else if (operandString.length() > 6 && operandString.startsWith("HIGH(") && operandString.endsWith(")")) {
            operandString = operandString.substring(5, operandString.length() - 1).trim();
            isHighByte = true;
        }
        int bitNumber = -1;
        if (!isByteInstruction && (dotIndex = operandString.indexOf(46)) != -1 && dotIndex != operandString.length() - 1 && dotIndex == operandString.lastIndexOf(46)) {
            String extension = operandString.substring(dotIndex + 1).trim();
            if (extension.length() != 1) {
                throw new SyntaxErrorException(preAssembledLine);
            }
            bitNumber = extension.charAt(0) - 48;
            if (bitNumber > 7) {
                throw new SyntaxErrorException(preAssembledLine);
            }
            operandString = operandString.substring(0, dotIndex);
        }
        if ((operand = Text.parseNumericData(operandString, true)) != 0x1000000) {
            if (operand < -128) {
                operand = 65536 + operand;
            } else if (operand < 0) {
                operand = 256 + operand;
            }
            if (bitNumber != -1) {
                return this.addBitNumber(operand, bitNumber);
            }
            if (isHighByte) {
                return operand >> 8 & 0xFF;
            }
            return operand & 0xFF;
        }
        Label labelInfo = this.getLabel(operandString);
        if (labelInfo != null) {
            if (bitNumber != -1) {
                return this.addBitNumber(labelInfo.value, bitNumber);
            }
            if (isHighByte) {
                return labelInfo.value >> 8 & 0xFF;
            }
            return labelInfo.value & 0xFF;
        }
        SetLabel setLabelInfo = this.getSetLabel(operandString);
        if (setLabelInfo == null) {
            throw new UnknownLabelException(preAssembledLine, operandString);
        }
        int setLabelValue = setLabelInfo.getValue(pc);
        if (setLabelValue == 0x1000000) {
            throw new UnknownLabelException(preAssembledLine, operandString);
        }
        if (bitNumber != -1) {
            return this.addBitNumber(setLabelValue, bitNumber);
        }
        if (isHighByte) {
            return setLabelValue >> 8 & 0xFF;
        }
        return setLabelValue & 0xFF;
    }

    private int addBitNumber(int operand, int bitNumber) throws BitAddressAccessException {
        if (Memory.isBitAddressable(operand)) {
            operand = operand >= 32 && operand <= 47 ? (operand - 32) * 8 + bitNumber : (operand += bitNumber);
            return operand;
        }
        BitAddressAccessException ex = new BitAddressAccessException(operand);
        ex.isBitAddressableError(true);
        throw ex;
    }

    private int decodeAddressOfRegister(String operandString, int pc) {
        for (int i = 0; i < ADDRESS_OF_REGISTERS.length; ++i) {
            if (!operandString.equals(ADDRESS_OF_REGISTERS[i])) continue;
            if (this.usingStatements.size() == 0) {
                return i;
            }
            int bank = 0;
            for (int j = 0; j < this.usingStatements.size(); ++j) {
                Using using = (Using)this.usingStatements.elementAt(j);
                if (pc < using.pc) continue;
                bank = using.bank;
            }
            return bank * 8 + i;
        }
        return -1;
    }

    private Label getLabel(String label) {
        for (int i = 0; i < this.labels.size(); ++i) {
            Label l = (Label)this.labels.elementAt(i);
            if (!l.label.equals(label)) continue;
            return l;
        }
        return null;
    }

    private SetLabel getSetLabel(String label) {
        for (int i = 0; i < this.setLabels.size(); ++i) {
            SetLabel sl = (SetLabel)this.setLabels.elementAt(i);
            if (!sl.label.equals(label)) continue;
            return sl;
        }
        return null;
    }

    private int parseOrgStatement(String line) throws SyntaxErrorException {
        int address;
        if (line.startsWith("ORG ") && (address = Text.parseNumericData(line.substring(4), true)) != 0x1000000) {
            if (address < 0 || address > 65535) {
                throw new SyntaxErrorException(line);
            }
            return address;
        }
        return -1;
    }

    private int parseUsingStatement(String line) throws SyntaxErrorException {
        if (line.startsWith("USING ")) {
            try {
                int bank = Integer.parseInt(line.replaceFirst("USING ", ""));
                if (bank < 0 || bank > 2) {
                    throw new SyntaxErrorException(line);
                }
                return bank;
            }
            catch (Exception ex) {
                throw new SyntaxErrorException(line);
            }
        }
        return -1;
    }

    private class Using {
        int bank;
        int pc;

        Using(int bank, int pc) {
            this.bank = bank;
            this.pc = pc;
        }
    }

    private class Label {
        String label;
        int value;

        Label(String label, int value) {
            this.label = label;
            this.value = value;
        }
    }

    private class SetLabel {
        String label;
        Vector values = new Vector();
        Vector codePositions = new Vector();

        SetLabel(String label, int value, int pc) {
            this.label = label;
            this.values.addElement(new Integer(value));
            this.codePositions.addElement(new Integer(pc));
        }

        void addValue(int value, int pc) {
            this.values.addElement(new Integer(value));
            this.codePositions.addElement(new Integer(pc));
        }

        int getValue(int pc) {
            for (int i = 0; i < this.codePositions.size(); ++i) {
                int codePosition = (Integer)this.codePositions.elementAt(i);
                if (codePosition <= pc) continue;
                if (i == 0) {
                    return 0x1000000;
                }
                return (Integer)this.values.elementAt(i - 1);
            }
            return (Integer)this.values.elementAt(this.values.size() - 1);
        }
    }
}

