/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.Comparator;
import edsim51di.DAC;
import edsim51di.Gui;
import edsim51di.PeripheralMainPanel;
import edsim51sh.EdSim51Button;
import edsim51sh.InfoButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ADCComparatorGraphics
extends PeripheralMainPanel
implements ActionListener,
ChangeListener {
    private InfoButton infoButton = new InfoButton(this, "Analogue-to-digital converter mode:\nA positive edge on WR initiates a conversion.\nA conversion takes approximately 25 us to complete.\nUpon completion, INTR goes low and stays low until\nanother conversion is initiated.\nThe internal register is passed to the output pins\nwhen RD is low.\n\nComparator mode:\nThe analogue voltage input is fed to the non-inverting pin.\nThe output from the digital-to-analogue converter is fed\nto the inverting pin.\nThe comparator output is therefore high when the input\nvoltage is greater than the output from the DAC.", "EdSim51DI - ADC/Comparator Information", "information");
    private JSlider slider = new JSlider();
    private JTextField inputField = new JTextField();
    private JTextField internalBitField = new JTextField();
    private EdSim51Button switchButton = new EdSim51Button();
    private JLabel inputLabel = new JLabel("input");
    private Dimension sliderDimensionSmall = new Dimension(20, 100);
    private Dimension sliderDimensionLarge = new Dimension(30, 150);
    private Dimension inputFieldDimensionSmall = new Dimension(60, 20);
    private Dimension inputFieldDimensionLarge = new Dimension(90, 30);
    private Dimension internalBitFieldDimensionSmall = new Dimension(80, 20);
    private Dimension internaldBitFieldDimensionLarge = new Dimension(120, 30);
    private Border internalBitFieldBorder;
    private Color internalBitFieldBackground;
    private boolean isAdc;
    private Board board;
    private DAC dac;
    private Comparator comparator;
    private float voltage = 0.0f;

    ADCComparatorGraphics(Board board, DAC dac, Comparator comparator) {
        this.board = board;
        this.dac = dac;
        this.comparator = comparator;
        String s = board.getHardwareSetting("adc");
        this.isAdc = s == null || s.equals("E");
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        GridBagConstraints gbc = new GridBagConstraints();
        this.slider.setOrientation(1);
        this.slider.setMinimum(0);
        this.slider.setMaximum(255);
        this.slider.setValue(0);
        this.slider.addChangeListener(this);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.add((Component)this.slider, gbc);
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        panel.setLayout(new GridBagLayout());
        this.inputField.setText("0.0 V");
        this.inputField.setHorizontalAlignment(0);
        this.inputField.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)this.inputField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)this.inputLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)this.infoButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.add((Component)panel, gbc);
        this.internalBitField.setEditable(false);
        this.internalBitFieldBorder = this.internalBitField.getBorder();
        this.internalBitFieldBackground = this.internalBitField.getBackground();
        this.internalBitField.setText("11111111");
        this.internalBitField.setForeground(Color.RED);
        this.internalBitField.setHorizontalAlignment(0);
        this.internalBitField.setToolTipText("internal register");
        this.setInternalBitFieldVisible();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        this.add((Component)this.internalBitField, gbc);
        this.setSwitchButtonText();
        this.switchButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        this.add((Component)this.switchButton, gbc);
    }

    boolean isADCEnabled() {
        return this.isAdc;
    }

    int getVoltage() {
        return this.slider.getValue();
    }

    void setVoltage(int voltage) {
        this.slider.setValue(voltage);
    }

    @Override
    void setSize(boolean small) {
        Dimension internalBitFieldDimension;
        Dimension inputFieldDimension;
        int size;
        if (small) {
            size = 12;
            inputFieldDimension = this.inputFieldDimensionSmall;
            internalBitFieldDimension = this.internalBitFieldDimensionSmall;
            Gui.setSize(this.slider, this.sliderDimensionSmall);
        } else {
            size = 18;
            inputFieldDimension = this.inputFieldDimensionLarge;
            internalBitFieldDimension = this.internaldBitFieldDimensionLarge;
            Gui.setSize(this.slider, this.sliderDimensionLarge);
        }
        Gui.setSize(this.inputField, inputFieldDimension, 0, size);
        Gui.setSize(this.internalBitField, internalBitFieldDimension, 0, size);
        Gui.setFont(this.inputLabel, 1, size);
        this.switchButton.setSize("ADC", "Comparator", 1, size);
        this.infoButton.setSize(small);
    }

    void setInternalBitField(boolean[] bits, boolean passedToOutput) {
        if (!this.isAdc) {
            return;
        }
        String s = "";
        for (int i = 0; i < 8; ++i) {
            s = bits[i] ? "1" + s : "0" + s;
        }
        if (passedToOutput) {
            this.internalBitField.setForeground(Color.BLACK);
            this.internalBitField.setToolTipText("internal register (on output pins)");
        } else {
            this.internalBitField.setForeground(Color.RED);
            this.internalBitField.setToolTipText("internal register");
        }
        this.internalBitField.setText(s);
    }

    private void setSwitchButtonText() {
        if (this.isAdc) {
            this.switchButton.setText("ADC");
            this.switchButton.setToolTipText("switch to comparator");
        } else {
            this.switchButton.setText("Comparator");
            this.switchButton.setToolTipText("switch to ADC");
        }
    }

    private String removeVoltageSymbol() {
        String s = this.inputField.getText();
        int i = s.indexOf(86);
        if (i < 0) {
            return s;
        }
        return s.substring(0, i).trim();
    }

    private void setInternalBitFieldVisible() {
        if (this.isAdc) {
            this.internalBitField.setBackground(this.internalBitFieldBackground);
            this.internalBitField.setForeground(Color.RED);
            this.internalBitField.setBorder(this.internalBitFieldBorder);
        } else {
            this.internalBitField.setBackground(Color.WHITE);
            this.internalBitField.setForeground(Color.WHITE);
            this.internalBitField.setBorder(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.inputField) {
            try {
                this.voltage = Float.parseFloat(this.removeVoltageSymbol());
                if ((double)this.voltage < 0.0) {
                    this.voltage = 0.0f;
                } else if ((double)this.voltage > 5.0) {
                    this.voltage = 5.0f;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.slider.setValue(Math.round(this.voltage * 255.0f / 5.0f));
            this.inputField.setText(this.voltage + " V");
        } else if (event.getSource() == this.switchButton) {
            boolean bl = this.isAdc = !this.isAdc;
            if (this.isAdc) {
                this.board.setHardwareSetting("adc", "E");
            } else {
                this.board.setHardwareSetting("adc", "D");
            }
            this.setInternalBitFieldVisible();
            this.setSwitchButtonText();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.slider) {
            float f = (float)this.slider.getValue() * 5.0f / 255.0f;
            int i = Math.round(f * 100.0f);
            this.voltage = (float)i / 100.0f;
            this.inputField.setText(this.voltage + " V");
            if (!this.isAdc) {
                this.comparator.cycle(this.dac.getOutputVoltage());
            }
        }
    }
}

