/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.webservices.PhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.WebserviceUtil;
import org.forester.archaeopteryx.webservices.WebservicesManager;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.data.Identifier;
import org.forester.util.ForesterUtil;

public class UrlTreeReader
implements Runnable {
    private final MainFrame _main_frame;
    private final int _webservice_client_index;

    UrlTreeReader(MainFrame mainFrame, int n) {
        this._main_frame = mainFrame;
        this._webservice_client_index = n;
    }

    @Override
    public void run() {
        this.readPhylogeniesFromWebservice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void readPhylogeniesFromWebservice() {
        URL uRL = null;
        Phylogeny[] phylogenyArray = null;
        WebservicesManager webservicesManager = WebservicesManager.getInstance();
        PhylogeniesWebserviceClient phylogeniesWebserviceClient = webservicesManager.getAvailablePhylogeniesWebserviceClient(this._webservice_client_index);
        String string = JOptionPane.showInputDialog(this._main_frame, phylogeniesWebserviceClient.getInstructions() + "\n(Reference: " + phylogeniesWebserviceClient.getReference() + ")", phylogeniesWebserviceClient.getDescription(), 3);
        if (string != null && string.trim().length() > 0) {
            int n;
            string = string.trim();
            if (phylogeniesWebserviceClient.isQueryInteger()) {
                string = string.replaceAll("^\\D+", "");
                n = -1;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                if (n < 1) {
                    JOptionPane.showMessageDialog(this._main_frame, "Identifier is expected to be a number", "Can not open URL", 0);
                    return;
                }
                string = n + "";
            }
            n = 0;
            try {
                String string2 = phylogeniesWebserviceClient.getUrl();
                string2 = string2.replaceFirst("__query__", string);
                uRL = new URL(string2);
                PhylogenyParser phylogenyParser = null;
                switch (phylogeniesWebserviceClient.getReturnFormat()) {
                    case TOL_XML_RESPONSE: {
                        phylogenyParser = new TolParser();
                        break;
                    }
                    case NEXUS: {
                        phylogenyParser = new NexusPhylogeniesParser();
                        ((NexusPhylogeniesParser)phylogenyParser).setReplaceUnderscores(true);
                        break;
                    }
                    case TREEBASE_TREE: {
                        phylogenyParser = new NexusPhylogeniesParser();
                        ((NexusPhylogeniesParser)phylogenyParser).setReplaceUnderscores(true);
                        ((NexusPhylogeniesParser)phylogenyParser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                        break;
                    }
                    case NH: {
                        phylogenyParser = new NHXParser();
                        ((NHXParser)phylogenyParser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                        ((NHXParser)phylogenyParser).setReplaceUnderscores(true);
                        ((NHXParser)phylogenyParser).setGuessRootedness(true);
                        break;
                    }
                    case NH_EXTRACT_TAXONOMY: {
                        phylogenyParser = new NHXParser();
                        ((NHXParser)phylogenyParser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                        ((NHXParser)phylogenyParser).setReplaceUnderscores(false);
                        ((NHXParser)phylogenyParser).setGuessRootedness(true);
                        break;
                    }
                    case PFAM: {
                        phylogenyParser = new NHXParser();
                        ((NHXParser)phylogenyParser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_STRICT);
                        ((NHXParser)phylogenyParser).setReplaceUnderscores(false);
                        ((NHXParser)phylogenyParser).setGuessRootedness(true);
                        break;
                    }
                    case NHX: {
                        phylogenyParser = new NHXParser();
                        ((NHXParser)phylogenyParser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                        ((NHXParser)phylogenyParser).setReplaceUnderscores(false);
                        ((NHXParser)phylogenyParser).setGuessRootedness(true);
                        break;
                    }
                    case PHYLOXML: {
                        phylogenyParser = PhyloXmlParser.createPhyloXmlParserXsdValidating();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown format: " + (Object)((Object)phylogeniesWebserviceClient.getReturnFormat()));
                    }
                }
                if (this._main_frame.getMainPanel().getCurrentTreePanel() != null) {
                    this._main_frame.getMainPanel().getCurrentTreePanel().setWaitCursor();
                } else {
                    this._main_frame.getMainPanel().setWaitCursor();
                }
                phylogenyArray = ForesterUtil.readPhylogeniesFromUrl(uRL, phylogenyParser);
            }
            catch (MalformedURLException malformedURLException) {
                n = 1;
                JOptionPane.showMessageDialog(this._main_frame, "Malformed URL: " + uRL + "\n" + malformedURLException.getLocalizedMessage(), "Malformed URL", 0);
            }
            catch (IOException iOException) {
                n = 1;
                JOptionPane.showMessageDialog(this._main_frame, "Could not read from " + uRL + "\n" + iOException.getLocalizedMessage(), "Failed to read tree from " + phylogeniesWebserviceClient.getName() + " for " + string, 0);
            }
            catch (NumberFormatException numberFormatException) {
                n = 1;
                JOptionPane.showMessageDialog(this._main_frame, "Could not read from " + uRL + "\n" + numberFormatException.getLocalizedMessage(), "Failed to read tree from " + phylogeniesWebserviceClient.getName() + " for " + string, 0);
            }
            catch (Exception exception) {
                n = 1;
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this._main_frame, exception.getLocalizedMessage(), "Unexpected Exception", 0);
            }
            finally {
                if (this._main_frame.getCurrentTreePanel() != null) {
                    this._main_frame.getCurrentTreePanel().setArrowCursor();
                } else {
                    this._main_frame.getMainPanel().setArrowCursor();
                }
            }
            if (phylogenyArray != null && phylogenyArray.length > 0) {
                for (String string3 : phylogenyArray) {
                    if (((Phylogeny)((Object)string3)).isEmpty()) continue;
                    if (phylogeniesWebserviceClient.getName().equals("TreeFam")) {
                        ((Phylogeny)((Object)string3)).setRerootable(false);
                        ((Phylogeny)((Object)string3)).setRooted(true);
                    }
                    if (phylogeniesWebserviceClient.getProcessingInstructions() != null) {
                        try {
                            WebserviceUtil.processInstructions(phylogeniesWebserviceClient, (Phylogeny)((Object)string3));
                        }
                        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                            JOptionPane.showMessageDialog(this._main_frame, "Error:\n" + phyloXmlDataFormatException.getLocalizedMessage(), "Error", 0);
                        }
                    }
                    if (phylogeniesWebserviceClient.getNodeField() != null) {
                        try {
                            PhylogenyMethods.transferNodeNameToField((Phylogeny)((Object)string3), phylogeniesWebserviceClient.getNodeField(), false);
                        }
                        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                            JOptionPane.showMessageDialog(this._main_frame, "Error:\n" + phyloXmlDataFormatException.getLocalizedMessage(), "Error", 0);
                        }
                    }
                    ((Phylogeny)((Object)string3)).setIdentifier(new Identifier(string, phylogeniesWebserviceClient.getName()));
                    this._main_frame.getJMenuBar().remove(this._main_frame.getHelpMenu());
                    this._main_frame.getMenuBarOfMainFrame().add(this._main_frame.getHelpMenu());
                    this._main_frame.getMainPanel().addPhylogenyInNewTab((Phylogeny)((Object)string3), this._main_frame.getConfiguration(), new File(uRL.getFile()).getName(), uRL.toString());
                    String string4 = "";
                    if (!ForesterUtil.isEmpty(((Phylogeny)((Object)string3)).getName())) {
                        string4 = new String(((Phylogeny)((Object)string3)).getName()).replaceAll(" ", "_");
                    } else if (((Phylogeny)((Object)string3)).getIdentifier() != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        if (!ForesterUtil.isEmpty(((Phylogeny)((Object)string3)).getIdentifier().getProvider())) {
                            stringBuffer.append(((Phylogeny)((Object)string3)).getIdentifier().getProvider());
                            stringBuffer.append("_");
                        }
                        stringBuffer.append(((Phylogeny)((Object)string3)).getIdentifier().getValue());
                        string4 = new String(stringBuffer.toString().replaceAll(" ", "_"));
                    }
                    this._main_frame.getMainPanel().getCurrentTreePanel().setTreeFile(new File(string4));
                    AptxUtil.lookAtSomeTreePropertiesForAptxControlSettings((Phylogeny)((Object)string3), this._main_frame.getMainPanel().getControlPanel(), this._main_frame.getConfiguration());
                    this._main_frame.getMainPanel().getControlPanel().showWhole();
                }
            } else if (n == 0) {
                JOptionPane.showMessageDialog(null, ForesterUtil.wordWrap("Failed to read in tree(s) from [" + uRL + "]", 80), "Error", 0);
            }
            this._main_frame.getContentPane().repaint();
            if (phylogenyArray != null && phylogenyArray.length > 0) {
                try {
                    JOptionPane.showMessageDialog(null, ForesterUtil.wordWrap("Successfully read in " + phylogenyArray.length + " tree(s) from [" + uRL + "]", 80), "Success", 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._main_frame.getContentPane().repaint();
            }
        }
        this._main_frame.activateSaveAllIfNeeded();
        System.gc();
    }
}

