/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.model.DefaultChartDataModel;
import com.approximatrix.charting.model.JDBCPlotterException;
import com.approximatrix.charting.model.ObjectChartDataModel;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class JDBCPlotter {
    protected Connection conn;

    public JDBCPlotter(String jdbcDriver, String jdbcURL, String username, String password) throws JDBCPlotterException {
        try {
            Class.forName(jdbcDriver);
            this.conn = DriverManager.getConnection(jdbcURL, username, password);
        }
        catch (Exception e) {
            throw new JDBCPlotterException("Exception while creating a database connection.", e);
        }
    }

    public DefaultChartDataModel createChartDataModelInstance(String sqlQuery, String[] sqlRows) throws JDBCPlotterException {
        return this.createChartDataModelInstance(sqlQuery, sqlRows, sqlRows);
    }

    public DefaultChartDataModel createChartDataModelInstance(String sqlQuery, String[] sqlRows, String[] dataSets) throws JDBCPlotterException {
        try {
            Statement stmt = this.conn.createStatement();
            ResultSet sqlResult = stmt.executeQuery(sqlQuery);
            ArrayList[] model = new ArrayList[sqlRows.length];
            ArrayList<Double> columnList = new ArrayList<Double>();
            int i = 0;
            while (i < model.length) {
                model[i] = new ArrayList();
                ++i;
            }
            double x = 0.0;
            while (sqlResult.next()) {
                columnList.add(new Double(x));
                x += 1.0;
                int i2 = 0;
                while (i2 < sqlRows.length) {
                    model[i2].add(new Double(sqlResult.getDouble(sqlRows[i2])));
                    ++i2;
                }
            }
            Number[][] modelArray = new Number[model.length][];
            int i3 = 0;
            while (i3 < model.length) {
                modelArray[i3] = model[i3].toArray(new Number[0]);
                ++i3;
            }
            double[] columns = new double[columnList.size()];
            int i4 = 0;
            while (i4 < columns.length) {
                columns[i4] = (Double)columnList.get(i4);
                ++i4;
            }
            return new DefaultChartDataModel(modelArray, columns, dataSets);
        }
        catch (Exception e) {
            throw new JDBCPlotterException("Exception while performing task.", e);
        }
    }

    public DefaultChartDataModel createChartDataModelInstance(String sqlQuery, String columnRow, String[] sqlRows) throws JDBCPlotterException {
        return this.createChartDataModelInstance(sqlQuery, columnRow, sqlRows, sqlRows);
    }

    public DefaultChartDataModel createChartDataModelInstance(String sqlQuery, String columnRow, String[] sqlRows, String[] dataSets) throws JDBCPlotterException {
        try {
            Statement stmt = this.conn.createStatement();
            ResultSet sqlResult = stmt.executeQuery(sqlQuery);
            ArrayList[] model = new ArrayList[sqlRows.length];
            ArrayList<Double> columnList = new ArrayList<Double>();
            int i = 0;
            while (i < model.length) {
                model[i] = new ArrayList();
                ++i;
            }
            while (sqlResult.next()) {
                columnList.add(new Double(sqlResult.getDouble(columnRow)));
                i = 0;
                while (i < sqlRows.length) {
                    model[i].add(new Double(sqlResult.getDouble(sqlRows[i])));
                    ++i;
                }
            }
            Number[][] modelArray = new Number[model.length][];
            int i2 = 0;
            while (i2 < model.length) {
                modelArray[i2] = model[i2].toArray(new Number[0]);
                ++i2;
            }
            double[] columns = new double[columnList.size()];
            int i3 = 0;
            while (i3 < columns.length) {
                columns[i3] = (Double)columnList.get(i3);
                ++i3;
            }
            return new DefaultChartDataModel(modelArray, columns, dataSets);
        }
        catch (Exception e) {
            throw new JDBCPlotterException("Exception while performing task.", e);
        }
    }

    public ObjectChartDataModel createObjectChartDataModelInstance(String sqlQuery, String columnRow, String[] sqlRows) throws JDBCPlotterException {
        return this.createObjectChartDataModelInstance(sqlQuery, columnRow, sqlRows, sqlRows);
    }

    public ObjectChartDataModel createObjectChartDataModelInstance(String sqlQuery, String columnRow, String[] sqlRows, String[] dataSets) throws JDBCPlotterException {
        try {
            Statement stmt = this.conn.createStatement();
            ResultSet sqlResult = stmt.executeQuery(sqlQuery);
            ArrayList[] model = new ArrayList[sqlRows.length];
            ArrayList<String> columnList = new ArrayList<String>();
            int i = 0;
            while (i < model.length) {
                model[i] = new ArrayList();
                ++i;
            }
            while (sqlResult.next()) {
                columnList.add(sqlResult.getString(columnRow));
                i = 0;
                while (i < sqlRows.length) {
                    model[i].add(new Double(sqlResult.getDouble(sqlRows[i])));
                    ++i;
                }
            }
            Number[][] modelArray = new Number[model.length][];
            int i2 = 0;
            while (i2 < model.length) {
                modelArray[i2] = model[i2].toArray(new Number[0]);
                ++i2;
            }
            Object[] columns = columnList.toArray(new String[0]);
            return new ObjectChartDataModel(modelArray, columns, dataSets);
        }
        catch (Exception e) {
            throw new JDBCPlotterException("Exception while performing task.", e);
        }
    }
}

