/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FACS_objects;

import FCSalyzer.FACS_objects.FACS_panel;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import javax.swing.JPanel;

public class FACS_canvas
extends JPanel {
    private final float[] dashes = new float[]{1.0f, 2.0f};
    private final BasicStroke dashedStroke = new BasicStroke(0.0f, 0, 2, 1.0f, this.dashes, 0.0f);
    private PageFormat currentPage;
    private int widthPageCount = 1;
    private int heightPageCount = 1;

    private FACS_canvas() {
    }

    public FACS_canvas(PageFormat thePage) {
        this.currentPage = thePage;
        MouseMotionAdapter doScrollRectToVisible = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
                ((JPanel)e.getSource()).scrollRectToVisible(r);
            }
        };
        this.addMouseMotionListener(doScrollRectToVisible);
    }

    public int getFACSComponentCount() {
        int count = 0;
        for (Component current : this.getComponents()) {
            if (!(current instanceof FACS_panel)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void paint(Graphics g) {
        int i;
        Font standardFont = g.getFont();
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(standardFont);
        Rectangle2D labelBounds = g2.getFontMetrics().getStringBounds("Page 99", g2);
        int labelX = (int)(this.currentPage.getImageableWidth() - labelBounds.getWidth()) - 5;
        int labelY = (int)(this.currentPage.getImageableHeight() - labelBounds.getHeight());
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.dashedStroke);
        for (i = 0; i < this.heightPageCount * this.widthPageCount; ++i) {
            int yCount = i / this.widthPageCount;
            int xCount = i % this.widthPageCount;
            int x = (int)(this.currentPage.getImageableWidth() * (double)xCount + (double)labelX);
            int y = (int)(this.currentPage.getImageableHeight() * (double)yCount + (double)labelY);
            g2.drawString("Page " + (i + 1), x, y);
        }
        if (!this.isPaintingForPrint()) {
            int pos;
            for (i = 1; i < this.widthPageCount; ++i) {
                pos = (int)((double)i * this.currentPage.getImageableWidth());
                g2.drawLine(pos, 0, pos, this.getHeight());
            }
            for (i = 1; i < this.heightPageCount; ++i) {
                pos = (int)((double)i * this.currentPage.getImageableHeight());
                g2.drawLine(0, pos, this.getWidth(), pos);
            }
        }
        g2.setStroke(oldStroke);
    }

    public void setCanvasSize(int widthPageCount, int heightPageCount) {
        this.setCanvasSize(widthPageCount, heightPageCount, this.currentPage);
    }

    public void setCanvasSize(int widthPageCount, int heightPageCount, PageFormat newPage) {
        this.currentPage = newPage;
        this.widthPageCount = widthPageCount;
        this.heightPageCount = heightPageCount;
        double width = (double)widthPageCount * this.currentPage.getImageableWidth();
        double height = (double)heightPageCount * this.currentPage.getImageableHeight();
        Dimension size = new Dimension((int)width, (int)height);
        this.setPreferredSize(size);
        this.setSize(size);
        this.setMaximumSize(size);
    }

    public void setPage(PageFormat newPage, boolean changePageCount) {
        this.currentPage = newPage;
        if (changePageCount) {
            this.widthPageCount = (int)((double)this.getPreferredSize().width / this.currentPage.getImageableWidth());
            if ((double)this.getPreferredSize().width % this.currentPage.getImageableWidth() != 0.0) {
                ++this.widthPageCount;
            }
            this.heightPageCount = (int)((double)this.getPreferredSize().height / this.currentPage.getImageableHeight());
            if ((double)this.getPreferredSize().height % this.currentPage.getImageableHeight() != 0.0) {
                ++this.heightPageCount;
            }
        } else {
            double width = (double)this.widthPageCount * this.currentPage.getImageableWidth();
            double height = (double)this.heightPageCount * this.currentPage.getImageableHeight();
            this.setPreferredSize(new Dimension((int)width, (int)height));
        }
    }

    public int getPageCount() {
        return this.widthPageCount * this.heightPageCount;
    }

    public int getPagesWidth() {
        return this.widthPageCount;
    }

    public int getPagesHeight() {
        return this.heightPageCount;
    }

    public void print(Graphics g, int pageIndex) {
        int yCount = pageIndex / this.widthPageCount;
        int xCount = pageIndex % this.widthPageCount;
        int x = (int)(this.currentPage.getImageableWidth() * (double)xCount - this.currentPage.getImageableX());
        int y = (int)(this.currentPage.getImageableHeight() * (double)yCount - this.currentPage.getImageableY());
        g.translate(-x, -y);
        this.print(g);
    }
}

