/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import com.pomodorotechnique.client.ui.InterruptionDialog;
import com.pomodorotechnique.client.ui.PomodoroClientApp;
import com.pomodorotechnique.client.ui.PomodoroClientView;
import com.pomodorotechnique.client.ui.PomodoroListener;
import com.pomodorotechnique.client.ui.TraySupport;
import com.pomodorotechnique.client.ui.Util;
import com.pomodorotechnique.client.ui.timer.Timer;
import com.pomodorotechnique.client.ui.timer.TimerAdapter;
import com.pomodorotechnique.client.ui.timer.TimerState;
import com.pomodorotechnique.server.InterruptionType;
import com.pomodorotechnique.server.PomodoroType;
import com.pomodorotechnique.server.WorkitemType;
import com.pomodorotechnique.server.api.NoPomodorosLeftException;
import com.pomodorotechnique.server.api.NotFoundException;
import java.awt.Frame;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class TimerWindow
extends JDialog {
    private WorkitemType workItem;
    private final Preferences prefs = Preferences.userRoot().node("pomodoroServer");
    private final PomodoroClientView mainWindow;
    private LinkedList<PomodoroListener> listeners = new LinkedList();
    private JToggleButton alwaysOnTopButton;
    private JLabel headerLogoLabel;
    private JPanel headerPanel1;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel timeLabel;
    private JLabel titleLabel;

    public TimerWindow(PomodoroClientView parent, boolean modal, final Timer timer) {
        super((Frame)parent.getFrame(), modal);
        this.mainWindow = parent;
        this.initComponents();
        this.alwaysOnTopButton.setSelected(this.prefs.get("timerAlwaysOnTop", "Y").equals("Y"));
        this.setAlwaysOnTop(this.alwaysOnTopButton.isSelected());
        timer.addListener(new TimerAdapter(){

            public void onTick() {
                String prefix = timer.getState().equals((Object)TimerState.BUSY) ? "Work" : "Rest";
                long t = timer.getTimeLeft() / 1000L;
                long m = t / 60L;
                long s = t % 60L;
                TimerWindow.this.timeLabel.setText(String.format("%s: %02d:%02d", prefix, m, s));
            }

            public void onReady() {
                TimerWindow.this.timeLabel.setText("Ready");
                for (PomodoroListener l : TimerWindow.this.listeners) {
                    l.ready(TimerWindow.this.workItem);
                }
                TimerWindow.this.toFront();
            }

            public void onWorkCompleted(PomodoroType pomodoro, boolean successfully) {
                boolean restStarted = timer.getState().equals((Object)TimerState.REST);
                TimerWindow.this.enableButtons(!restStarted);
                for (PomodoroListener l : TimerWindow.this.listeners) {
                    l.workCompleted(TimerWindow.this.workItem, pomodoro, successfully);
                }
                TimerWindow.this.toFront();
            }
        });
        this.getRootPane().setDefaultButton(this.jButton2);
        Util.decorate(this, true);
    }

    private void enableButtons(boolean enable) {
        this.jButton1.setEnabled(enable);
        this.jButton3.setEnabled(enable);
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.titleLabel.setText(title);
    }

    public void setWorkItem(WorkitemType wi) {
        this.workItem = wi;
        this.enableButtons(true);
        this.setTitle(wi.getTitle());
    }

    public WorkitemType getWorkItem() {
        return this.workItem;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.headerPanel1 = new JPanel();
        this.timeLabel = new JLabel();
        this.headerLogoLabel = new JLabel();
        this.alwaysOnTopButton = new JToggleButton();
        this.jButton4 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(PomodoroClientApp.class).getContext().getResourceMap(TimerWindow.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.titleLabel.setFont(this.titleLabel.getFont());
        this.titleLabel.setHorizontalAlignment(2);
        this.titleLabel.setText(resourceMap.getString("titleLabel.text", new Object[0]));
        this.titleLabel.setName("titleLabel");
        ApplicationActionMap actionMap = Application.getInstance(PomodoroClientApp.class).getContext().getActionMap(TimerWindow.class, this);
        this.jButton1.setAction(actionMap.get("voidPomodoro"));
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton2.setAction(actionMap.get("hideWindow"));
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setName("jButton2");
        this.jButton3.setAction(actionMap.get("interruption"));
        this.jButton3.setText(resourceMap.getString("jButton3.text", new Object[0]));
        this.jButton3.setName("jButton3");
        this.headerPanel1.setBackground(resourceMap.getColor("headerPanel1.background"));
        this.headerPanel1.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("headerPanel1.border.lineColor")));
        this.headerPanel1.setName("headerPanel1");
        this.timeLabel.setFont(this.timeLabel.getFont().deriveFont((float)this.timeLabel.getFont().getSize() + 7.0f));
        this.timeLabel.setHorizontalAlignment(2);
        this.timeLabel.setText(resourceMap.getString("timeLabel.text", new Object[0]));
        this.timeLabel.setName("timeLabel");
        this.headerLogoLabel.setIcon(resourceMap.getIcon("headerLogoLabel.icon"));
        this.headerLogoLabel.setName("headerLogoLabel");
        GroupLayout headerPanel1Layout = new GroupLayout(this.headerPanel1);
        this.headerPanel1.setLayout(headerPanel1Layout);
        headerPanel1Layout.setHorizontalGroup(headerPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, headerPanel1Layout.createSequentialGroup().addContainerGap(145, Short.MAX_VALUE).addComponent(this.headerLogoLabel)).addGroup(headerPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.timeLabel, -1, 350, Short.MAX_VALUE))));
        headerPanel1Layout.setVerticalGroup(headerPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerLogoLabel).addGroup(headerPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timeLabel, -1, 68, Short.MAX_VALUE)));
        this.alwaysOnTopButton.setAction(actionMap.get("toggleAlwaysOnTop"));
        this.alwaysOnTopButton.setIcon(resourceMap.getIcon("alwaysOnTopButton.icon"));
        this.alwaysOnTopButton.setText(resourceMap.getString("alwaysOnTopButton.text", new Object[0]));
        this.alwaysOnTopButton.setName("alwaysOnTopButton");
        this.jButton4.setAction(actionMap.get("nextPomodoro"));
        this.jButton4.setText(resourceMap.getString("jButton4.text", new Object[0]));
        this.jButton4.setName("jButton4");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleLabel, -1, 362, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.alwaysOnTopButton, -2, 26, -2)).addComponent(this.headerPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.headerPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.alwaysOnTopButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton4, -1, 25, Short.MAX_VALUE).addComponent(this.jButton3, GroupLayout.Alignment.TRAILING, -1, 25, Short.MAX_VALUE).addComponent(this.jButton2, GroupLayout.Alignment.TRAILING, -1, 25, Short.MAX_VALUE).addComponent(this.jButton1, -1, 25, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    @Action
    public void voidPomodoro() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to void this pomodoro?", "Confirm", 0) == 0) {
            for (PomodoroListener l : this.listeners) {
                l.pomodoroVoid(this.workItem);
            }
            this.hideWindow();
        }
    }

    public void enableNextButton(boolean enable) {
        this.jButton4.setEnabled(enable);
    }

    public void addPomodoroListener(PomodoroListener l) {
        this.listeners.add(l);
    }

    public void removePomodoroListener(PomodoroListener l) {
        this.listeners.remove(l);
    }

    @Action
    public void hideWindow() {
        this.setVisible(false);
    }

    @Action
    public void interruption() {
        InterruptionDialog dlg = new InterruptionDialog(null, true);
        long started = new Date().getTime();
        dlg.setVisible(true);
        if (dlg.isCreated()) {
            long len = (new Date().getTime() - started) / 1000L;
            InterruptionType interruption = new InterruptionType();
            interruption.setComment(dlg.getComment());
            interruption.setDuration((int)len);
            for (PomodoroListener l : this.listeners) {
                l.interruption(this.workItem, interruption);
            }
        }
    }

    @Action
    public void toggleAlwaysOnTop() {
        this.prefs.put("timerAlwaysOnTop", this.alwaysOnTopButton.isSelected() ? "Y" : "N");
        this.setAlwaysOnTop(this.alwaysOnTopButton.isSelected());
    }

    @Action
    public void nextPomodoro() {
        try {
            this.mainWindow.startPomodoro();
        }
        catch (NotFoundException ex) {
            Logger.getLogger(TraySupport.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoPomodorosLeftException ex) {
            Logger.getLogger(TraySupport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

