/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script;

import java.util.ArrayList;
import java.util.List;
import org.encog.app.analyst.script.AnalystClassItem;

public class DataField {
    private String name;
    private double min;
    private double max;
    private double mean;
    private double standardDeviation;
    private boolean isInteger;
    private boolean isReal;
    private boolean isClass;
    private boolean isComplete;
    private String source = "";
    private final List<AnalystClassItem> classMembers = new ArrayList<AnalystClassItem>();

    public DataField(String theName) {
        this.name = theName;
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        this.mean = Double.NaN;
        this.standardDeviation = Double.NaN;
        this.isInteger = true;
        this.isReal = true;
        this.isClass = true;
        this.isComplete = true;
    }

    public List<AnalystClassItem> getClassMembers() {
        return this.classMembers;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMin() {
        return this.min;
    }

    public int getMinClassCount() {
        int cmin = Integer.MAX_VALUE;
        for (AnalystClassItem cls : this.classMembers) {
            cmin = Math.min(cmin, cls.getCount());
        }
        return cmin;
    }

    public String getName() {
        return this.name;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public boolean isReal() {
        return this.isReal;
    }

    public void setClass(boolean theClass) {
        this.isClass = theClass;
    }

    public void setComplete(boolean theComplete) {
        this.isComplete = theComplete;
    }

    public void setInteger(boolean theInteger) {
        this.isInteger = theInteger;
    }

    public void setMax(double theMax) {
        this.max = theMax;
    }

    public void setMean(double theMean) {
        this.mean = theMean;
    }

    public void setMin(double theMin) {
        this.min = theMin;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public void setReal(boolean theReal) {
        this.isReal = theReal;
    }

    public void setStandardDeviation(double theStandardDeviation) {
        this.standardDeviation = theStandardDeviation;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

