/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.generate.EncogCodeGeneration;
import org.encog.app.generate.TargetLanguage;
import org.encog.util.logging.EncogLogging;

public class CmdCode
extends Cmd {
    public static final String COMMAND_NAME = "CODE";

    public CmdCode(EncogAnalyst analyst) {
        super(analyst);
    }

    @Override
    public boolean executeCommand(String args) {
        String targetID = this.getProp().getPropertyString("CODE:CONFIG_targetFile");
        File targetFile = this.getScript().resolveFilename(targetID);
        TargetLanguage targetLanguage = this.getProp().getPropertyTargetLanguage("CODE:CONFIG_targetLanguage");
        boolean embedData = this.getProp().getPropertyBoolean("CODE:CONFIG_embedData");
        EncogLogging.log(0, "Beginning code generation");
        EncogLogging.log(0, "target file:" + targetID);
        EncogLogging.log(0, "target language:" + targetLanguage.toString());
        EncogCodeGeneration code = new EncogCodeGeneration(targetLanguage);
        code.setEmbedData(embedData);
        code.generate(this.getAnalyst());
        code.save(targetFile);
        return false;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }
}

