/*
 * Decompiled with CFR 0.152.
 */
package spl;

import java.util.List;
import org.sciplore.beans.Abstract;
import org.sciplore.beans.Author;
import org.sciplore.beans.Document;
import org.sciplore.formatter.Bean;
import org.sciplore.formatter.SimpleTypeElementBean;

public class DocumentWrapper {
    Document xmlDocument;

    public DocumentWrapper(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
    }

    public Document getXmlDocument() {
        return this.xmlDocument;
    }

    public void setXmlDocument(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
    }

    public String getTitle() {
        if (this.hasTitle()) {
            return this.xmlDocument.getTitle().getValue();
        }
        return "";
    }

    public boolean hasTitle() {
        return this.xmlDocument.getTitle() != null && this.xmlDocument.getTitle().getValue() != null && !this.xmlDocument.getTitle().getValue().isEmpty();
    }

    public String getAbstract() {
        if (this.hasAbstract()) {
            return ((Abstract)this.xmlDocument.getAbstract()).getValue();
        }
        return "";
    }

    public boolean hasAbstract() {
        return this.xmlDocument.getAbstract() != null && ((Abstract)this.xmlDocument.getAbstract()).getValue() != null && !((Abstract)this.xmlDocument.getAbstract()).getValue().isEmpty();
    }

    public String getAuthors(String seperator) {
        if (this.hasAuthors()) {
            List<Bean> authors = this.xmlDocument.getAuthors().getCollection();
            authors = this.sortAuthors(authors);
            String value = "";
            int i = 1;
            for (Bean author : authors) {
                if (i < authors.size()) {
                    value = value + this.getNameComplete((Author)author);
                    value = value + " " + seperator + " ";
                } else {
                    value = value + this.getNameComplete((Author)author);
                }
                ++i;
            }
            return value;
        }
        return "";
    }

    public boolean hasAuthors() {
        return this.xmlDocument.getAuthors() != null && this.xmlDocument.getAuthors().getCollection() != null && !this.xmlDocument.getAuthors().getCollection().isEmpty();
    }

    public String getDoi() {
        if (this.hasDoi()) {
            return this.getSimpleTypeValue(this.xmlDocument.getDoi());
        }
        return "";
    }

    public boolean hasDoi() {
        return this.xmlDocument.getDoi() != null && this.getSimpleTypeValue(this.xmlDocument.getDoi()) != null && !this.getSimpleTypeValue(this.xmlDocument.getDoi()).isEmpty();
    }

    public String getYear() {
        if (this.hasYear()) {
            return this.getSimpleTypeValue(this.xmlDocument.getYear());
        }
        return "";
    }

    public boolean hasYear() {
        return this.getSimpleTypeValue(this.xmlDocument.getYear()) != null && !this.getSimpleTypeValue(this.xmlDocument.getYear()).isEmpty() && !this.getSimpleTypeValue(this.xmlDocument.getYear()).equalsIgnoreCase("null");
    }

    private String getNameComplete(Author author) {
        if (author == null) {
            return "";
        }
        String result = "";
        if (this.getSimpleTypeValue(author.getName_First()) != null) {
            result = result + this.getSimpleTypeValue(author.getName_First()).trim() + " ";
        }
        if (this.getSimpleTypeValue(author.getName_Middle()) != null) {
            result = result + this.getSimpleTypeValue(author.getName_Middle()).trim() + " ";
        }
        if (this.getSimpleTypeValue(author.getName_Last_Prefix()) != null) {
            result = result + this.getSimpleTypeValue(author.getName_Last_Prefix()).trim() + " ";
        }
        if (this.getSimpleTypeValue(author.getName_Last()) != null) {
            result = result + this.getSimpleTypeValue(author.getName_Last()).trim() + " ";
        }
        if (this.getSimpleTypeValue(author.getName_Last_Suffix()) != null) {
            result = result + this.getSimpleTypeValue(author.getName_Last_Suffix()).trim() + " ";
        }
        return result.trim();
    }

    private String getSimpleTypeValue(Bean bean) {
        if (bean == null || !(bean instanceof SimpleTypeElementBean)) {
            return null;
        }
        SimpleTypeElementBean simpleTypeElementBean = (SimpleTypeElementBean)bean;
        if (simpleTypeElementBean.getValue() == null || simpleTypeElementBean.getValue().equalsIgnoreCase("null") || simpleTypeElementBean.getValue().length() <= 0) {
            return null;
        }
        return simpleTypeElementBean.getValue();
    }

    private List<Bean> sortAuthors(List<Bean> authors) {
        boolean unsorted = true;
        while (unsorted) {
            unsorted = false;
            for (int i = 0; i < authors.size() - 1; ++i) {
                int rank = 99;
                int otherRank = 99;
                if (((Author)authors.get(i)).getRank() != null && !((Author)authors.get(i)).getRank().equalsIgnoreCase("null")) {
                    rank = Integer.parseInt(((Author)authors.get(i)).getRank());
                }
                if (((Author)authors.get(i + 1)).getRank() != null && !((Author)authors.get(i + 1)).getRank().equalsIgnoreCase("null")) {
                    otherRank = Integer.parseInt(((Author)authors.get(i + 1)).getRank());
                }
                if (rank <= otherRank) continue;
                Bean temp = authors.get(i);
                authors.set(i, authors.get(i + 1));
                authors.set(i + 1, temp);
                unsorted = true;
            }
        }
        return authors;
    }
}

