/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.formatter;

import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public class XmlReplacerSciplore
extends XmlFriendlyReplacer {
    private char dollarReplacementInClass = (char)45;
    private String dollarReplacementInField = "_DOLLAR_";
    private String underscoreReplacementInField = "_";
    private String noPackagePrefix = "default";

    @Override
    public String unescapeName(String name) {
        return name;
    }

    protected String escapeClassName(String className) {
        if ((className = className.replace('$', this.dollarReplacementInClass)).charAt(0) == this.dollarReplacementInClass) {
            className = String.valueOf(this.noPackagePrefix) + className;
        }
        return className;
    }

    @Override
    public String escapeName(String name) {
        return this.escapeFieldName(name);
    }

    protected String escapeFieldName(String fieldName) {
        StringBuffer result = new StringBuffer();
        int length = fieldName.length();
        int i = 0;
        while (i < length) {
            char c = fieldName.charAt(i);
            if (c == '$') {
                result.append(this.dollarReplacementInField);
            } else if (c == '_') {
                result.append(this.underscoreReplacementInField);
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    protected String unescapeClassName(String className) {
        if (className.startsWith(String.valueOf(this.noPackagePrefix) + this.dollarReplacementInClass)) {
            className = className.substring(this.noPackagePrefix.length());
        }
        className = className.replace(this.dollarReplacementInClass, '$');
        return className;
    }

    protected String unescapeFieldName(String xmlName) {
        StringBuffer result = new StringBuffer();
        int length = xmlName.length();
        int i = 0;
        while (i < length) {
            char c = xmlName.charAt(i);
            if (this.stringFoundAt(xmlName, i, this.underscoreReplacementInField)) {
                i += this.underscoreReplacementInField.length() - 1;
                result.append('_');
            } else if (this.stringFoundAt(xmlName, i, this.dollarReplacementInField)) {
                i += this.dollarReplacementInField.length() - 1;
                result.append('$');
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private boolean stringFoundAt(String name, int i, String replacement) {
        return name.length() >= i + replacement.length() && name.substring(i, i + replacement.length()).equals(replacement);
    }
}

