/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.sf.jabref.Globals;

public class ErrorConsole
extends Handler {
    ByteArrayOutputStream errByteStream = new ByteArrayOutputStream();
    ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
    ArrayList<String> logOutput = new ArrayList();
    String logOutputCache = "";
    boolean logOutputCacheRefreshNeeded = true;
    SimpleFormatter fmt = new SimpleFormatter();
    private static final int MAXLOGLINES = 500;
    private static ErrorConsole instance = null;

    public static ErrorConsole getInstance() {
        if (instance == null) {
            instance = new ErrorConsole();
        }
        return instance;
    }

    private ErrorConsole() {
        PrintStream myErr = new PrintStream(this.errByteStream);
        TeeStream tee = new TeeStream(System.err, myErr);
        System.setErr(tee);
        myErr = new PrintStream(this.outByteStream);
        tee = new TeeStream(System.out, myErr);
        System.setOut(tee);
    }

    private String getErrorMessages() {
        return this.errByteStream.toString();
    }

    private String getOutput() {
        return this.outByteStream.toString();
    }

    private String getLog() {
        if (this.logOutputCacheRefreshNeeded) {
            StringBuilder sb = new StringBuilder();
            for (String line : this.logOutput) {
                sb.append(line);
            }
            this.logOutputCache = sb.toString();
        }
        return this.logOutputCache;
    }

    private void addTextArea(JTabbedPane tabbed, String title, String output, String ifEmpty) {
        JTextArea ta = new JTextArea(output);
        ta.setEditable(false);
        if (ifEmpty != null && ta.getText().length() == 0) {
            ta.setText(ifEmpty);
        }
        JScrollPane sp = new JScrollPane(ta);
        tabbed.addTab(title, sp);
    }

    public void displayErrorConsole(JFrame parent) {
        JTabbedPane tabbed = new JTabbedPane();
        this.addTextArea(tabbed, Globals.lang("Output"), this.getOutput(), null);
        this.addTextArea(tabbed, Globals.lang("Exceptions"), this.getErrorMessages(), Globals.lang("No exceptions have ocurred."));
        this.addTextArea(tabbed, Globals.lang("Log"), this.getLog(), null);
        tabbed.setPreferredSize(new Dimension(500, 500));
        JOptionPane.showMessageDialog(parent, tabbed, Globals.lang("Program output"), 0);
    }

    public AbstractAction getAction(JFrame parent) {
        return new ErrorConsoleAction(parent);
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        String msg = this.fmt.format(record);
        this.logOutput.add(msg);
        if (this.logOutput.size() < 500) {
            this.logOutputCache = this.logOutputCache + msg;
        } else {
            this.logOutputCacheRefreshNeeded = true;
            while (this.logOutput.size() > 500) {
                this.logOutput.remove(0);
            }
        }
        this.logOutputCacheRefreshNeeded = true;
    }

    public class TeeStream
    extends PrintStream {
        PrintStream out;

        public TeeStream(PrintStream out1, PrintStream out2) {
            super(out1);
            this.out = out2;
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            try {
                super.write(buf, off, len);
                this.out.write(buf, off, len);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        @Override
        public void flush() {
            super.flush();
            this.out.flush();
        }
    }

    class ErrorConsoleAction
    extends AbstractAction {
        JFrame frame;

        public ErrorConsoleAction(JFrame frame) {
            super(Globals.menuTitle("Show error console"));
            this.putValue("ShortDescription", Globals.lang("Display all error messages"));
            this.frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ErrorConsole.this.displayErrorConsole(this.frame);
        }
    }
}

