/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.Util;

public class CaseChanger {
    public static final int LOWER = 0;
    public static final int UPPER = 1;
    public static final int UPPER_FIRST = 2;
    public static final int UPPER_EACH_FIRST = 3;
    private static final Pattern UF_PATTERN = Pattern.compile("\\b\\w");
    private static final int numModes = 4;
    private static final String[] modeNames = new String[]{"lower", "UPPER", "Upper first", "Upper Each First"};
    private static final HashSet<String> notToCapitalize = new HashSet();

    public static String getModeName(int mode) {
        return modeNames[mode];
    }

    public static String[] getModeNames() {
        return modeNames;
    }

    public static int getNumModes() {
        return 4;
    }

    public static String[] changeCase(String[] input, int mode) {
        int n = input.length;
        String[] output = new String[n];
        for (int i = 0; i < n; ++i) {
            output[i] = CaseChanger.changeCase(input[i], mode);
        }
        return output;
    }

    public static String changeCase(String input, int mode) {
        return CaseChanger.changeCase(input, mode, false);
    }

    public static String changeCase(String input, int mode, boolean skipSmallWords) {
        switch (mode) {
            case 1: {
                return input.toUpperCase();
            }
            case 0: {
                return input.toLowerCase();
            }
            case 2: {
                String s = input.toLowerCase();
                Matcher matcher = UF_PATTERN.matcher(s);
                if (matcher.find()) {
                    return matcher.replaceFirst(matcher.group(0).toUpperCase());
                }
                return input;
            }
            case 3: {
                String s = input.toLowerCase();
                boolean found = false;
                String[] words = s.split("\\s+");
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < words.length; ++i) {
                    String word = words[i];
                    if (i == 0 || !skipSmallWords || !notToCapitalize.contains(word)) {
                        sb.append(Util.nCase(word));
                    } else {
                        sb.append(word);
                    }
                    if (i >= words.length - 1) continue;
                    sb.append(" ");
                }
                return sb.toString();
            }
        }
        return input;
    }

    static {
        notToCapitalize.add("of");
        notToCapitalize.add("and");
        notToCapitalize.add("the");
    }
}

