/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;

public class UndoableInsertString
extends AbstractUndoableEdit {
    private BibtexDatabase base;
    private BasePanel panel;
    private BibtexString string;

    public UndoableInsertString(BasePanel panel, BibtexDatabase base, BibtexString string) {
        this.base = base;
        this.panel = panel;
        this.string = string;
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("insert string ");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("insert string ");
    }

    @Override
    public void undo() {
        super.undo();
        this.base.removeString(this.string.getId());
        this.panel.updateStringDialog();
    }

    @Override
    public void redo() {
        super.redo();
        try {
            this.base.addString(this.string);
        }
        catch (KeyCollisionException ex) {
            ex.printStackTrace();
        }
        this.panel.updateStringDialog();
    }
}

