/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.gui.FetcherPreviewDialog;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.CaseKeeper;
import net.sf.jabref.imports.HTMLConverter;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.PreviewEntryFetcher;

public class ACMPortalFetcher
implements PreviewEntryFetcher {
    private ImportInspector dialog = null;
    private OutputPrinter status;
    private final HTMLConverter htmlConverter = new HTMLConverter();
    final CaseKeeper caseKeeper = new CaseKeeper();
    private String terms;
    private static final String startUrl = "http://portal.acm.org/";
    private static final String searchUrlPart = "results.cfm?query=";
    private static final String searchUrlPartII = "&dl=";
    private static final String endUrl = "&coll=Portal&short=0";
    private static final String bibtexUrl = "exportformats.cfm?id=";
    private static final String bibtexUrlEnd = "&expformat=bibtex";
    private static final String abstractUrl = "tab_abstract.cfm?id=";
    private final JRadioButton acmButton = new JRadioButton(Globals.lang("The ACM Digital Library"));
    private final JRadioButton guideButton = new JRadioButton(Globals.lang("The Guide to Computing Literature"));
    private final JCheckBox absCheckBox = new JCheckBox(Globals.lang("Include abstracts"), false);
    private static final int perPage = 20;
    private static final int MAX_FETCH = 20;
    private static final int WAIT_TIME = 200;
    private int hits = 0;
    private int unparseable = 0;
    private int parsed = 0;
    private boolean shouldContinue = false;
    private boolean fetchAbstract = false;
    private boolean acmOrGuide = false;
    private static final Pattern hitsPattern = Pattern.compile(".*Found <b>(\\d+,*\\d*)</b>.*");
    private static final Pattern maxHitsPattern = Pattern.compile(".*Results \\d+ - \\d+ of (\\d+,*\\d*).*");
    private static final Pattern fullCitationPattern = Pattern.compile("<A HREF=\"(citation.cfm.*)\" class.*");
    private static final Pattern idPattern = Pattern.compile("citation.cfm\\?id=\\d*\\.?(\\d+)&.*");
    private static final Pattern titlePattern = Pattern.compile("<A HREF=.*?\">([^<]*)</A>");
    private static final Pattern monthYearPattern = Pattern.compile("([A-Za-z]+ [0-9]{4})");
    private static final Pattern absPattern = Pattern.compile("<div .*?>(.*?)</div>");
    private FetcherPreviewDialog preview;
    private int piv = 0;

    @Override
    public JPanel getOptionsPanel() {
        JPanel pan = new JPanel();
        pan.setLayout(new GridLayout(0, 1));
        this.guideButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.acmButton);
        group.add(this.guideButton);
        pan.add(this.absCheckBox);
        pan.add(this.acmButton);
        pan.add(this.guideButton);
        return pan;
    }

    @Override
    public boolean processQueryGetPreview(String query, FetcherPreviewDialog preview, OutputPrinter status) {
        this.preview = preview;
        this.status = status;
        this.terms = query;
        this.piv = 0;
        this.shouldContinue = true;
        this.parsed = 0;
        this.unparseable = 0;
        this.acmOrGuide = this.acmButton.isSelected();
        this.fetchAbstract = this.absCheckBox.isSelected();
        int firstEntry = 1;
        String address = this.makeUrl(firstEntry);
        LinkedHashMap<String, JLabel> previews = new LinkedHashMap<String, JLabel>();
        try {
            URL url = new URL(address);
            String page = this.getResults(url);
            this.hits = this.getNumberOfHits(page, "Found", hitsPattern);
            int index = page.indexOf("Found");
            if (index >= 0 && (index = (page = page.substring(index + 5)).indexOf("Found")) >= 0) {
                page = page.substring(index);
            }
            if (this.hits == 0) {
                status.showMessage(Globals.lang("No entries found for the search string '%0'", this.terms), Globals.lang("Search ACM Portal"), 1);
                return false;
            }
            this.hits = this.getNumberOfHits(page, "Results", maxHitsPattern);
            for (int i = 0; i < this.hits; ++i) {
                this.parse(page, 0, firstEntry, previews);
                firstEntry += 20;
            }
            for (String s : previews.keySet()) {
                preview.addEntry(s, previews.get(s));
            }
            return true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ConnectException e) {
            status.showMessage(Globals.lang("Connection to ACM Portal failed"), Globals.lang("Search ACM Portal"), 0);
        }
        catch (IOException e) {
            status.showMessage(Globals.lang(e.getMessage()), Globals.lang("Search ACM Portal"), 0);
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void getEntries(Map<String, Boolean> selection, ImportInspector inspector) {
        for (String id : selection.keySet()) {
            if (!this.shouldContinue) break;
            boolean sel = selection.get(id);
            if (!sel) continue;
            try {
                String abstr;
                BibtexEntry entry = this.downloadEntryBibTeX(id, this.fetchAbstract);
                if (entry == null) continue;
                String title = entry.getField("title");
                if (title != null) {
                    title = title.replaceAll("\\\\&", "&").replaceAll("\\\\#", "#");
                    title = this.convertHTMLChars(title);
                    if (Globals.prefs.getBoolean("useCaseKeeperOnSearch")) {
                        title = this.caseKeeper.format(title);
                    }
                    entry.setField("title", title);
                }
                if ((abstr = entry.getField("abstract")) != null) {
                    abstr = this.convertHTMLChars(abstr);
                    entry.setField("abstract", abstr);
                }
                inspector.addEntry(entry);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getWarningLimit() {
        return 10;
    }

    @Override
    public int getPreferredPreviewHeight() {
        return 75;
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        return false;
    }

    private String makeUrl(int startIndex) {
        StringBuffer sb = new StringBuffer(startUrl).append(searchUrlPart);
        sb.append(this.terms.replaceAll(" ", "%20"));
        sb.append("&start=").append(String.valueOf(startIndex));
        sb.append(searchUrlPartII);
        if (this.acmOrGuide) {
            sb.append("ACM");
        } else {
            sb.append("GUIDE");
        }
        sb.append(endUrl);
        return sb.toString();
    }

    private void parse(String text, int startIndex, int firstEntryNumber, Map<String, JLabel> entries) {
        this.piv = startIndex;
        int entryNumber = firstEntryNumber;
        while (this.getNextEntryURL(text, this.piv, entryNumber, entries)) {
            ++entryNumber;
        }
    }

    private String getEntryBibTeXURL(String fullCitation, boolean abs) {
        String bibAddr = "";
        String ID = "";
        Matcher idMatcher = idPattern.matcher(fullCitation);
        if (!idMatcher.find()) {
            System.out.println("Did not find ID in: " + fullCitation);
            return null;
        }
        ID = idMatcher.group(1);
        return ID;
    }

    private boolean getNextEntryURL(String allText, int startIndex, int entryNumber, Map<String, JLabel> entries) {
        String toFind = new StringBuffer().append("<strong>").append(entryNumber).append("</strong><br>").toString();
        int index = allText.indexOf(toFind, startIndex);
        int endIndex = allText.length();
        if (index >= 0) {
            this.piv = index + 1;
            String text = allText.substring(index, endIndex);
            Matcher fullCitation = fullCitationPattern.matcher(text);
            if (fullCitation.find()) {
                String part;
                String link = this.getEntryBibTeXURL(fullCitation.group(1), this.fetchAbstract);
                int endOfRecord = text.indexOf("<div class=\"abstract2\">");
                if (endOfRecord > 0) {
                    Matcher mY;
                    Matcher titM;
                    int authEnd;
                    StringBuilder sb = new StringBuilder();
                    part = text.substring(0, endOfRecord);
                    try {
                        this.save("part" + entryNumber + ".html", part);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    String authMarker = "<div class=\"authors\">";
                    int authStart = text.indexOf(authMarker);
                    if (authStart >= 0 && (authEnd = text.indexOf("</div>", authStart + authMarker.length())) >= 0) {
                        sb.append("<p>").append(text.substring(authStart, authEnd)).append("</p>");
                    }
                    if ((titM = titlePattern.matcher(part)).find()) {
                        sb.append("<p>").append(titM.group(1)).append("</p>");
                    }
                    if ((mY = monthYearPattern.matcher(part)).find()) {
                        sb.append("<p>").append(mY.group(1)).append("</p>");
                    }
                    part = sb.toString();
                } else {
                    part = link;
                }
                JLabel preview = new JLabel("<html>" + part + "</html>");
                preview.setPreferredSize(new Dimension(750, 100));
                entries.put(link, preview);
                return true;
            }
            System.out.printf("Citation Unmatched %d\n", entryNumber);
            System.out.printf(text, new Object[0]);
            return false;
        }
        return false;
    }

    private BibtexEntry downloadEntryBibTeX(String ID, boolean abs) throws IOException {
        try {
            URL url = new URL("http://portal.acm.org/exportformats.cfm?id=" + ID + bibtexUrlEnd);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            ParserResult result = BibtexParser.parse(in);
            in.close();
            Collection<BibtexEntry> item = result.getDatabase().getEntries();
            if (item.isEmpty()) {
                return null;
            }
            BibtexEntry entry = item.iterator().next();
            Thread.sleep(200L);
            if (abs) {
                url = new URL("http://portal.acm.org/tab_abstract.cfm?id=" + ID);
                String page = this.getResults(url);
                Matcher absM = absPattern.matcher(page);
                if (absM.find()) {
                    entry.setField("abstract", absM.group(1).trim());
                }
                Thread.sleep(200L);
            }
            return entry;
        }
        catch (NoSuchElementException e) {
            System.out.println("Bad Bibtex record read at: exportformats.cfm?id=" + ID + bibtexUrlEnd);
            e.printStackTrace();
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (ConnectException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String convertHTMLChars(String text) {
        return this.htmlConverter.format(text);
    }

    private int getNumberOfHits(String page, String marker, Pattern pattern) throws IOException {
        int ind = page.indexOf(marker);
        if (ind < 0) {
            throw new IOException(Globals.lang("Could not parse number of hits"));
        }
        String substring = page.substring(ind, Math.min(ind + 42, page.length()));
        Matcher m = pattern.matcher(substring);
        if (m.find()) {
            try {
                String number = m.group(1);
                number = number.replaceAll(",", "");
                return Integer.parseInt(number);
            }
            catch (NumberFormatException ex) {
                throw new IOException(Globals.lang("Could not parse number of hits"));
            }
            catch (IllegalStateException e) {
                throw new IOException(Globals.lang("Could not parse number of hits"));
            }
        }
        System.out.println("Unmatched!");
        System.out.println(substring);
        throw new IOException(Globals.lang("Could not parse number of hits"));
    }

    public String getResults(URL source) throws IOException {
        int bytesRead;
        InputStream in = source.openStream();
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[256];
        while ((bytesRead = in.read(buffer)) != -1) {
            for (int i = 0; i < bytesRead; ++i) {
                sb.append((char)buffer[i]);
            }
        }
        return sb.toString();
    }

    public String getResultsFromFile(File f) throws IOException {
        int bytesRead;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[256];
        while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
            for (int i = 0; i < bytesRead; ++i) {
                sb.append((char)buffer[i]);
            }
        }
        return sb.toString();
    }

    @Override
    public String getTitle() {
        return "ACM Portal";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getHelpPage() {
        return "ACMPortalHelp.html";
    }

    @Override
    public String getKeyName() {
        return "ACM Portal";
    }

    public void cancelled() {
        this.shouldContinue = false;
    }

    public void done(int entriesImported) {
    }

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    private void save(String filename, String content) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        out.write(content);
        out.close();
    }
}

