/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.DragDropPane;

public class DragDropPopupPane
extends DragDropPane {
    private JPopupMenu popupMenu = null;

    public DragDropPopupPane(AbstractAction manageSelectorsAction, AbstractAction databasePropertiesAction, AbstractAction bibtexKeyPatternAction) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DragDropPopupPane.this.tabClicked(e);
            }
        });
        this.initPopupMenu(manageSelectorsAction, databasePropertiesAction, bibtexKeyPatternAction);
    }

    private void initPopupMenu(AbstractAction manageSelectorsAction, AbstractAction databasePropertiesAction, AbstractAction bibtexKeyPatternAction) {
        this.popupMenu = new JPopupMenu();
        JMenuItem databasePropertiesBtn = new JMenuItem(Globals.lang("Database properties"));
        databasePropertiesBtn.addActionListener(databasePropertiesAction);
        this.popupMenu.add(databasePropertiesBtn);
        JMenuItem bibtexKeyPatternBtn = new JMenuItem(Globals.lang("Bibtex key patterns"));
        bibtexKeyPatternBtn.addActionListener(bibtexKeyPatternAction);
        this.popupMenu.add(bibtexKeyPatternBtn);
        JMenuItem manageSelectorsBtn = new JMenuItem(Globals.lang("Manage content selectors"));
        manageSelectorsBtn.addActionListener(manageSelectorsAction);
        this.popupMenu.add(manageSelectorsBtn);
        JMenuItem closeBtn = new JMenuItem(Globals.lang("Close"), GUIGlobals.getImage("close"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DragDropPopupPane.this.closeSelectedTab();
                    }
                });
            }
        });
        this.popupMenu.add(closeBtn);
    }

    private void tabClicked(MouseEvent e) {
        if (e.getButton() != 1 && e.getClickCount() == 1) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY() - 10);
        }
    }

    private void closeSelectedTab() {
        this.remove(this.getSelectedIndex());
    }
}

