/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.autocompleter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;

public abstract class AbstractAutoCompleter {
    public static int SHORTEST_TO_COMPLETE = Globals.prefs.getInt("shortestToComplete");
    public static final int SHORTEST_WORD = 4;
    private TreeSet<String> _index_casesensitive = new TreeSet();
    private TreeSet<String> _index_caseinsensitive = new TreeSet();
    private HashMap<String, TreeSet<String>> _possibleStringsForSearchString = new HashMap();

    public abstract void addBibtexEntry(BibtexEntry var1);

    public abstract boolean isSingleUnitField();

    public String[] complete(String str) {
        if (AbstractAutoCompleter.stringMinLength(str)) {
            return null;
        }
        String lstr = str.toLowerCase();
        if (lstr.equals(str)) {
            String ender = AbstractAutoCompleter.incrementLastCharacter(lstr);
            SortedSet<String> subset = this._index_caseinsensitive.subSet(lstr, ender);
            ArrayList res = new ArrayList();
            for (String s : subset) {
                res.addAll(this._possibleStringsForSearchString.get(s));
            }
            return res.toArray(new String[0]);
        }
        String ender = AbstractAutoCompleter.incrementLastCharacter(str);
        SortedSet<String> subset = this._index_casesensitive.subSet(str, ender);
        return subset.toArray(new String[0]);
    }

    private static String incrementLastCharacter(String str) {
        char lastChar = str.charAt(str.length() - 1);
        String ender = str.substring(0, str.length() - 1) + Character.toString((char)(lastChar + '\u0001'));
        return ender;
    }

    private static boolean stringMinLength(String str) {
        return str.length() < SHORTEST_TO_COMPLETE;
    }

    public void addWordToIndex(String word) {
        if (word.length() >= 4) {
            this._index_casesensitive.add(word);
            String word_lcase = word.toLowerCase();
            this._index_caseinsensitive.add(word_lcase);
            TreeSet<String> set = this._possibleStringsForSearchString.get(word_lcase);
            if (set == null) {
                set = new TreeSet();
            }
            set.add(word);
            this._possibleStringsForSearchString.put(word_lcase, set);
        }
    }

    public boolean indexContainsWord(String word) {
        return this._index_caseinsensitive.contains(word.toLowerCase());
    }

    public String getPrefix() {
        return "";
    }
}

