/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart.file;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.ws.rs.core.MediaType;

public class StreamDataBodyPart
extends FormDataBodyPart {
    private InputStream streamEntity;
    private String filename;

    public StreamDataBodyPart() {
    }

    public StreamDataBodyPart(String name, InputStream streamEntity) {
        this(name, streamEntity, null, null);
    }

    public StreamDataBodyPart(String name, InputStream streamEntity, String filename) {
        this(name, streamEntity, filename, null);
    }

    public StreamDataBodyPart(String name, InputStream streamEntity, String filename, MediaType mediaType) {
        if (name == null || streamEntity == null) {
            MessageFormat msg = new MessageFormat("Neither the \"name\" nor \"streamEntity\" can be null. Passed values: \"{0}\" \"{1}\"");
            throw new IllegalArgumentException(msg.format(new Object[]{name, streamEntity}));
        }
        this.setFilename(filename);
        super.setName(name);
        if (mediaType != null) {
            this.setStreamEntity(streamEntity, mediaType);
        } else {
            this.setStreamEntity(streamEntity, StreamDataBodyPart.getDefaultMediaType());
        }
    }

    @Override
    public void setValue(MediaType mediaType, Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is unsupported, please use setStreamEntity(-) instead!");
    }

    @Override
    public void setValue(String value) {
        throw new UnsupportedOperationException("It is unsupported, please use setStreamEntity(-) instead!");
    }

    @Override
    public void setEntity(Object entity) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is unsupported, please use setStreamEntity(-) instead!");
    }

    public void setStreamEntity(InputStream streamEntity) {
        this.setStreamEntity(streamEntity, StreamDataBodyPart.getDefaultMediaType());
    }

    public void setStreamEntity(InputStream streamEntity, MediaType mediaType) {
        if (streamEntity == null) {
            throw new IllegalArgumentException("Stream body part entity cannot be null.");
        }
        if (mediaType == null) {
            mediaType = StreamDataBodyPart.getDefaultMediaType();
        }
        this.streamEntity = streamEntity;
        super.setMediaType(mediaType);
        super.setEntity(streamEntity);
        this.setFormDataContentDisposition(this.buildContentDisposition());
    }

    protected FormDataContentDisposition buildContentDisposition() {
        FormDataContentDisposition.FormDataContentDispositionBuilder builder = FormDataContentDisposition.name(this.getName());
        if (this.filename != null) {
            builder.fileName(this.filename);
        } else {
            builder.fileName(this.getName());
        }
        return builder.build();
    }

    protected static MediaType getDefaultMediaType() {
        return MediaType.APPLICATION_OCTET_STREAM_TYPE;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public InputStream getStreamEntity() {
        return this.streamEntity;
    }

    public String getFilename() {
        return this.filename;
    }
}

