/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenMediaDB;
import mediathek.file.GetFile;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.res.GetIcon;
import mediathek.tool.CellRendererMediaDB;
import mediathek.tool.HinweisKeineAuswahl;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.TModel;
import mediathek.tool.TModelMediaDB;

public class PanelMediaDB
extends PanelVorlage {
    private final TModel modelPath = new TModel(new Object[0][], new String[]{"Pfad"});
    private final TModelMediaDB modelFilm = new TModelMediaDB(new Object[0][], DatenMediaDB.COLUMN_NAMES);
    private ButtonGroup buttonGroup1;
    private JButton jButtonAdd;
    private JButton jButtonExport;
    private JButton jButtonExportPath;
    private JButton jButtonHelp;
    private JButton jButtonMakeIndex;
    private JButton jButtonPath;
    private JButton jButtonRemove;
    private JCheckBox jCheckBoxMediaDB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelSizeIndex;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JRadioButton jRadioButtonMitSuffix;
    private JRadioButton jRadioButtonOhneSuffix;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JTable jTableMediaDB;
    private JTable jTablePath;
    private JTextField jTextFieldExportPath;
    private JTextField jTextFieldPath;
    private JTextField jTextFieldSuffix;
    private JToggleButton jToggleButtonLoad;
    private JProgressBar progress;

    public PanelMediaDB(Daten d, JFrame parent) {
        super(d, parent);
        this.initComponents();
        this.daten = d;
        ListenerMediathekView.addListener(new ListenerMediathekView(41, PanelMediaDB.class.getSimpleName()){

            @Override
            public void ping() {
                PanelMediaDB.this.setIndex(false);
                PanelMediaDB.this.modelFilm.setRowCount(0);
                PanelMediaDB.this.jToggleButtonLoad.setSelected(false);
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(42, PanelMediaDB.class.getSimpleName()){

            @Override
            public void ping() {
                PanelMediaDB.this.jLabelSizeIndex.setText(Daten.mVMediaDB.getSizeFileArray() + "");
                PanelMediaDB.this.setIndex(true);
            }
        });
        this.progress.setVisible(false);
        this.progress.setIndeterminate(true);
        this.progress.setMaximum(0);
        this.progress.setMinimum(0);
        this.progress.setValue(0);
        this.jTablePath.setModel(this.modelPath);
        CellRendererMediaDB cellRenderer = new CellRendererMediaDB();
        this.jTableMediaDB.setDefaultRenderer(Object.class, cellRenderer);
        this.jTableMediaDB.setModel(this.modelFilm);
        this.jTextFieldSuffix.setText(Daten.mVConfig.get("Media_DB_Suffix"));
        this.jTextFieldSuffix.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                Daten.mVConfig.add("Media_DB_Suffix", PanelMediaDB.this.jTextFieldSuffix.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Daten.mVConfig.add("Media_DB_Suffix", PanelMediaDB.this.jTextFieldSuffix.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                Daten.mVConfig.add("Media_DB_Suffix", PanelMediaDB.this.jTextFieldSuffix.getText());
            }
        });
        this.jRadioButtonOhneSuffix.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Media_DB_ohne-Suffix")));
        this.jRadioButtonMitSuffix.setSelected(!Boolean.parseBoolean(Daten.mVConfig.get("Media_DB_ohne-Suffix")));
        this.jRadioButtonOhneSuffix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Media_DB_ohne-Suffix", Boolean.toString(PanelMediaDB.this.jRadioButtonOhneSuffix.isSelected()));
            }
        });
        this.jRadioButtonMitSuffix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Media_DB_ohne-Suffix", Boolean.toString(PanelMediaDB.this.jRadioButtonOhneSuffix.isSelected()));
            }
        });
        this.jCheckBoxMediaDB.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Media_DB_Echtzeitsuche")));
        this.jCheckBoxMediaDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Daten.mVConfig.add("Media_DB_Echtzeitsuche", Boolean.toString(PanelMediaDB.this.jCheckBoxMediaDB.isSelected()));
            }
        });
        this.jButtonMakeIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelMediaDB.this.jLabelSizeIndex.setText("0");
                Daten.mVMediaDB.makeIndex();
            }
        });
        this.jButtonPath.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.jButtonAdd.setIcon(GetIcon.getProgramIcon("add_16.png"));
        this.jButtonRemove.setIcon(GetIcon.getProgramIcon("remove_16.png"));
        this.jButtonPath.addActionListener(new BeobPath());
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelMediaDB.this.addPath();
            }
        });
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelMediaDB.this.removePath();
            }
        });
        this.jButtonHelp.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(PanelMediaDB.this.daten.mediathekGui, true, new GetFile().getHilfeSuchen(GetFile.PFAD_HILFETEXT_PANEL_MEDIA_DB)).setVisible(true);
            }
        });
        this.jButtonExportPath.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.jTextFieldExportPath.setText(Daten.mVConfig.get("Media_DB_export-datei"));
        this.jTextFieldExportPath.getDocument().addDocumentListener(new BeobTextFeld());
        this.jButtonExport.addActionListener(new BeobExport());
        this.jButtonExportPath.addActionListener(new BeobPfad());
        this.jToggleButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelMediaDB.this.jToggleButtonLoad.isSelected()) {
                    Daten.mVMediaDB.getModelMediaDB(PanelMediaDB.this.modelFilm);
                } else {
                    PanelMediaDB.this.modelFilm.setRowCount(0);
                }
            }
        });
        this.setTablePath();
    }

    private void filmeExportieren() {
        String exporDatei = this.jTextFieldExportPath.getText();
        if (exporDatei.equals("")) {
            MVMessageDialog.showMessageDialog(this.parentComponent, "Keine Datei angegeben", "Pfad", 1);
        } else {
            try {
                int ret = new File(exporDatei).exists() ? JOptionPane.showConfirmDialog(this.parentComponent, "Datei:  \"" + exporDatei + "\"" + "  existiert bereits", "\u00dcberschreiben?", 0) : 0;
                if (ret == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.updateUI();
                    Daten.mVMediaDB.writeFileArray(exporDatei);
                    if (!new File(exporDatei).exists()) {
                        MVMessageDialog.showMessageDialog(this.parentComponent, "Datei:  \"" + exporDatei + "\"" + "  Konnte nicht erstellt werden!", "Fehler", 0);
                    }
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(732165489, ex);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setIndex(boolean noIndex) {
        this.progress.setVisible(!noIndex);
        this.jTextFieldPath.setEnabled(noIndex);
        this.jButtonMakeIndex.setEnabled(noIndex);
        this.jButtonAdd.setEnabled(noIndex);
        this.jButtonPath.setEnabled(noIndex);
        this.jButtonRemove.setEnabled(noIndex);
    }

    private void addPath() {
        String db = Daten.mVConfig.get("Media_DB_Pfade-Medien");
        String add = this.jTextFieldPath.getText();
        if (add.isEmpty()) {
            return;
        }
        for (String s : db.split(Daten.mVMediaDB.FILE_TRENNER)) {
            if (!s.equals(add)) continue;
            return;
        }
        db = db.isEmpty() ? add : db + Daten.mVMediaDB.FILE_TRENNER + add;
        Daten.mVConfig.add("Media_DB_Pfade-Medien", db);
        this.setTablePath();
    }

    private void removePath() {
        int row = this.jTablePath.getSelectedRow();
        if (row >= 0) {
            String p = this.jTablePath.getModel().getValueAt(this.jTablePath.convertRowIndexToModel(row), 0).toString();
            String db = Daten.mVConfig.get("Media_DB_Pfade-Medien");
            String dbNew = "";
            if (db.isEmpty()) {
                return;
            }
            for (String s : db.split(Daten.mVMediaDB.FILE_TRENNER)) {
                if (s.equals(p)) continue;
                dbNew = dbNew + (dbNew.isEmpty() ? s : Daten.mVMediaDB.FILE_TRENNER + s);
            }
            Daten.mVConfig.add("Media_DB_Pfade-Medien", dbNew);
            this.setTablePath();
        } else {
            new HinweisKeineAuswahl().zeigen(this.daten.mediathekGui);
        }
    }

    private synchronized void setTablePath() {
        String db = Daten.mVConfig.get("Media_DB_Pfade-Medien");
        this.modelPath.setRowCount(0);
        if (!db.isEmpty()) {
            for (String s : db.split(Daten.mVMediaDB.FILE_TRENNER)) {
                this.modelPath.addRow(new Object[]{s});
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonHelp = new JButton();
        this.progress = new JProgressBar();
        this.jButtonMakeIndex = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel6 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTablePath = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jTextFieldPath = new JTextField();
        this.jButtonPath = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jCheckBoxMediaDB = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jRadioButtonOhneSuffix = new JRadioButton();
        this.jRadioButtonMitSuffix = new JRadioButton();
        this.jTextFieldSuffix = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldExportPath = new JTextField();
        this.jButtonExportPath = new JButton();
        this.jButtonExport = new JButton();
        this.jPanel5 = new JPanel();
        this.jToggleButtonLoad = new JToggleButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableMediaDB = new JTable();
        this.jLabel2 = new JLabel();
        this.jLabelSizeIndex = new JLabel();
        this.setMinimumSize(new Dimension(2, 483));
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        this.jButtonMakeIndex.setText("Index neu aufbauen");
        this.jButtonMakeIndex.setToolTipText("");
        this.jLabel5.setText("In den Pfaden nach Medien suchen");
        this.jTablePath.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.jTablePath);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)), "Pfad hinzuf\u00fcgen/entfernen"));
        this.jLabel4.setText("Pfad:");
        this.jButtonPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jButtonAdd.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/add_16.png")));
        this.jButtonRemove.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/remove_16.png")));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRemove).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonRemove).addComponent(this.jButtonAdd).addComponent(this.jButtonPath).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldPath, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonAdd, this.jButtonPath, this.jButtonRemove, this.jTextFieldPath);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 420, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel5).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 295, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.jTabbedPane1.addTab("Pfade", this.jPanel6);
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jCheckBoxMediaDB.setText("Echtzeitsuche in der Mediensammlung");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxMediaDB).addContainerGap(113, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxMediaDB).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.buttonGroup1.add(this.jRadioButtonOhneSuffix);
        this.jRadioButtonOhneSuffix.setSelected(true);
        this.jRadioButtonOhneSuffix.setText("Keine Dateien mit diesem Suffix");
        this.buttonGroup1.add(this.jRadioButtonMitSuffix);
        this.jRadioButtonMitSuffix.setText("Nur Dateien mit diesem Suffix");
        this.jTextFieldSuffix.setText("txt,xml");
        this.jLabel6.setText("(z.B.: txt,xml,jpg)");
        this.jLabel7.setText("(z.B.: mp4,flv,m4v)");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldSuffix).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonMitSuffix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel7)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonOhneSuffix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE).addComponent(this.jLabel6))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonOhneSuffix).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonMitSuffix).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldSuffix, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.jPanel7.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jLabel1.setText("Export Index:");
        this.jButtonExportPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jButtonExport.setText("Exportieren");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldExportPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExportPath)).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonExport))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel1).addComponent(this.jTextFieldExportPath, -2, -1, -2).addComponent(this.jButtonExportPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExport).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel7Layout.linkSize(1, this.jButtonExportPath, this.jTextFieldExportPath);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel7, -2, -1, -2).addContainerGap(168, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Einrichten", this.jPanel4);
        this.jToggleButtonLoad.setText("Laden");
        this.jTableMediaDB.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.jScrollPane2.setViewportView(this.jTableMediaDB);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButtonLoad).addComponent(this.jScrollPane2, -1, 420, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 369, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToggleButtonLoad).addContainerGap()));
        this.jTabbedPane1.addTab("Dateiliste", this.jPanel5);
        this.jLabel2.setText("Anzahl Medien:");
        this.jLabelSizeIndex.setText("0");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTabbedPane1).addGroup(layout.createSequentialGroup().addComponent(this.progress, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSizeIndex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMakeIndex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.progress, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabelSizeIndex).addComponent(this.jButtonMakeIndex).addComponent(this.jButtonHelp)).addContainerGap()));
    }

    private class BeobExport
    implements ActionListener {
        private BeobExport() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanelMediaDB.this.filmeExportieren();
        }
    }

    private class BeobPfad
    implements ActionListener {
        private BeobPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemInfo.isMacOSX()) {
                FileDialog chooser = new FileDialog((Frame)PanelMediaDB.this.daten.mediathekGui, "Filme exportieren");
                chooser.setMode(1);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        PanelMediaDB.this.jTextFieldExportPath.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(679890147, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!PanelMediaDB.this.jTextFieldExportPath.getText().equals("")) {
                    chooser.setCurrentDirectory(new File(PanelMediaDB.this.jTextFieldExportPath.getText()));
                }
                chooser.setFileSelectionMode(0);
                chooser.setFileHidingEnabled(false);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        PanelMediaDB.this.jTextFieldExportPath.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(911025463, ex);
                    }
                }
            }
        }
    }

    private class BeobTextFeld
    implements DocumentListener {
        private BeobTextFeld() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        void tusEinfach(DocumentEvent e) {
            Daten.mVConfig.add("Media_DB_export-datei", PanelMediaDB.this.jTextFieldExportPath.getText());
        }
    }

    private class BeobPath
    implements ActionListener {
        private BeobPath() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemInfo.isMacOSX()) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                FileDialog chooser = new FileDialog((Frame)PanelMediaDB.this.daten.mediathekGui, "Pfad zu den Filmen w\u00e4hlen");
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        PanelMediaDB.this.jTextFieldPath.setText(new File(chooser.getDirectory() + chooser.getFile()).getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(951024789, ex);
                    }
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                int returnVal;
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                if (!PanelMediaDB.this.jTextFieldPath.getText().equals("")) {
                    chooser.setCurrentDirectory(new File(PanelMediaDB.this.jTextFieldPath.getText()));
                }
                if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                    try {
                        PanelMediaDB.this.jTextFieldPath.setText(chooser.getSelectedFile().getPath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(765212369, ex);
                    }
                }
            }
        }
    }
}

