/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenMediaDB;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.res.GetIcon;
import mediathek.tool.CellRendererMediaDB;
import mediathek.tool.DirOpenAction;
import mediathek.tool.EscBeenden;
import mediathek.tool.FilenameUtils;
import mediathek.tool.Filter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.HinweisKeineAuswahl;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MVTable;
import mediathek.tool.OpenPlayerAction;
import mediathek.tool.TModelMediaDB;

public class DialogMediaDB
extends JDialog {
    private final JFrame parent;
    private boolean init = false;
    private MVTable tabelleFilme;
    private JButton jButtonBeenden;
    private JButton jButtonHelp;
    private JButton jButtonIndex;
    private JButton jButtonSearch;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelSizeFound;
    private JLabel jLabelSum;
    private JScrollPane jScrollPane3;
    private JTable jTableFilm;
    private JTextField jTextFieldFilmPfad;
    private JTextField jTextFieldFilmTitle;
    private JTextField jTextFieldSearch;
    private JProgressBar progress;

    public DialogMediaDB(JFrame pparent) {
        super((Frame)pparent, false);
        this.initComponents();
        this.parent = pparent;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogMediaDB.this.beenden();
            }
        });
        this.setTitle("Mediensammlung durchsuchen");
        ListenerMediathekView.addListener(new ListenerMediathekView(41, DialogMediaDB.class.getSimpleName()){

            @Override
            public void ping() {
                DialogMediaDB.this.setIndex(false);
                DialogMediaDB.this.jLabelSum.setText("0");
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(42, DialogMediaDB.class.getSimpleName()){

            @Override
            public void ping() {
                DialogMediaDB.this.setIndex(true);
                DialogMediaDB.this.jLabelSum.setText(Daten.mVMediaDB.getSizeFileArray() + "");
                DialogMediaDB.this.search();
            }
        });
        this.tabelleFilme = new MVTable(5);
        this.jScrollPane3.setViewportView(this.tabelleFilme);
        TModelMediaDB modelFilm = new TModelMediaDB(new Object[0][], DatenMediaDB.COLUMN_NAMES);
        CellRendererMediaDB cellRenderer = new CellRendererMediaDB();
        this.tabelleFilme.setDefaultRenderer(Object.class, cellRenderer);
        this.tabelleFilme.setModel(modelFilm);
        this.tabelleFilme.addMouseListener(new BeobMausTabelle());
        this.tabelleFilme.getSelectionModel().addListSelectionListener(new BeobTableSelect());
        this.tabelleFilme.setAutoResizeMode(2);
        this.tabelleFilme.initTabelle();
        this.progress.setVisible(false);
        this.progress.setIndeterminate(true);
        this.progress.setMaximum(0);
        this.progress.setMinimum(0);
        this.progress.setValue(0);
        this.jTextFieldSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMediaDB.this.search();
            }
        });
        this.jTextFieldSearch.getDocument().addDocumentListener(new BeobDoc());
        this.jButtonIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVMediaDB.makeIndex();
            }
        });
        this.jButtonHelp.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(DialogMediaDB.this.parent, true, new GetFile().getHilfeSuchen(GetFile.PFAD_HILFETEXT_DIALOG_MEDIA_DB)).setVisible(true);
            }
        });
        this.jButtonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMediaDB.this.search();
            }
        });
        this.jButtonBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMediaDB.this.beenden();
            }
        });
        new EscBeenden(this){

            @Override
            public void beenden_() {
                DialogMediaDB.this.beenden();
            }
        };
        GuiFunktionen.setSize("Media_DB_Dialog-Groesse", this, this.parent);
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis && Daten.mVConfig.get("Media_DB_Pfade-Medien").isEmpty()) {
            JOptionPane.showMessageDialog(this.parent, "Erst in den Einstellungen eine Mediensammlung einrichten.", "Mediensammlung leer!", 0);
        }
        if (!this.init) {
            Daten.mVMediaDB.makeIndex();
            this.init = true;
        }
    }

    public final void setVis() {
        this.setVisible(Boolean.parseBoolean(Daten.mVConfig.get("Media_DB_Dialog-anzeigen")));
        ListenerMediathekView.notify(37, DialogMediaDB.class.getName());
    }

    public void tabelleSpeichern() {
        if (this.tabelleFilme != null) {
            this.tabelleFilme.tabelleNachDatenSchreiben();
        }
    }

    public void setFilter(String titel) {
        titel = FilenameUtils.replaceLeerDateiname(titel, false);
        this.jTextFieldSearch.setText(titel);
    }

    private void search() {
        TModelMediaDB m = new TModelMediaDB(new Object[0][], DatenMediaDB.COLUMN_NAMES);
        Daten.mVMediaDB.searchFiles(m, this.jTextFieldSearch.getText());
        this.tabelleFilme.getSpalten();
        this.tabelleFilme.setModel(m);
        this.tabelleFilme.setSpalten();
        this.jLabelSizeFound.setText(m.getRowCount() + "");
    }

    private void setIndex(boolean noIndex) {
        this.progress.setVisible(!noIndex);
        this.jTextFieldSearch.setEnabled(noIndex);
        this.jButtonSearch.setEnabled(noIndex);
        this.jButtonIndex.setEnabled(noIndex);
    }

    private void zielordnerOeffnen() {
        int row = this.tabelleFilme.getSelectedRow();
        if (row >= 0) {
            String s = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 1);
            DirOpenAction.zielordnerOeffnen(this.parent, s);
        } else {
            new HinweisKeineAuswahl().zeigen(this.parent);
        }
    }

    private void filmAbspielen_() {
        int row = this.tabelleFilme.getSelectedRow();
        if (row >= 0) {
            String file = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 0);
            String path = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 1);
            OpenPlayerAction.filmAbspielen(this.parent, path + File.separator + file);
        } else {
            new HinweisKeineAuswahl().zeigen(this.parent);
        }
    }

    private void aktFilmSetzen() {
        int row = this.tabelleFilme.getSelectedRow();
        if (row >= 0) {
            String file = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 0);
            String path = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 1);
            this.jTextFieldFilmTitle.setText(file);
            this.jTextFieldFilmPfad.setText(path);
        } else {
            this.jTextFieldFilmTitle.setText("");
            this.jTextFieldFilmPfad.setText("");
        }
    }

    private void filmLoeschen_() {
        String del = "";
        int row = this.tabelleFilme.getSelectedRow();
        if (row < 0) {
            new HinweisKeineAuswahl().zeigen(this.parent);
            return;
        }
        try {
            String file = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 0);
            String path = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 1);
            del = path + File.separator + file;
            File delFile = new File(del);
            if (!delFile.exists()) {
                MVMessageDialog.showMessageDialog(this.parent, "Die Datei existiert nicht!", "Film l\u00f6schen", 0);
                return;
            }
            int ret = JOptionPane.showConfirmDialog(this.parent, delFile.getAbsolutePath(), "Film L\u00f6schen?", 0);
            if (ret != 0) {
                return;
            }
            Log.systemMeldung(new String[]{"Datei l\u00f6schen: ", delFile.getAbsolutePath()});
            if (!delFile.delete()) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            MVMessageDialog.showMessageDialog(this.parent, "Konnte die Datei nicht l\u00f6schen!", "Film l\u00f6schen", 0);
            Log.fehlerMeldung(984512036, "Fehler beim l\u00f6schen: " + del);
        }
    }

    private void beenden() {
        Daten.mVConfig.add("Media_DB_Dialog-anzeigen", Boolean.FALSE.toString());
        this.setVis();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jButtonBeenden = new JButton();
        this.jButtonHelp = new JButton();
        this.jTextFieldSearch = new JTextField();
        this.jButtonSearch = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTableFilm = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabelSizeFound = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButtonIndex = new JButton();
        this.jLabelSum = new JLabel();
        this.progress = new JProgressBar();
        this.jLabel3 = new JLabel();
        this.jTextFieldFilmTitle = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextFieldFilmPfad = new JTextField();
        this.jLabel2.setText("jLabel2");
        this.setDefaultCloseOperation(2);
        this.jButtonBeenden.setText("Ok");
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        this.jButtonSearch.setText("Suchen");
        this.jTableFilm.setAutoCreateRowSorter(true);
        this.jTableFilm.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane3.setViewportView(this.jTableFilm);
        this.jLabel1.setText("Treffer:");
        this.jLabelSizeFound.setText("0");
        this.jLabel4.setText("Anzahl Medien gesamt:");
        this.jButtonIndex.setText("Index neu aufbauen");
        this.jLabelSum.setText("0");
        this.jLabel3.setText("Titel:");
        this.jTextFieldFilmTitle.setEditable(false);
        this.jLabel5.setText("Pfad:");
        this.jTextFieldFilmPfad.setEditable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 536, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.progress, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonIndex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBeenden, -2, 93, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSum).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSizeFound)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilmTitle)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilmPfad))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSearch, -2, -1, -2).addComponent(this.jButtonSearch)).addComponent(this.jButtonHelp)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabelSum)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabelSizeFound))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 490, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldFilmTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextFieldFilmPfad, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.progress, -2, -1, -2).addComponent(this.jButtonIndex).addComponent(this.jButtonBeenden)).addContainerGap()));
        layout.linkSize(1, this.jButtonHelp, this.jButtonSearch, this.jTextFieldSearch);
        this.pack();
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        private Point p;

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = DialogMediaDB.this.tabelleFilme.rowAtPoint(this.p);
            if (nr >= 0) {
                DialogMediaDB.this.tabelleFilme.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem itemPlayerDownload = new JMenuItem("gespeicherten Film (Datei) abspielen");
            itemPlayerDownload.setIcon(GetIcon.getProgramIcon("film_start_16.png"));
            itemPlayerDownload.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogMediaDB.this.filmAbspielen_();
                }
            });
            jPopupMenu.add(itemPlayerDownload);
            JMenuItem itemDeleteDownload = new JMenuItem("gespeicherten Film (Datei) l\u00f6schen");
            itemDeleteDownload.setIcon(GetIcon.getProgramIcon("film_del_16.png"));
            itemDeleteDownload.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogMediaDB.this.filmLoeschen_();
                }
            });
            jPopupMenu.add(itemDeleteDownload);
            JMenuItem itemOeffnen = new JMenuItem("Zielordner \u00f6ffnen");
            itemOeffnen.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
            jPopupMenu.add(itemOeffnen);
            itemOeffnen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DialogMediaDB.this.zielordnerOeffnen();
                }
            });
            jPopupMenu.addSeparator();
            JMenuItem itemResetTab = new JMenuItem("Tabelle zur\u00fccksetzen");
            jPopupMenu.add(itemResetTab);
            itemResetTab.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DialogMediaDB.this.tabelleFilme.resetTabelle();
                }
            });
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private class BeobDoc
    implements DocumentListener {
        private BeobDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            Filter.checkPattern1(DialogMediaDB.this.jTextFieldSearch);
            if (Boolean.parseBoolean(Daten.mVConfig.get("Media_DB_Echtzeitsuche"))) {
                DialogMediaDB.this.search();
            }
        }
    }

    private class BeobTableSelect
    implements ListSelectionListener {
        private BeobTableSelect() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                DialogMediaDB.this.aktFilmSetzen();
            }
        }
    }
}

