/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.starter;

import java.util.concurrent.Semaphore;
import mediathek.daten.Daten;
import mediathek.tool.ListenerMediathekView;

public class MVBandwidthTokenBucket {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private final Semaphore bucketSize = new Semaphore(0, false);
    public static final int BANDWIDTH_MAX_RED_KBYTE = 500;
    public static final int BANDWIDTH_MAX_BYTE = 1000000;
    public static final int BANDWIDTH_MAX_KBYTE = 1000;
    private volatile int bucketCapacity = 500000;
    private MVBandwidthTokenBucketFillerThread fillerThread = null;

    public MVBandwidthTokenBucket() {
        this.setBucketCapacity(this.getBandwidth());
        ListenerMediathekView.addListener(new ListenerMediathekView(28, MVBandwidthTokenBucket.class.getSimpleName()){

            @Override
            public void ping() {
                MVBandwidthTokenBucket.this.setBucketCapacity(MVBandwidthTokenBucket.this.getBandwidth());
            }
        });
    }

    public synchronized void ensureBucketThreadIsRunning() {
        if (this.fillerThread == null) {
            this.fillerThread = new MVBandwidthTokenBucketFillerThread();
            this.fillerThread.start();
        }
    }

    public void takeBlocking(int howMany) {
        if (this.getBucketCapacity() < 1000000) {
            try {
                this.bucketSize.acquire(howMany);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void takeBlocking() {
        this.takeBlocking(1);
    }

    public synchronized int getBucketCapacity() {
        return this.bucketCapacity;
    }

    private void terminateFillerThread() {
        if (this.fillerThread != null) {
            this.fillerThread.interrupt();
            this.fillerThread = null;
        }
    }

    public synchronized void setBucketCapacity(int bucketCapacity) {
        this.bucketCapacity = bucketCapacity;
        if (bucketCapacity == 1000000) {
            this.terminateFillerThread();
            while (this.bucketSize.hasQueuedThreads()) {
                this.bucketSize.release();
            }
            this.bucketSize.drainPermits();
        } else {
            this.terminateFillerThread();
            this.bucketSize.drainPermits();
            this.ensureBucketThreadIsRunning();
        }
    }

    private int getBandwidth() {
        int bytesPerSecond;
        try {
            int maxKBytePerSec = (int)Long.parseLong(Daten.mVConfig.get("maxBandbreite"));
            bytesPerSecond = maxKBytePerSec * 1000;
        }
        catch (Exception ex) {
            bytesPerSecond = 1000000;
            Daten.mVConfig.add("maxBandbreite", "1000");
        }
        return bytesPerSecond;
    }

    private class MVBandwidthTokenBucketFillerThread
    extends Thread {
        public MVBandwidthTokenBucketFillerThread() {
            this.setName("MVBandwidthTokenBucket Filler Thread");
        }

        @Override
        public void run() {
            try {
                int bucketCapacity;
                while (!this.isInterrupted() && (bucketCapacity = MVBandwidthTokenBucket.this.getBucketCapacity()) != 1000000) {
                    int releaseCount = bucketCapacity / 2 - MVBandwidthTokenBucket.this.bucketSize.availablePermits();
                    if (releaseCount > 0) {
                        MVBandwidthTokenBucket.this.bucketSize.release(releaseCount);
                    }
                    MVBandwidthTokenBucketFillerThread.sleep(500L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

