/*
 * Decompiled with CFR 0.152.
 */
package msearch.daten;

import java.text.SimpleDateFormat;
import java.util.Date;
import msearch.tool.DatumFilm;
import msearch.tool.GermanStringSorter;
import msearch.tool.MSFileSize;
import msearch.tool.MSFunktionen;
import msearch.tool.MSLog;
import msearch.tool.MSLong;

public class DatenFilm
implements Comparable<DatenFilm> {
    private static GermanStringSorter sorter = GermanStringSorter.getInstance();
    private static SimpleDateFormat sdf_datum_zeit = new SimpleDateFormat("dd.MM.yyyyHH:mm:ss");
    private static SimpleDateFormat sdf_datum = new SimpleDateFormat("dd.MM.yyyy");
    public static final String AUFLOESUNG_NORMAL = "normal";
    public static final String AUFLOESUNG_HD = "hd";
    public static final String AUFLOESUNG_KLEIN = "klein";
    public static final String GEO_DE = "DE";
    public static final String GEO_AT = "AT";
    public static final String GEO_CH = "CH";
    public static final String GEO_EU = "EU";
    public static final String GEO_WELT = "WELT";
    public static final String FELD_INFO = "Feldinfo";
    public static final String FILME = "Filme";
    public static final String FILME_ = "X";
    public static final String FILM_NR = "Nr";
    public static final String FILM_NR_ = "a";
    public static final int FILM_NR_NR = 0;
    public static final String FILM_SENDER = "Sender";
    public static final String FILM_SENDER_ = "b";
    public static final int FILM_SENDER_NR = 1;
    public static final String FILM_THEMA = "Thema";
    public static final String FILM_THEMA_ = "c";
    public static final int FILM_THEMA_NR = 2;
    public static final String FILM_TITEL = "Titel";
    public static final String FILM_TITEL_ = "d";
    public static final int FILM_TITEL_NR = 3;
    public static final String FILM_ABSPIELEN = "";
    public static final String FILM_ABSPIELEN_ = "v";
    public static final int FILM_ABSPIELEN_NR = 4;
    public static final String FILM_AUFZEICHNEN = "";
    public static final String FILM_AUFZEICHNEN_ = "w";
    public static final int FILM_AUFZEICHNEN_NR = 5;
    public static final String FILM_DATUM = "Datum";
    public static final String FILM_DATUM_ = "e";
    public static final int FILM_DATUM_NR = 6;
    public static final String FILM_ZEIT = "Zeit";
    public static final String FILM_ZEIT_ = "f";
    public static final int FILM_ZEIT_NR = 7;
    public static final String FILM_DAUER = "Dauer";
    public static final String FILM_DAUER_ = "m";
    public static final int FILM_DAUER_NR = 8;
    public static final String FILM_GROESSE = "Gr\u00f6\u00dfe [MB]";
    public static final String FILM_GROESSE_ = "t";
    public static final int FILM_GROESSE_NR = 9;
    public static final String FILM_BESCHREIBUNG = "Beschreibung";
    public static final String FILM_BESCHREIBUNG_ = "n";
    public static final int FILM_BESCHREIBUNG_NR = 10;
    public static final String FILM_GEO = "Geo";
    public static final String FILM_GEO_ = "bb";
    public static final int FILM_GEO_NR = 11;
    public static final String FILM_URL = "Url";
    public static final String FILM_URL_ = "g";
    public static final int FILM_URL_NR = 12;
    public static final String FILM_WEBSEITE = "Website";
    public static final String FILM_WEBSEITE_ = "k";
    public static final int FILM_WEBSEITE_NR = 13;
    public static final String FILM_ABO_NAME = "Aboname";
    public static final String FILM_ABO_NAME_ = "l";
    public static final int FILM_ABO_NAME_NR = 14;
    public static final String FILM_URL_SUBTITLE = "Untertitel";
    public static final String FILM_URL_SUBTITLE_ = "cc";
    public static final int FILM_URL_SUBTITLE_NR = 15;
    public static final String FILM_URL_RTMP = "UrlRTMP";
    public static final String FILM_URL_RTMP_ = "i";
    public static final int FILM_URL_RTMP_NR = 16;
    public static final String FILM_URL_AUTH = "UrlAuth";
    public static final String FILM_URL_AUTH_ = "j";
    public static final int FILM_URL_AUTH_NR = 17;
    public static final String FILM_URL_KLEIN = "Url_Klein";
    public static final String FILM_URL_KLEIN_ = "r";
    public static final int FILM_URL_KLEIN_NR = 18;
    public static final String FILM_URL_RTMP_KLEIN = "UrlRTMP_Klein";
    public static final String FILM_URL_RTMP_KLEIN_ = "s";
    public static final int FILM_URL_RTMP_KLEIN_NR = 19;
    public static final String FILM_URL_HD = "Url_HD";
    public static final String FILM_URL_HD_ = "t";
    public static final int FILM_URL_HD_NR = 20;
    public static final String FILM_URL_RTMP_HD = "UrlRTMP_HD";
    public static final String FILM_URL_RTMP_HD_ = "u";
    public static final int FILM_URL_RTMP_HD_NR = 21;
    public static final String FILM_URL_HISTORY = "Url_History";
    public static final String FILM_URL_HISTORY_ = "aa";
    public static final int FILM_URL_HISTORY_NR = 22;
    public static final String FILM_NEU = "neu";
    public static final String FILM_NEU_ = "o";
    public static final int FILM_NEU_NR = 23;
    public static final String FILM_DATUM_LONG = "DatumL";
    public static final String FILM_DATUM_LONG_ = "y";
    public static final int FILM_DATUM_LONG_NR = 24;
    public static final String FILM_REF = "Ref";
    public static final String FILM_REF_ = "z";
    public static final int FILM_REF_NR = 25;
    public static final int MAX_ELEM = 26;
    public String[] arr = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    public static final String[] COLUMN_NAMES = new String[]{"Nr", "Sender", "Thema", "Titel", "", "", "Datum", "Zeit", "Dauer", "Gr\u00f6\u00dfe [MB]", "Beschreibung", "Geo", "Url", "Website", "Aboname", "Untertitel", "UrlRTMP", "UrlAuth", "Url_Klein", "UrlRTMP_Klein", "Url_HD", "UrlRTMP_HD", "Url_History", "neu", "DatumL", "Ref"};
    public static final String[] COLUMN_NAMES_XML = new String[]{"a", "b", "c", "d", "v", "w", "e", "f", "m", "t", "n", "bb", "g", "k", "l", "cc", "i", "j", "r", "s", "t", "u", "aa", "o", "y", "z"};
    public static final int[] COLUMN_NAMES_JSON = new int[]{1, 2, 3, 6, 7, 8, 9, 10, 12, 13, 15, 16, 18, 19, 20, 21, 24, 22, 11, 23};
    public DatumFilm datumFilm = new DatumFilm(0L);
    public long dauerL = 0L;
    public Object abo = null;
    public MSLong dateigroesseL = new MSLong(0L);
    public static boolean[] spaltenAnzeigen = new boolean[26];
    public int nr;
    public boolean neuerFilm = false;
    private static final String[] GERMAN_ONLY = new String[]{"+++ Aus rechtlichen Gr\u00fcnden ist der Film nur innerhalb von Deutschland abrufbar. +++", "+++ Aus rechtlichen Gr\u00fcnden ist diese Sendung nur innerhalb von Deutschland abrufbar. +++", "+++ Aus rechtlichen Gr\u00fcnden ist dieses Video nur innerhalb von Deutschland abrufbar. +++", "+++ Aus rechtlichen Gr\u00fcnden ist dieses Video nur innerhalb von Deutschland verf\u00fcgbar. +++", "+++ Aus rechtlichen Gr\u00fcnden kann das Video nur innerhalb von Deutschland abgerufen werden. +++ Due to legal reasons the video is only available in Germany.+++", "+++ Aus rechtlichen Gr\u00fcnden kann das Video nur innerhalb von Deutschland abgerufen werden. +++", "+++ Due to legal reasons the video is only available in Germany.+++", "+++ Aus rechtlichen Gr\u00fcnden kann das Video nur in Deutschland abgerufen werden. +++"};

    public DatenFilm() {
    }

    public DatenFilm(String ssender, String tthema, String filmWebsite, String ttitel, String uurl, String uurlRtmp, String datum, String zeit, long dauerSekunden, String description) {
        this.arr[1] = ssender;
        this.arr[2] = tthema.isEmpty() ? ssender : tthema.trim();
        this.arr[3] = ttitel.isEmpty() ? tthema : ttitel.trim();
        this.arr[12] = uurl;
        this.arr[16] = uurlRtmp;
        this.arr[13] = filmWebsite;
        this.checkDatum(datum, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.checkZeit(this.arr[6], zeit, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[10] = DatenFilm.cleanDescription(description, tthema, ttitel);
        if (dauerSekunden <= 0L || dauerSekunden > 18000L) {
            this.arr[8] = "";
        } else {
            String hours = String.valueOf(dauerSekunden / 3600L);
            String min = String.valueOf((dauerSekunden %= 3600L) / 60L);
            String seconds = String.valueOf(dauerSekunden % 60L);
            this.arr[8] = this.fuellen(2, hours) + ":" + this.fuellen(2, min) + ":" + this.fuellen(2, seconds);
        }
    }

    public static DatenFilm getDatenFilmLiveStream(String ssender, String addTitle, String urlStream, String urlWebsite) {
        return new DatenFilm(ssender, "Livestream", urlWebsite, ssender + addTitle + " " + "Livestream", urlStream, "", "", "", 0L, "");
    }

    public void addUrlKlein(String url, String urlRtmp) {
        this.arr[18] = url.isEmpty() ? "" : this.getKlein(this.arr[12], url);
        this.arr[19] = urlRtmp.isEmpty() ? "" : this.getKlein(this.arr[16], urlRtmp);
    }

    public void addUrlHd(String url, String urlRtmp) {
        this.arr[20] = url.isEmpty() ? "" : this.getKlein(this.arr[12], url);
        this.arr[21] = urlRtmp.isEmpty() ? "" : this.getKlein(this.arr[16], urlRtmp);
    }

    public void addUrlSubtitle(String url) {
        this.arr[15] = url;
    }

    public String getUrlFuerAufloesung(String aufloesung) {
        if (aufloesung.equals(AUFLOESUNG_KLEIN)) {
            return this.getUrlNormalKlein();
        }
        if (aufloesung.equals(AUFLOESUNG_HD)) {
            return this.getUrlNormalHd();
        }
        return this.arr[12];
    }

    public String getUrlRtmpFuerAufloesung(String aufloesung) {
        if (aufloesung.equals(AUFLOESUNG_KLEIN)) {
            return this.getUrlFlvstreamerKlein();
        }
        if (aufloesung.equals(AUFLOESUNG_HD)) {
            return this.getUrlFlvstreamerHd();
        }
        return this.getUrlFlvstreamer();
    }

    public String getDateigroesse(String url) {
        if (url.equals(this.arr[12])) {
            return this.arr[9];
        }
        return MSFileSize.laengeString(url);
    }

    public void setUrlHistory() {
        String u = DatenFilm.getUrl(this);
        this.arr[22] = u.equals(this.arr[12]) ? "" : u;
    }

    public void setGeo() {
        switch (this.arr[1]) {
            case "ARD": 
            case "SWR": 
            case "MDR": 
            case "BR": {
                if (!this.arr[12].startsWith("http://mvideos-geo.daserste.de/") && !this.arr[12].startsWith("http://media.ndr.de/progressive_geo/") && !this.arr[12].startsWith("http://cdn-storage.br.de/geo/") && !this.arr[12].startsWith("http://cdn-sotschi.br.de/geo/b7/") && !this.arr[12].startsWith("http://pd-ondemand.swr.de/geo/de/") && !this.arr[12].startsWith("http://ondemandgeo.mdr.de/") && !this.arr[12].startsWith("http://ondemand-de.wdr.de/")) break;
                this.arr[11] = GEO_DE;
                break;
            }
            case "ZDF": 
            case "ZDF-tivi": 
            case "3Sat": {
                if (this.arr[12].startsWith("http://nrodl.zdf.de/de/") || this.arr[12].startsWith("http://rodl.zdf.de/de/")) {
                    this.arr[11] = GEO_DE;
                    break;
                }
                if (this.arr[12].startsWith("http://nrodl.zdf.de/dach/") || this.arr[12].startsWith("http://rodl.zdf.de/dach/")) {
                    this.arr[11] = "DE-AT-CH";
                    break;
                }
                if (!this.arr[12].startsWith("http://nrodl.zdf.de/ebu/") && !this.arr[12].startsWith("http://rodl.zdf.de/ebu/")) break;
                this.arr[11] = "DE-AT-CH-EU";
                break;
            }
            case "ORF": {
                if (!this.arr[12].startsWith("http://apasfpd.apa.at/cms-austria/") && !this.arr[12].startsWith("rtmp://apasfw.apa.at/cms-austria/")) break;
                this.arr[11] = GEO_AT;
                break;
            }
            case "SRF.Podcast": {
                if (!this.arr[12].startsWith("http://podcasts.srf.ch/ch/audio/")) break;
                this.arr[11] = GEO_CH;
                break;
            }
            case "NDR": {
                if (!this.arr[12].startsWith("http://media.ndr.de/progressive_geo")) break;
                this.arr[11] = GEO_DE;
                break;
            }
            case "KiKA": {
                if (!this.arr[12].startsWith("http://pmdgeo.kika.de/")) break;
                this.arr[11] = GEO_DE;
            }
        }
    }

    public String getUrlHistory() {
        if (this.arr[22].isEmpty()) {
            return this.arr[12];
        }
        return this.arr[22];
    }

    public String getIndex() {
        return this.arr[1].toLowerCase() + this.arr[2].toLowerCase() + DatenFilm.getUrl(this);
    }

    public static String getUrl(DatenFilm film) {
        return DatenFilm.getUrl(film.arr[1], film.arr[12]);
    }

    private static String getUrl(String ssender, String uurl) {
        String url = "";
        if (ssender.equals("ORF")) {
            try {
                url = uurl.substring(uurl.indexOf("/online/") + "/online/".length());
                if (!url.contains("/")) {
                    MSLog.fehlerMeldung(915230478, "Url: " + uurl);
                    return "";
                }
                if (!(url = url.substring(url.indexOf("/") + 1)).contains("/")) {
                    MSLog.fehlerMeldung(915230478, "Url: " + uurl);
                    return "";
                }
                if ((url = url.substring(url.indexOf("/") + 1)).isEmpty()) {
                    MSLog.fehlerMeldung(915230478, "Url: " + uurl);
                    return "";
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(915230478, ex, "Url: " + uurl);
            }
            return "ORF----" + url;
        }
        return uurl;
    }

    public DatenFilm getCopy() {
        DatenFilm ret = new DatenFilm();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        ret.datumFilm = this.datumFilm;
        ret.nr = this.nr;
        ret.dateigroesseL = this.dateigroesseL;
        ret.dauerL = this.dauerL;
        ret.abo = this.abo;
        return ret;
    }

    @Override
    public int compareTo(DatenFilm arg0) {
        int ret = sorter.compare(this.arr[1], arg0.arr[1]);
        if (ret == 0) {
            return sorter.compare(this.arr[2], arg0.arr[2]);
        }
        return ret;
    }

    public void clean() {
        this.arr[0] = "";
        this.arr[14] = "";
    }

    public void init() {
        block15: {
            try {
                if (this.arr[9].length() < 3) {
                    this.arr[9] = this.arr[9].intern();
                }
                if (this.arr[18].length() < 15) {
                    this.arr[18] = this.arr[18].intern();
                }
                this.arr[6] = this.arr[6].intern();
                this.arr[7] = this.arr[7].intern();
                this.dateigroesseL = new MSLong(this);
                try {
                    if (!this.arr[8].contains(":") && !this.arr[8].isEmpty()) {
                        long l;
                        this.dauerL = l = Long.parseLong(this.arr[8]);
                        if (l > 0L) {
                            long hours = l / 3600L;
                            long min = (l -= hours * 3600L) / 60L;
                            long seconds = l -= min * 60L;
                            this.arr[8] = this.fuellen(2, String.valueOf(hours)) + ":" + this.fuellen(2, String.valueOf(min)) + ":" + this.fuellen(2, String.valueOf(seconds));
                        } else {
                            this.arr[8] = "";
                        }
                    } else {
                        this.dauerL = 0L;
                        if (!this.arr[8].equals("")) {
                            String[] parts = this.arr[8].split(":");
                            long power = 1L;
                            for (int i = parts.length - 1; i >= 0; --i) {
                                this.dauerL += Long.parseLong(parts[i]) * power;
                                power *= 60L;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    this.dauerL = 0L;
                    MSLog.fehlerMeldung(468912049, "Dauer: " + this.arr[8]);
                }
                if (this.arr[6].isEmpty()) break block15;
                try {
                    if (this.arr[24].isEmpty()) {
                        this.datumFilm = this.arr[7].isEmpty() ? new DatumFilm(sdf_datum.parse(this.arr[6]).getTime()) : new DatumFilm(sdf_datum_zeit.parse(this.arr[6] + this.arr[7]).getTime());
                        this.arr[24] = String.valueOf(this.datumFilm.getTime() / 1000L);
                        break block15;
                    }
                    long l = Long.parseLong(this.arr[24]);
                    this.datumFilm = new DatumFilm(l * 1000L);
                }
                catch (Exception ex) {
                    MSLog.fehlerMeldung(915236701, ex, new String[]{"Datum: " + this.arr[6], "Zeit: " + this.arr[7]});
                    this.datumFilm = new DatumFilm(0L);
                    this.arr[6] = "";
                    this.arr[7] = "";
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(715263987, ex);
            }
        }
    }

    private String getKlein(String url1, String url2) {
        String ret = "";
        boolean diff = false;
        for (int i = 0; i < url2.length(); ++i) {
            if (url1.length() > i) {
                if (url1.charAt(i) != url2.charAt(i)) {
                    if (!diff) {
                        ret = i + "|";
                    }
                    diff = true;
                }
            } else {
                diff = true;
            }
            if (!diff) continue;
            ret = ret + url2.charAt(i);
        }
        return ret;
    }

    private String getUrlNormalKlein() {
        if (!this.arr[18].isEmpty()) {
            try {
                int i = Integer.parseInt(this.arr[18].substring(0, this.arr[18].indexOf("|")));
                return this.arr[12].substring(0, i) + this.arr[18].substring(this.arr[18].indexOf("|") + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.arr[12];
    }

    private String getUrlNormalHd() {
        if (!this.arr[20].isEmpty()) {
            try {
                int i = Integer.parseInt(this.arr[20].substring(0, this.arr[20].indexOf("|")));
                return this.arr[12].substring(0, i) + this.arr[20].substring(this.arr[20].indexOf("|") + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.arr[12];
    }

    private String getUrlFlvstreamer() {
        String ret = !this.arr[16].isEmpty() ? this.arr[16] : (this.arr[12].startsWith("rtmp") ? "-r " + this.arr[12] : this.arr[12]);
        return ret;
    }

    private String getUrlFlvstreamerKlein() {
        String ret;
        if (!this.arr[19].isEmpty()) {
            try {
                int i = Integer.parseInt(this.arr[19].substring(0, this.arr[19].indexOf("|")));
                return this.arr[16].substring(0, i) + this.arr[19].substring(this.arr[19].indexOf("|") + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.arr[16].equals("")) {
            ret = this.arr[16];
        } else {
            ret = this.getUrlNormalKlein();
            if (ret.startsWith("rtmp")) {
                ret = "-r " + ret;
            }
        }
        return ret;
    }

    private String getUrlFlvstreamerHd() {
        if (!this.arr[21].isEmpty()) {
            try {
                int i = Integer.parseInt(this.arr[21].substring(0, this.arr[21].indexOf("|")));
                return this.arr[16].substring(0, i) + this.arr[21].substring(this.arr[21].indexOf("|") + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getUrlFlvstreamer();
    }

    public static String cleanDescription(String s, String thema, String titel) {
        s = MSFunktionen.removeHtml(s);
        for (String g : GERMAN_ONLY) {
            if (!s.contains(g)) continue;
            s = s.replace(g, "");
        }
        if (s.startsWith(titel)) {
            s = s.substring(titel.length()).trim();
        }
        if (s.startsWith(thema)) {
            s = s.substring(thema.length()).trim();
        }
        if (s.startsWith("|")) {
            s = s.substring(1).trim();
        }
        if (s.startsWith("Video-Clip")) {
            s = s.substring("Video-Clip".length()).trim();
        }
        if (s.startsWith(titel)) {
            s = s.substring(titel.length()).trim();
        }
        if (s.startsWith(":")) {
            s = s.substring(1).trim();
        }
        if (s.startsWith(",")) {
            s = s.substring(1).trim();
        }
        if (s.startsWith("\n")) {
            s = s.substring(1).trim();
        }
        if (s.contains("\\\"")) {
            s = s.replace("\\\"", "\"");
        }
        if (s.length() > 300) {
            return s.substring(0, 300) + "\n.....";
        }
        return s;
    }

    private void checkDatum(String datum, String fehlermeldung) {
        long MAX = 8640000000L;
        if ((datum = datum.trim()).contains(".") && datum.length() == 10) {
            try {
                SimpleDateFormat sdfIn = new SimpleDateFormat("dd.MM.yyyy");
                Date filmDate = sdfIn.parse(datum);
                if (filmDate.getTime() < 0L) {
                    MSLog.fehlerMeldung(923012125, "Unsinniger Wert: [" + datum + "] " + fehlermeldung);
                } else if (new Date().getTime() + 8640000000L < filmDate.getTime()) {
                    MSLog.fehlerMeldung(121305469, "Unsinniger Wert: [" + datum + "] " + fehlermeldung);
                } else {
                    this.arr[6] = datum;
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(794630593, ex);
                MSLog.fehlerMeldung(946301596, "[" + datum + "] " + fehlermeldung);
            }
        }
    }

    private void checkZeit(String datum, String zeit, String fehlermeldung) {
        zeit = zeit.trim();
        if (!datum.isEmpty() && !zeit.isEmpty()) {
            if (zeit.contains(":") && zeit.length() == 8) {
                this.arr[7] = zeit;
            } else {
                MSLog.fehlerMeldung(159623647, "[" + zeit + "] " + fehlermeldung);
            }
        }
    }

    private String fuellen(int anz, String s) {
        while (s.length() < anz) {
            s = "0" + s;
        }
        return s;
    }
}

