/*
 * PdfFile.java
 *
 * Classes:
 *   public   PdfFile
 *   
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Java jcmdline (command line management) package.
 *
 * The Initial Developer of the Original Code is Lynne Lawrence.
 * 
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):  Andrea Vacondio <andrea.vacondio@gmail.com>
 *
 * ***** END LICENSE BLOCK *****
 */

package jcmdline.dto;

import java.io.File;
import java.io.Serializable;

public class PdfFile implements Serializable{

	private static final long serialVersionUID = 7010970222698392953L;

	private File file;
	private String password;
	
	public PdfFile(){		
	}
	
	
	/**
	 * @param file
	 * @param password
	 */
	public PdfFile(File file, String password) {
		this.file = file;
		this.password = password;
	}

	/**
	 * @param filePath
	 * @param password
	 */
	public PdfFile(String filePath, String password) {
		this.file = new File(filePath);
		this.password = password;
	}
	
	/**
	 * @return the file
	 */
	public File getFile() {
		return file;
	}
	/**
	 * @param file the file to set
	 */
	public void setFile(File file) {
		this.file = file;
	}
	/**
	 * @return the password
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * @return the password in bytes or null
	 */
	public byte[] getPasswordBytes() {
		return (password!=null)? password.getBytes():null;
	}
	/**
	 * @param password the password to set
	 */
	public void setPassword(String password) {
		this.password = password;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((file == null) ? 0 : file.hashCode());
		result = prime * result
				+ ((password == null) ? 0 : password.hashCode());
		return result;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final PdfFile other = (PdfFile) obj;
		if (file == null) {
			if (other.file != null)
				return false;
		} else if (!file.equals(other.file))
			return false;
		if (password == null) {
			if (other.password != null)
				return false;
		} else if (!password.equals(other.password))
			return false;
		return true;
	}
	

	public String toString(){
		StringBuffer retVal = new StringBuffer();
		retVal.append(super.toString());
		retVal.append((file== null)?"":"[file="+file.getAbsolutePath()+"]");
		retVal.append("[password="+password+"]");
		return retVal.toString();
	}
	
}
