/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.PlanController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private TextureChoiceController floorTextureController;
    private TextureChoiceController ceilingTextureController;
    private TextureChoiceController wallSidesTextureController;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView roomView;
    private String name;
    private Boolean areaVisible;
    private Boolean floorVisible;
    private Integer floorColor;
    private RoomPaint floorPaint;
    private Float floorShininess;
    private Boolean ceilingVisible;
    private Integer ceilingColor;
    private RoomPaint ceilingPaint;
    private Float ceilingShininess;
    private boolean wallSidesEditable;
    private boolean splitSurroundingWalls;
    private boolean splitSurroundingWallsNeeded;
    private Integer wallSidesColor;
    private RoomPaint wallSidesPaint;
    private Float wallSidesShininess;

    public RoomController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public TextureChoiceController getFloorTextureController() {
        if (this.floorTextureController == null) {
            this.floorTextureController = new TextureChoiceController(this.preferences.getLocalizedString(RoomController.class, "floorTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.floorTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomController.this.setFloorPaint(RoomPaint.TEXTURED);
                }
            });
        }
        return this.floorTextureController;
    }

    public TextureChoiceController getCeilingTextureController() {
        if (this.ceilingTextureController == null) {
            this.ceilingTextureController = new TextureChoiceController(this.preferences.getLocalizedString(RoomController.class, "ceilingTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.ceilingTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomController.this.setCeilingPaint(RoomPaint.TEXTURED);
                }
            });
        }
        return this.ceilingTextureController;
    }

    public TextureChoiceController getWallSidesTextureController() {
        if (this.wallSidesTextureController == null) {
            this.wallSidesTextureController = new TextureChoiceController(this.preferences.getLocalizedString(RoomController.class, "wallSidesTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.wallSidesTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomController.this.setWallSidesPaint(RoomPaint.TEXTURED);
                }
            });
        }
        return this.wallSidesTextureController;
    }

    @Override
    public DialogView getView() {
        if (this.roomView == null) {
            this.roomView = this.viewFactory.createRoomView(this.preferences, this);
        }
        return this.roomView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public boolean isPropertyEditable(Property property) {
        switch (property) {
            case SPLIT_SURROUNDING_WALLS: 
            case WALL_SIDES_COLOR: 
            case WALL_SIDES_PAINT: 
            case WALL_SIDES_SHININESS: {
                return this.wallSidesEditable;
            }
        }
        return true;
    }

    protected void updateProperties() {
        Object object;
        Object object2;
        Object object3;
        Comparable<Boolean> comparable;
        Object object4;
        Object object5;
        List<Room> list = Home.getRoomsSubList(this.home.getSelectedItems());
        if (list.isEmpty()) {
            this.setAreaVisible(null);
            this.setFloorColor(null);
            this.getFloorTextureController().setTexture(null);
            this.setFloorPaint(null);
            this.setFloorShininess(null);
            this.setCeilingColor(null);
            this.getCeilingTextureController().setTexture(null);
            this.setCeilingPaint(null);
            this.setCeilingShininess(null);
        } else {
            object5 = list.get(0);
            object4 = ((Room)object5).getName();
            if (object4 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (((String)object4).equals(list.get(i).getName())) continue;
                    object4 = null;
                    break;
                }
            }
            this.setName((String)object4);
            comparable = ((Room)object5).isAreaVisible();
            for (int i = 1; i < list.size(); ++i) {
                if (((Boolean)comparable).booleanValue() == list.get(i).isAreaVisible()) continue;
                comparable = null;
                break;
            }
            this.setAreaVisible((Boolean)comparable);
            Boolean bl = ((Room)object5).isFloorVisible();
            for (int i = 1; i < list.size(); ++i) {
                if (bl.booleanValue() == list.get(i).isFloorVisible()) continue;
                bl = null;
                break;
            }
            this.setFloorVisible(bl);
            object3 = ((Room)object5).getFloorColor();
            if (object3 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (((Integer)object3).equals(list.get(i).getFloorColor())) continue;
                    object3 = null;
                    break;
                }
            }
            this.setFloorColor((Integer)object3);
            object2 = ((Room)object5).getFloorTexture();
            if (object2 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (((HomeTexture)object2).equals(list.get(i).getFloorTexture())) continue;
                    object2 = null;
                    break;
                }
            }
            this.getFloorTextureController().setTexture((HomeTexture)object2);
            if (object3 != null) {
                this.setFloorPaint(RoomPaint.COLORED);
            } else if (object2 != null) {
                this.setFloorPaint(RoomPaint.TEXTURED);
            } else {
                this.setFloorPaint(null);
            }
            object = Float.valueOf(((Room)object5).getFloorShininess());
            for (int i = 1; i < list.size(); ++i) {
                if (((Float)object).equals(Float.valueOf(list.get(i).getFloorShininess()))) continue;
                object = null;
                break;
            }
            this.setFloorShininess((Float)object);
            Boolean bl2 = ((Room)object5).isCeilingVisible();
            for (int i = 1; i < list.size(); ++i) {
                if (bl2.booleanValue() == list.get(i).isCeilingVisible()) continue;
                bl2 = null;
                break;
            }
            this.setCeilingVisible(bl2);
            Integer n = ((Room)object5).getCeilingColor();
            if (n != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (n.equals(list.get(i).getCeilingColor())) continue;
                    n = null;
                    break;
                }
            }
            this.setCeilingColor(n);
            HomeTexture homeTexture = ((Room)object5).getCeilingTexture();
            if (homeTexture != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (homeTexture.equals(list.get(i).getCeilingTexture())) continue;
                    homeTexture = null;
                    break;
                }
            }
            this.getCeilingTextureController().setTexture(homeTexture);
            if (n != null) {
                this.setCeilingPaint(RoomPaint.COLORED);
            } else if (homeTexture != null) {
                this.setCeilingPaint(RoomPaint.TEXTURED);
            } else {
                this.setCeilingPaint(null);
            }
            Float f = Float.valueOf(((Room)object5).getCeilingShininess());
            for (int i = 1; i < list.size(); ++i) {
                if (f.equals(Float.valueOf(list.get(i).getCeilingShininess()))) continue;
                f = null;
                break;
            }
            this.setCeilingShininess(f);
        }
        object5 = this.getRoomsWallSides(list, null);
        if (object5.isEmpty()) {
            this.splitSurroundingWalls = false;
            this.splitSurroundingWallsNeeded = false;
            this.wallSidesEditable = false;
            this.setWallSidesColor(null);
            this.setWallSidesPaint(null);
            this.setWallSidesShininess(null);
        } else {
            HomeTexture homeTexture;
            this.wallSidesEditable = true;
            this.splitSurroundingWallsNeeded = this.splitWalls((List<WallSide>)object5, null, null, null);
            this.splitSurroundingWalls = false;
            object4 = (WallSide)object5.get(0);
            Constable constable = comparable = ((WallSide)object4).getSide() == 0 ? ((WallSide)object4).getWall().getLeftSideColor() : ((WallSide)object4).getWall().getRightSideColor();
            if (comparable != null) {
                for (int i = 1; i < object5.size(); ++i) {
                    object3 = (WallSide)object5.get(i);
                    if (((Integer)comparable).equals(((WallSide)object3).getSide() == 0 ? ((WallSide)object3).getWall().getLeftSideColor() : ((WallSide)object3).getWall().getRightSideColor())) continue;
                    comparable = null;
                    break;
                }
            }
            this.setWallSidesColor((Integer)comparable);
            HomeTexture homeTexture2 = homeTexture = ((WallSide)object4).getSide() == 0 ? ((WallSide)object4).getWall().getLeftSideTexture() : ((WallSide)object4).getWall().getRightSideTexture();
            if (homeTexture != null) {
                for (int i = 1; i < object5.size(); ++i) {
                    object2 = (WallSide)object5.get(i);
                    if (homeTexture.equals(((WallSide)object2).getSide() == 0 ? ((WallSide)object2).getWall().getLeftSideTexture() : ((WallSide)object2).getWall().getRightSideTexture())) continue;
                    homeTexture = null;
                    break;
                }
            }
            this.getWallSidesTextureController().setTexture(homeTexture);
            Float f = Float.valueOf(((WallSide)object4).getSide() == 0 ? ((WallSide)object4).getWall().getLeftSideShininess() : ((WallSide)object4).getWall().getRightSideShininess());
            if (f != null) {
                for (int i = 1; i < object5.size(); ++i) {
                    object = (WallSide)object5.get(i);
                    if (f.equals(Float.valueOf(((WallSide)object).getSide() == 0 ? ((WallSide)object).getWall().getLeftSideShininess() : ((WallSide)object).getWall().getRightSideShininess()))) continue;
                    f = null;
                    break;
                }
            }
            this.setWallSidesShininess(f);
        }
    }

    private List<WallSide> getRoomsWallSides(List<Room> list, List<WallSide> list2) {
        ArrayList<WallSide> arrayList = new ArrayList<WallSide>();
        for (Room room : list) {
            float[][] fArray = room.getPoints();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(fArray[0][0], fArray[0][1]);
            for (int i = 1; i < fArray.length; ++i) {
                generalPath.lineTo(fArray[i][0], fArray[i][1]);
            }
            generalPath.closePath();
            Area area = new Area(generalPath);
            if (list2 != null) {
                for (WallSide wallSide : list2) {
                    if (!this.isRoomItersectingWallSide(wallSide.getWall().getPoints(), wallSide.getSide(), area)) continue;
                    arrayList.add(wallSide);
                }
                continue;
            }
            for (Wall wall : this.home.getWalls()) {
                if (!wall.isAtLevel(this.home.getSelectedLevel())) continue;
                float[][] fArray2 = wall.getPoints();
                if (this.isRoomItersectingWallSide(fArray2, 0, area)) {
                    arrayList.add(new WallSide(wall, 0));
                }
                if (!this.isRoomItersectingWallSide(fArray2, 1, area)) continue;
                arrayList.add(new WallSide(wall, 1));
            }
        }
        return arrayList;
    }

    private boolean isRoomItersectingWallSide(float[][] fArray, int n, Area area) {
        float f;
        BasicStroke basicStroke = new BasicStroke(2.0f);
        Shape shape = this.getWallSideShape(fArray, n);
        Area area2 = new Area(basicStroke.createStrokedShape(shape));
        float f2 = this.getSurface(area2);
        area2.intersect(area);
        return !area2.isEmpty() && (f = this.getSurface(area2)) > f2 * 0.02f;
    }

    private Shape getWallSideShape(float[][] fArray, int n) {
        if (fArray.length == 4) {
            if (n == 0) {
                return new Line2D.Float(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
            }
            return new Line2D.Float(fArray[2][0], fArray[2][1], fArray[3][0], fArray[3][1]);
        }
        float[][] fArrayArray = new float[fArray.length / 2][];
        System.arraycopy(fArray, n == 0 ? 0 : fArrayArray.length, fArrayArray, 0, fArrayArray.length);
        return this.getPath(fArrayArray, false);
    }

    private GeneralPath getPath(float[][] fArray, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        for (int i = 1; i < fArray.length; ++i) {
            generalPath.lineTo(fArray[i][0], fArray[i][1]);
        }
        if (bl) {
            generalPath.closePath();
        }
        return generalPath;
    }

    private float getSurface(Area area) {
        float f = 0.0f;
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        PathIterator pathIterator = area.getPathIterator(null);
        while (!pathIterator.isDone()) {
            float[] fArray = new float[2];
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    arrayList.add(fArray);
                    break;
                }
                case 1: {
                    arrayList.add(fArray);
                    break;
                }
                case 4: {
                    float[][] fArray2 = (float[][])arrayList.toArray((T[])new float[arrayList.size()][]);
                    f += Math.abs(this.getSignedSurface(fArray2));
                    arrayList.clear();
                }
            }
            pathIterator.next();
        }
        return f;
    }

    private float getSignedSurface(float[][] fArray) {
        float f = 0.0f;
        for (int i = 1; i < fArray.length; ++i) {
            f += fArray[i][0] * fArray[i - 1][1];
            f -= fArray[i][1] * fArray[i - 1][0];
        }
        f += fArray[0][0] * fArray[fArray.length - 1][1];
        return (f -= fArray[0][1] * fArray[fArray.length - 1][0]) / 2.0f;
    }

    public void setName(String string) {
        if (string != this.name) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setAreaVisible(Boolean bl) {
        if (bl != this.areaVisible) {
            Boolean bl2 = this.areaVisible;
            this.areaVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.AREA_VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getAreaVisible() {
        return this.areaVisible;
    }

    public void setFloorVisible(Boolean bl) {
        if (bl != this.floorVisible) {
            Boolean bl2 = this.floorVisible;
            this.floorVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getFloorVisible() {
        return this.floorVisible;
    }

    public void setFloorColor(Integer n) {
        if (n != this.floorColor) {
            Integer n2 = this.floorColor;
            this.floorColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_COLOR.name(), n2, n);
            this.setFloorPaint(RoomPaint.COLORED);
        }
    }

    public Integer getFloorColor() {
        return this.floorColor;
    }

    public void setFloorPaint(RoomPaint roomPaint) {
        if (roomPaint != this.floorPaint) {
            RoomPaint roomPaint2 = this.floorPaint;
            this.floorPaint = roomPaint;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_PAINT.name(), (Object)roomPaint2, (Object)roomPaint);
        }
    }

    public RoomPaint getFloorPaint() {
        return this.floorPaint;
    }

    public void setFloorShininess(Float f) {
        if (f != this.floorShininess) {
            Float f2 = this.floorShininess;
            this.floorShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_SHININESS.name(), f2, f);
        }
    }

    public Float getFloorShininess() {
        return this.floorShininess;
    }

    public void setCeilingVisible(Boolean bl) {
        if (bl != this.ceilingVisible) {
            Boolean bl2 = this.ceilingVisible;
            this.ceilingVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getCeilingVisible() {
        return this.ceilingVisible;
    }

    public void setCeilingColor(Integer n) {
        if (n != this.ceilingColor) {
            Integer n2 = this.ceilingColor;
            this.ceilingColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_COLOR.name(), n2, n);
            this.setCeilingPaint(RoomPaint.COLORED);
        }
    }

    public Integer getCeilingColor() {
        return this.ceilingColor;
    }

    public void setCeilingPaint(RoomPaint roomPaint) {
        if (roomPaint != this.ceilingPaint) {
            RoomPaint roomPaint2 = this.ceilingPaint;
            this.ceilingPaint = roomPaint;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_PAINT.name(), (Object)roomPaint2, (Object)roomPaint);
        }
    }

    public RoomPaint getCeilingPaint() {
        return this.ceilingPaint;
    }

    public void setCeilingShininess(Float f) {
        if (f != this.ceilingShininess) {
            Float f2 = this.ceilingShininess;
            this.ceilingShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_SHININESS.name(), f2, f);
        }
    }

    public Float getCeilingShininess() {
        return this.ceilingShininess;
    }

    public boolean isSplitSurroundingWalls() {
        return this.splitSurroundingWalls;
    }

    public void setSplitSurroundingWalls(boolean bl) {
        if (bl != this.splitSurroundingWalls) {
            this.splitSurroundingWalls = bl;
            this.propertyChangeSupport.firePropertyChange(Property.SPLIT_SURROUNDING_WALLS.name(), !bl, bl);
        }
    }

    public boolean isSplitSurroundingWallsNeeded() {
        return this.splitSurroundingWallsNeeded;
    }

    public void setWallSidesColor(Integer n) {
        if (n != this.wallSidesColor) {
            Integer n2 = this.wallSidesColor;
            this.wallSidesColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.WALL_SIDES_COLOR.name(), n2, n);
            this.setWallSidesPaint(RoomPaint.COLORED);
        }
    }

    public Integer getWallSidesColor() {
        return this.wallSidesColor;
    }

    public void setWallSidesPaint(RoomPaint roomPaint) {
        if (roomPaint != this.wallSidesPaint) {
            RoomPaint roomPaint2 = this.wallSidesPaint;
            this.wallSidesPaint = roomPaint;
            this.propertyChangeSupport.firePropertyChange(Property.WALL_SIDES_PAINT.name(), (Object)roomPaint2, (Object)roomPaint);
        }
    }

    public RoomPaint getWallSidesPaint() {
        return this.wallSidesPaint;
    }

    public void setWallSidesShininess(Float f) {
        if (f != this.wallSidesShininess) {
            Float f2 = this.wallSidesShininess;
            this.wallSidesShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.WALL_SIDES_SHININESS.name(), f2, f);
        }
    }

    public Float getWallSidesShininess() {
        return this.wallSidesShininess;
    }

    public void modifyRooms() {
        List<Selectable> list = this.home.getSelectedItems();
        List<Room> list2 = Home.getRoomsSubList(list);
        if (!list2.isEmpty()) {
            String string = this.getName();
            Boolean bl = this.getAreaVisible();
            Boolean bl2 = this.getFloorVisible();
            Integer n = this.getFloorPaint() == RoomPaint.COLORED ? this.getFloorColor() : null;
            HomeTexture homeTexture = this.getFloorPaint() == RoomPaint.TEXTURED ? this.getFloorTextureController().getTexture() : null;
            Float f = this.getFloorShininess();
            Boolean bl3 = this.getCeilingVisible();
            Integer n2 = this.getCeilingPaint() == RoomPaint.COLORED ? this.getCeilingColor() : null;
            HomeTexture homeTexture2 = this.getCeilingPaint() == RoomPaint.TEXTURED ? this.getCeilingTextureController().getTexture() : null;
            Float f2 = this.getCeilingShininess();
            Integer n3 = this.getWallSidesPaint() == RoomPaint.COLORED ? this.getWallSidesColor() : null;
            HomeTexture homeTexture3 = this.getWallSidesPaint() == RoomPaint.TEXTURED ? this.getWallSidesTextureController().getTexture() : null;
            Float f3 = this.getWallSidesShininess();
            List<WallSide> list3 = this.getRoomsWallSides(list2, null);
            ModifiedRoom[] modifiedRoomArray = new ModifiedRoom[list2.size()];
            for (int i = 0; i < modifiedRoomArray.length; ++i) {
                modifiedRoomArray[i] = new ModifiedRoom(list2.get(i));
            }
            ArrayList<ModifiedWall> arrayList = new ArrayList<ModifiedWall>();
            ArrayList<ModifiedWall> arrayList2 = new ArrayList<ModifiedWall>();
            ArrayList<Selectable> arrayList3 = new ArrayList<Selectable>(list);
            if (this.splitSurroundingWalls && this.splitWalls(list3, arrayList, arrayList2, arrayList3)) {
                this.home.setSelectedItems(arrayList3);
                list3 = this.getRoomsWallSides(list2, list3);
            }
            ModifiedWallSide[] modifiedWallSideArray = new ModifiedWallSide[list3.size()];
            for (int i = 0; i < modifiedWallSideArray.length; ++i) {
                modifiedWallSideArray[i] = new ModifiedWallSide(list3.get(i));
            }
            RoomController.doModifyRoomsAndWallSides(this.home, modifiedRoomArray, string, bl, bl2, n, homeTexture, f, bl3, n2, homeTexture2, f2, modifiedWallSideArray, n3, homeTexture3, f3, null, null);
            if (this.undoSupport != null) {
                RoomsAndWallSidesModificationUndoableEdit roomsAndWallSidesModificationUndoableEdit = new RoomsAndWallSidesModificationUndoableEdit(this.home, this.preferences, list, arrayList3, modifiedRoomArray, string, bl, n, homeTexture, bl2, f, n2, homeTexture2, bl3, f2, modifiedWallSideArray, n3, homeTexture3, f3, arrayList.toArray(new ModifiedWall[arrayList.size()]), arrayList2.toArray(new ModifiedWall[arrayList2.size()]));
                this.undoSupport.postEdit(roomsAndWallSidesModificationUndoableEdit);
            }
            if (string != null) {
                this.preferences.addAutoCompletionString("RoomName", string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean splitWalls(List<WallSide> list, List<ModifiedWall> list2, List<ModifiedWall> list3, List<Selectable> list4) {
        Object object;
        HashMap<Wall, ModifiedWall> hashMap = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        do {
            void object6;
            Object object2;
            Object object3;
            Object object4;
            object = null;
            Object object5 = null;
            Object var9_10 = null;
            ModifiedWall modifiedWall = null;
            Object object7 = list.iterator();
            block1: while (object7.hasNext() && object == null) {
                object4 = object7.next();
                object3 = ((WallSide)object4).getWall();
                if (((Wall)object3).getArcExtent() != null) continue;
                object2 = new Area(this.getPath(((Wall)object3).getPoints(), true));
                for (WallSide wallSide : list) {
                    Wall wall;
                    float[] fArray;
                    Wall wall2 = wallSide.getWall();
                    if (object3 == wall2) continue;
                    Area area = new Area(this.getPath(wall2.getPoints(), true));
                    area.intersect((Area)object2);
                    if (area.isEmpty() || !area.isSingular() || (fArray = this.computeIntersection(((Wall)object3).getXStart(), ((Wall)object3).getYStart(), ((Wall)object3).getXEnd(), ((Wall)object3).getYEnd(), wall2.getXStart(), wall2.getYStart(), wall2.getXEnd(), wall2.getYEnd())) == null) continue;
                    object5 = ((Wall)object3).clone();
                    Wall wall3 = ((Wall)object3).clone();
                    ((Wall)object5).setXEnd(fArray[0]);
                    ((Wall)object5).setYEnd(fArray[1]);
                    wall3.setXStart(fArray[0]);
                    wall3.setYStart(fArray[1]);
                    if (!(((Wall)object5).getLength() > wall2.getThickness() / 2.0f) || !(wall3.getLength() > wall2.getThickness() / 2.0f)) continue;
                    if (list2 == null) {
                        return true;
                    }
                    if (hashMap == null) {
                        hashMap = new HashMap<Wall, ModifiedWall>(list.size());
                        for (WallSide wallSide2 : list) {
                            if (hashMap.containsKey(wallSide2.getWall())) continue;
                            hashMap.put(wallSide2.getWall(), new ModifiedWall(wallSide2.getWall()));
                        }
                    }
                    modifiedWall = (ModifiedWall)hashMap.get(object3);
                    Wall wall4 = ((Wall)object3).getWallAtStart();
                    if (wall4 != null) {
                        ((Wall)object5).setWallAtStart(wall4);
                        if (wall4.getWallAtEnd() == object3) {
                            wall4.setWallAtEnd((Wall)object5);
                        } else {
                            wall4.setWallAtStart((Wall)object5);
                        }
                    }
                    if ((wall = ((Wall)object3).getWallAtEnd()) != null) {
                        wall3.setWallAtEnd(wall);
                        if (wall.getWallAtEnd() == object3) {
                            wall.setWallAtEnd(wall3);
                        } else {
                            wall.setWallAtStart(wall3);
                        }
                    }
                    ((Wall)object5).setWallAtEnd(wall3);
                    wall3.setWallAtStart((Wall)object5);
                    if (((Wall)object3).getHeightAtEnd() != null) {
                        Float f = Float.valueOf(((Wall)object3).getHeight().floatValue() + (((Wall)object3).getHeightAtEnd().floatValue() - ((Wall)object3).getHeight().floatValue()) * (float)Point2D.distance(((Wall)object3).getXStart(), ((Wall)object3).getYStart(), fArray[0], fArray[1]) / ((Wall)object3).getLength());
                        ((Wall)object5).setHeightAtEnd(f);
                        wall3.setHeight(f);
                    }
                    object = object4;
                    continue block1;
                }
            }
            if (object == null) continue;
            arrayList.add(object5);
            arrayList.add(object6);
            object7 = ((WallSide)object).getWall();
            if (this.home.getWalls().contains(object7)) {
                list2.add(modifiedWall);
            } else {
                object4 = arrayList.iterator();
                while (object4.hasNext()) {
                    if (object4.next() != object7) continue;
                    object4.remove();
                    break;
                }
            }
            if (list4.remove(object7)) {
                list4.add((Selectable)object5);
                list4.add((Selectable)object6);
            }
            list.remove(object);
            list.add(new WallSide((Wall)object5, ((WallSide)object).getSide()));
            list.add(new WallSide((Wall)object6, ((WallSide)object).getSide()));
            object4 = new ArrayList<WallSide>();
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (WallSide)object3.next();
                if (((WallSide)object2).getWall() != object7) continue;
                object3.remove();
                object4.add(new WallSide((Wall)object5, ((WallSide)object2).getSide()));
                object4.add(new WallSide((Wall)object6, ((WallSide)object2).getSide()));
            }
            list.addAll((Collection<WallSide>)object4);
        } while (object != null);
        if (list2 == null) {
            return false;
        }
        for (Wall wall : arrayList) {
            this.home.addWall(wall);
            list3.add(new ModifiedWall(wall));
        }
        for (ModifiedWall modifiedWall : list2) {
            this.home.deleteWall(modifiedWall.getWall());
        }
        return !list2.isEmpty();
    }

    private float[] computeIntersection(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float[] fArray = PlanController.computeIntersection(f, f2, f3, f4, f5, f6, f7, f8);
        if (Line2D.ptSegDistSq(f, f2, f3, f4, fArray[0], fArray[1]) < 1.0E-7 && ((double)Math.abs(f - fArray[0]) > 1.0E-4 || (double)Math.abs(f2 - fArray[1]) > 1.0E-4) && ((double)Math.abs(f3 - fArray[0]) > 1.0E-4 || (double)Math.abs(f4 - fArray[1]) > 1.0E-4)) {
            return fArray;
        }
        return null;
    }

    private static void doModifyRoomsAndWallSides(Home home, ModifiedRoom[] modifiedRoomArray, String string, Boolean bl, Boolean bl2, Integer n, HomeTexture homeTexture, Float f, Boolean bl3, Integer n2, HomeTexture homeTexture2, Float f2, ModifiedWallSide[] modifiedWallSideArray, Integer n3, HomeTexture homeTexture3, Float f3, ModifiedWall[] modifiedWallArray, ModifiedWall[] modifiedWallArray2) {
        Object object;
        if (modifiedWallArray != null) {
            for (ModifiedWall object2 : modifiedWallArray2) {
                object2.reset();
                home.addWall(object2.getWall());
            }
            for (ModifiedWall modifiedWall : modifiedWallArray) {
                home.deleteWall(modifiedWall.getWall());
            }
        }
        for (ModifiedRoom modifiedRoom : modifiedRoomArray) {
            object = modifiedRoom.getRoom();
            if (string != null) {
                ((Room)object).setName(string);
            }
            if (bl != null) {
                ((Room)object).setAreaVisible(bl);
            }
            if (bl2 != null) {
                ((Room)object).setFloorVisible(bl2);
            }
            if (homeTexture != null) {
                ((Room)object).setFloorTexture(homeTexture);
                ((Room)object).setFloorColor(null);
            } else if (n != null) {
                ((Room)object).setFloorColor(n);
                ((Room)object).setFloorTexture(null);
            }
            if (f != null) {
                ((Room)object).setFloorShininess(f.floatValue());
            }
            if (bl3 != null) {
                ((Room)object).setCeilingVisible(bl3);
            }
            if (homeTexture2 != null) {
                ((Room)object).setCeilingTexture(homeTexture2);
                ((Room)object).setCeilingColor(null);
            } else if (n2 != null) {
                ((Room)object).setCeilingColor(n2);
                ((Room)object).setCeilingTexture(null);
            }
            if (f2 == null) continue;
            ((Room)object).setCeilingShininess(f2.floatValue());
        }
        for (ModifiedWallSide modifiedWallSide : modifiedWallSideArray) {
            object = modifiedWallSide.getWallSide();
            if (n3 != null) {
                if (((WallSide)object).getSide() == 0) {
                    ((WallSide)object).getWall().setLeftSideColor(n3);
                } else {
                    ((WallSide)object).getWall().setRightSideColor(n3);
                }
            }
            if (homeTexture3 != null || n3 != null) {
                if (((WallSide)object).getSide() == 0) {
                    ((WallSide)object).getWall().setLeftSideTexture(homeTexture3);
                } else {
                    ((WallSide)object).getWall().setRightSideTexture(homeTexture3);
                }
            }
            if (f3 == null) continue;
            if (((WallSide)object).getSide() == 0) {
                ((WallSide)object).getWall().setLeftSideShininess(f3.floatValue());
                continue;
            }
            ((WallSide)object).getWall().setRightSideShininess(f3.floatValue());
        }
    }

    private static void undoModifyRoomsAndWallSides(Home home, ModifiedRoom[] modifiedRoomArray, ModifiedWallSide[] modifiedWallSideArray, ModifiedWall[] modifiedWallArray, ModifiedWall[] modifiedWallArray2) {
        for (ModifiedRoom object : modifiedRoomArray) {
            object.reset();
        }
        for (ModifiedWallSide modifiedWallSide : modifiedWallSideArray) {
            modifiedWallSide.reset();
        }
        for (ModifiedWall modifiedWall : modifiedWallArray2) {
            home.deleteWall(modifiedWall.getWall());
        }
        for (ModifiedWall modifiedWall : modifiedWallArray) {
            modifiedWall.reset();
            home.addWall(modifiedWall.getWall());
        }
    }

    private static final class ModifiedWallSide {
        private final WallSide wallSide;
        private final Integer wallColor;
        private final HomeTexture wallTexture;
        private final Float wallShininess;

        public ModifiedWallSide(WallSide wallSide) {
            this.wallSide = wallSide;
            if (wallSide.getSide() == 0) {
                this.wallColor = wallSide.getWall().getLeftSideColor();
                this.wallTexture = wallSide.getWall().getLeftSideTexture();
                this.wallShininess = Float.valueOf(wallSide.getWall().getLeftSideShininess());
            } else {
                this.wallColor = wallSide.getWall().getRightSideColor();
                this.wallTexture = wallSide.getWall().getRightSideTexture();
                this.wallShininess = Float.valueOf(wallSide.getWall().getRightSideShininess());
            }
        }

        public WallSide getWallSide() {
            return this.wallSide;
        }

        public void reset() {
            Wall wall;
            if (this.wallSide.getSide() == 0) {
                this.wallSide.getWall().setLeftSideColor(this.wallColor);
                this.wallSide.getWall().setLeftSideTexture(this.wallTexture);
                this.wallSide.getWall().setLeftSideShininess(this.wallShininess.floatValue());
            } else {
                this.wallSide.getWall().setRightSideColor(this.wallColor);
                this.wallSide.getWall().setRightSideTexture(this.wallTexture);
                this.wallSide.getWall().setRightSideShininess(this.wallShininess.floatValue());
            }
            Wall wall2 = this.wallSide.getWall();
            Wall wall3 = this.wallSide.getWallAtStart();
            if (wall3 != null) {
                wall2.setWallAtStart(wall3);
                if (this.wallSide.isJoinedAtEndOfWallAtStart()) {
                    wall3.setWallAtEnd(wall2);
                } else {
                    wall3.setWallAtStart(wall2);
                }
            }
            if ((wall = this.wallSide.getWallAtEnd()) != null) {
                wall2.setWallAtEnd(wall);
                if (this.wallSide.isJoinedAtStartOfWallAtEnd()) {
                    wall.setWallAtStart(wall2);
                } else {
                    wall.setWallAtEnd(wall2);
                }
            }
        }
    }

    private class ModifiedWall {
        private Wall wall;
        private final Wall wallAtStart;
        private final Wall wallAtEnd;
        private final boolean joinedAtEndOfWallAtStart;
        private final boolean joinedAtStartOfWallAtEnd;

        public ModifiedWall(Wall wall) {
            this.wall = wall;
            this.wallAtStart = wall.getWallAtStart();
            this.joinedAtEndOfWallAtStart = this.wallAtStart != null && this.wallAtStart.getWallAtEnd() == wall;
            this.wallAtEnd = wall.getWallAtEnd();
            this.joinedAtStartOfWallAtEnd = this.wallAtEnd != null && this.wallAtEnd.getWallAtStart() == wall;
        }

        public Wall getWall() {
            return this.wall;
        }

        public void reset() {
            if (this.wallAtStart != null) {
                this.wall.setWallAtStart(this.wallAtStart);
                if (this.joinedAtEndOfWallAtStart) {
                    this.wallAtStart.setWallAtEnd(this.wall);
                } else {
                    this.wallAtStart.setWallAtStart(this.wall);
                }
            }
            if (this.wallAtEnd != null) {
                this.wall.setWallAtEnd(this.wallAtEnd);
                if (this.joinedAtStartOfWallAtEnd) {
                    this.wallAtEnd.setWallAtStart(this.wall);
                } else {
                    this.wallAtEnd.setWallAtEnd(this.wall);
                }
            }
        }
    }

    private class WallSide {
        public static final int LEFT_SIDE = 0;
        public static final int RIGHT_SIDE = 1;
        private Wall wall;
        private int side;
        private final Wall wallAtStart;
        private final Wall wallAtEnd;
        private final boolean joinedAtEndOfWallAtStart;
        private final boolean joinedAtStartOfWallAtEnd;

        public WallSide(Wall wall, int n) {
            this.wall = wall;
            this.side = n;
            this.wallAtStart = wall.getWallAtStart();
            this.joinedAtEndOfWallAtStart = this.wallAtStart != null && this.wallAtStart.getWallAtEnd() == wall;
            this.wallAtEnd = wall.getWallAtEnd();
            this.joinedAtStartOfWallAtEnd = this.wallAtEnd != null && this.wallAtEnd.getWallAtStart() == wall;
        }

        public Wall getWall() {
            return this.wall;
        }

        public int getSide() {
            return this.side;
        }

        public Wall getWallAtStart() {
            return this.wallAtStart;
        }

        public Wall getWallAtEnd() {
            return this.wallAtEnd;
        }

        public boolean isJoinedAtEndOfWallAtStart() {
            return this.joinedAtEndOfWallAtStart;
        }

        public boolean isJoinedAtStartOfWallAtEnd() {
            return this.joinedAtStartOfWallAtEnd;
        }
    }

    private static final class ModifiedRoom {
        private final Room room;
        private final String name;
        private final boolean areaVisible;
        private final boolean floorVisible;
        private final Integer floorColor;
        private final HomeTexture floorTexture;
        private final float floorShininess;
        private final boolean ceilingVisible;
        private final Integer ceilingColor;
        private final HomeTexture ceilingTexture;
        private final float ceilingShininess;

        public ModifiedRoom(Room room) {
            this.room = room;
            this.name = room.getName();
            this.areaVisible = room.isAreaVisible();
            this.floorVisible = room.isFloorVisible();
            this.floorColor = room.getFloorColor();
            this.floorTexture = room.getFloorTexture();
            this.floorShininess = room.getFloorShininess();
            this.ceilingVisible = room.isCeilingVisible();
            this.ceilingColor = room.getCeilingColor();
            this.ceilingTexture = room.getCeilingTexture();
            this.ceilingShininess = room.getCeilingShininess();
        }

        public Room getRoom() {
            return this.room;
        }

        public void reset() {
            this.room.setName(this.name);
            this.room.setAreaVisible(this.areaVisible);
            this.room.setFloorVisible(this.floorVisible);
            this.room.setFloorColor(this.floorColor);
            this.room.setFloorTexture(this.floorTexture);
            this.room.setFloorShininess(this.floorShininess);
            this.room.setCeilingVisible(this.ceilingVisible);
            this.room.setCeilingColor(this.ceilingColor);
            this.room.setCeilingTexture(this.ceilingTexture);
            this.room.setCeilingShininess(this.ceilingShininess);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RoomsAndWallSidesModificationUndoableEdit
    extends AbstractUndoableEdit {
        private final Home home;
        private final UserPreferences preferences;
        private final List<Selectable> oldSelection;
        private final List<Selectable> newSelection;
        private final ModifiedRoom[] modifiedRooms;
        private final String name;
        private final Boolean areaVisible;
        private final Integer floorColor;
        private final HomeTexture floorTexture;
        private final Boolean floorVisible;
        private final Float floorShininess;
        private final Integer ceilingColor;
        private final HomeTexture ceilingTexture;
        private final Boolean ceilingVisible;
        private final Float ceilingShininess;
        private final ModifiedWallSide[] modifiedWallSides;
        private final Integer wallSidesColor;
        private final HomeTexture wallSidesTexture;
        private final Float wallSidesShininess;
        private final ModifiedWall[] deletedWalls;
        private final ModifiedWall[] addedWalls;

        private RoomsAndWallSidesModificationUndoableEdit(Home home, UserPreferences userPreferences, List<Selectable> list, List<Selectable> list2, ModifiedRoom[] modifiedRoomArray, String string, Boolean bl, Integer n, HomeTexture homeTexture, Boolean bl2, Float f, Integer n2, HomeTexture homeTexture2, Boolean bl3, Float f2, ModifiedWallSide[] modifiedWallSideArray, Integer n3, HomeTexture homeTexture3, Float f3, ModifiedWall[] modifiedWallArray, ModifiedWall[] modifiedWallArray2) {
            this.home = home;
            this.preferences = userPreferences;
            this.oldSelection = list;
            this.newSelection = list2;
            this.modifiedRooms = modifiedRoomArray;
            this.name = string;
            this.areaVisible = bl;
            this.floorColor = n;
            this.floorTexture = homeTexture;
            this.floorVisible = bl2;
            this.floorShininess = f;
            this.ceilingColor = n2;
            this.ceilingTexture = homeTexture2;
            this.ceilingVisible = bl3;
            this.ceilingShininess = f2;
            this.modifiedWallSides = modifiedWallSideArray;
            this.wallSidesColor = n3;
            this.wallSidesTexture = homeTexture3;
            this.wallSidesShininess = f3;
            this.deletedWalls = modifiedWallArray;
            this.addedWalls = modifiedWallArray2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            RoomController.undoModifyRoomsAndWallSides(this.home, this.modifiedRooms, this.modifiedWallSides, this.deletedWalls, this.addedWalls);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            RoomController.doModifyRoomsAndWallSides(this.home, this.modifiedRooms, this.name, this.areaVisible, this.floorVisible, this.floorColor, this.floorTexture, this.floorShininess, this.ceilingVisible, this.ceilingColor, this.ceilingTexture, this.ceilingShininess, this.modifiedWallSides, this.wallSidesColor, this.wallSidesTexture, this.wallSidesShininess, this.deletedWalls, this.addedWalls);
            this.home.setSelectedItems(this.newSelection);
        }

        @Override
        public String getPresentationName() {
            return this.preferences.getLocalizedString(RoomController.class, "undoModifyRoomsName", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RoomPaint {
        COLORED,
        TEXTURED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        NAME,
        AREA_VISIBLE,
        FLOOR_VISIBLE,
        FLOOR_COLOR,
        FLOOR_PAINT,
        FLOOR_SHININESS,
        CEILING_VISIBLE,
        CEILING_COLOR,
        CEILING_PAINT,
        CEILING_SHININESS,
        SPLIT_SURROUNDING_WALLS,
        WALL_SIDES_COLOR,
        WALL_SIDES_PAINT,
        WALL_SIDES_SHININESS;

    }
}

