/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.NumberFormatter;

public class NullableSpinner
extends AutoCommitSpinner {
    public NullableSpinner() {
        this(new NullableSpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
    }

    public NullableSpinner(NullableSpinnerNumberModel nullableSpinnerNumberModel) {
        super(nullableSpinnerNumberModel);
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        final JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
        jFormattedTextField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
                return new NumberFormatter(){

                    public boolean getCommitsOnValidEdit() {
                        if (abstractFormatter instanceof NumberFormatter) {
                            return ((NumberFormatter)abstractFormatter).getCommitsOnValidEdit();
                        }
                        return super.getCommitsOnValidEdit();
                    }

                    public Comparable getMaximum() {
                        if (abstractFormatter instanceof NumberFormatter) {
                            return ((NumberFormatter)abstractFormatter).getMaximum();
                        }
                        return super.getMaximum();
                    }

                    public Comparable getMinimum() {
                        if (abstractFormatter instanceof NumberFormatter) {
                            return ((NumberFormatter)abstractFormatter).getMinimum();
                        }
                        return super.getMinimum();
                    }

                    public void setMaximum(Comparable comparable) {
                        if (abstractFormatter instanceof NumberFormatter) {
                            ((NumberFormatter)abstractFormatter).setMaximum(comparable);
                        } else {
                            super.setMaximum(comparable);
                        }
                    }

                    public void setMinimum(Comparable comparable) {
                        if (abstractFormatter instanceof NumberFormatter) {
                            ((NumberFormatter)abstractFormatter).setMinimum(comparable);
                        } else {
                            super.setMinimum(comparable);
                        }
                    }

                    public Object stringToValue(String string) throws ParseException {
                        if (string.length() == 0 && ((NullableSpinnerNumberModel)NullableSpinner.this.getModel()).isNullable()) {
                            return null;
                        }
                        return abstractFormatter.stringToValue(string);
                    }

                    public String valueToString(Object object) throws ParseException {
                        if (object == null && ((NullableSpinnerNumberModel)NullableSpinner.this.getModel()).isNullable()) {
                            return "";
                        }
                        return abstractFormatter.valueToString(object);
                    }
                };
            }
        });
    }

    public static class NullableSpinnerLengthModel
    extends NullableSpinnerNumberModel {
        private final UserPreferences preferences;

        public NullableSpinnerLengthModel(UserPreferences userPreferences, float f, float f2) {
            this(userPreferences, f, f, f2);
        }

        public NullableSpinnerLengthModel(UserPreferences userPreferences, float f, float f2, float f3) {
            super(userPreferences.getLengthUnit().centimeterToUnit(f), userPreferences.getLengthUnit().centimeterToUnit(f2), userPreferences.getLengthUnit().centimeterToUnit(f3), userPreferences.getLengthUnit() == LengthUnit.INCH || userPreferences.getLengthUnit() == LengthUnit.INCH_DECIMALS ? 0.125f : userPreferences.getLengthUnit().centimeterToUnit(0.5f));
            this.preferences = userPreferences;
        }

        public Float getLength() {
            if (this.getValue() == null) {
                return null;
            }
            return Float.valueOf(this.preferences.getLengthUnit().unitToCentimeter(((Number)this.getValue()).floatValue()));
        }

        public void setLength(Float f) {
            if (f != null) {
                f = Float.valueOf(this.preferences.getLengthUnit().centimeterToUnit(f.floatValue()));
            }
            this.setValue(f);
        }
    }

    public static class NullableSpinnerNumberModel
    extends SpinnerNumberModel {
        private boolean isNull;
        private boolean nullable;

        public NullableSpinnerNumberModel(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        public NullableSpinnerNumberModel(float f, float f2, float f3, float f4) {
            super(new Float(f), new Float(f2), new Float(f3), new Float(f4));
        }

        public Object getNextValue() {
            if (this.isNull) {
                return super.getValue();
            }
            Object object = super.getNextValue();
            if (object == null) {
                return this.getMaximum();
            }
            return object;
        }

        public Object getPreviousValue() {
            if (this.isNull) {
                return super.getValue();
            }
            Object object = super.getPreviousValue();
            if (object == null) {
                return this.getMinimum();
            }
            return object;
        }

        public Object getValue() {
            if (this.isNull) {
                return null;
            }
            return super.getValue();
        }

        public void setValue(Object object) {
            if (object == null && this.isNullable()) {
                if (!this.isNull) {
                    this.isNull = true;
                    this.fireStateChanged();
                }
            } else if (this.isNull && object != null && object.equals(super.getValue())) {
                this.isNull = false;
                this.fireStateChanged();
            } else {
                this.isNull = false;
                super.setValue(object);
            }
        }

        public Number getNumber() {
            return (Number)this.getValue();
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public void setNullable(boolean bl) {
            this.nullable = bl;
            if (!bl && this.getValue() == null) {
                this.setValue(this.getMinimum());
            }
        }
    }

    public static class NullableSpinnerDateModel
    extends SpinnerDateModel {
        private boolean isNull;
        private boolean nullable;

        public Object getNextValue() {
            if (this.isNull) {
                return super.getValue();
            }
            return super.getNextValue();
        }

        public Object getPreviousValue() {
            if (this.isNull) {
                return super.getValue();
            }
            return super.getPreviousValue();
        }

        public Object getValue() {
            if (this.isNull) {
                return null;
            }
            return super.getValue();
        }

        public void setValue(Object object) {
            if (object == null && this.isNullable()) {
                if (!this.isNull) {
                    this.isNull = true;
                    this.fireStateChanged();
                }
            } else if (this.isNull && object != null && object.equals(super.getValue())) {
                this.isNull = false;
                this.fireStateChanged();
            } else {
                this.isNull = false;
                super.setValue(object);
            }
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public void setNullable(boolean bl) {
            this.nullable = bl;
            if (!bl && this.getValue() == null) {
                this.setValue(new Date());
            }
        }
    }
}

