/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.PieceOfFurniture;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.FurnitureCatalogTree;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JToolTip;

public class FurnitureToolTip
extends JToolTip {
    private static final int ICON_SIZE = 128;
    private final boolean ignoreCategory;
    private final UserPreferences preferences;
    private final JLabel pieceIconLabel;
    private PieceOfFurniture piece;

    public FurnitureToolTip(boolean bl, UserPreferences userPreferences) {
        this.ignoreCategory = bl;
        this.preferences = userPreferences;
        this.pieceIconLabel = new JLabel();
        this.pieceIconLabel.setPreferredSize(new Dimension(128, 128));
        this.pieceIconLabel.setHorizontalAlignment(0);
        this.pieceIconLabel.setVerticalAlignment(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.pieceIconLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPieceOfFurniture(PieceOfFurniture pieceOfFurniture) {
        if (pieceOfFurniture != this.piece) {
            String string;
            String string2 = null;
            if (this.preferences != null && pieceOfFurniture instanceof CatalogPieceOfFurniture && (string = ((CatalogPieceOfFurniture)pieceOfFurniture).getCreator()) != null) {
                string2 = this.preferences.getLocalizedString(FurnitureCatalogTree.class, "tooltipCreator", string);
            }
            boolean bl = false;
            if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
                string = "<html><center>";
                if (!this.ignoreCategory && pieceOfFurniture instanceof CatalogPieceOfFurniture) {
                    string = string + "- <b>" + ((CatalogPieceOfFurniture)pieceOfFurniture).getCategory().getName() + "</b> -<br>";
                }
                string = string + "<b>" + pieceOfFurniture.getName() + "</b>";
                if (string2 != null) {
                    string = string + "<br>" + string2;
                }
                string = string + "</center>";
            } else if (this.isTipTextComplete()) {
                bl = true;
                string = "<html><table><tr><td align='center'>";
                if (!this.ignoreCategory && pieceOfFurniture instanceof CatalogPieceOfFurniture) {
                    string = string + "- <b>" + ((CatalogPieceOfFurniture)pieceOfFurniture).getCategory().getName() + "</b> -<br>";
                }
                string = string + "<b>" + pieceOfFurniture.getName() + "</b>";
                if (string2 != null) {
                    string = string + "<br>" + string2;
                }
                string = string + "</td></tr>";
            } else {
                string = pieceOfFurniture.getName();
                if (string2 != null) {
                    string = string + " " + string2;
                }
            }
            this.pieceIconLabel.setIcon(null);
            if (pieceOfFurniture.getIcon() instanceof URLContent) {
                InputStream inputStream = null;
                try {
                    inputStream = pieceOfFurniture.getIcon().openStream();
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    if (bufferedImage != null) {
                        int n = Math.round(128.0f * Math.min(1.0f, (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight()));
                        int n2 = Math.round((float)n * (float)bufferedImage.getHeight() / (float)bufferedImage.getWidth());
                        if (bl) {
                            string = string + "<tr><td width='128' height='128' align='center' valign='middle'><img width='" + n + "' height='" + n2 + "' src='" + ((URLContent)pieceOfFurniture.getIcon()).getURL() + "'></td></tr>";
                        } else {
                            this.pieceIconLabel.setIcon(IconManager.getInstance().getIcon(pieceOfFurniture.getIcon(), n2, this));
                        }
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (bl) {
                string = string + "</table>";
            }
            this.setTipText(string);
            this.piece = pieceOfFurniture;
        }
    }

    boolean isTipTextComplete() {
        return !OperatingSystem.isJavaVersionGreaterOrEqual("1.6") && OperatingSystem.isMacOSX();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.pieceIconLabel.getIcon() != null) {
            dimension.width = Math.max(dimension.width, 134);
            dimension.height += 134;
        }
        return dimension;
    }
}

