/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionChangeSupport;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomePrint;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.Wall;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Home
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final long CURRENT_VERSION = 4200L;
    private static final boolean KEEP_BACKWARD_COMPATIBLITY = true;
    private static final Comparator<Level> LEVEL_ELEVATION_COMPARATOR = new Comparator<Level>(){

        @Override
        public int compare(Level level, Level level2) {
            int n = Float.compare(level.getElevation(), level2.getElevation());
            if (n != 0) {
                return n;
            }
            return -Float.compare(level.getHeight(), level2.getHeight());
        }
    };
    private List<HomePieceOfFurniture> furniture;
    private transient CollectionChangeSupport<HomePieceOfFurniture> furnitureChangeSupport;
    private transient List<Selectable> selectedItems;
    private transient List<SelectionListener> selectionListeners;
    private List<Level> levels;
    private Level selectedLevel;
    private transient CollectionChangeSupport<Level> levelsChangeSupport;
    private List<Wall> walls;
    private transient CollectionChangeSupport<Wall> wallsChangeSupport;
    private List<Room> rooms;
    private transient CollectionChangeSupport<Room> roomsChangeSupport;
    private List<DimensionLine> dimensionLines;
    private transient CollectionChangeSupport<DimensionLine> dimensionLinesChangeSupport;
    private List<Label> labels;
    private transient CollectionChangeSupport<Label> labelsChangeSupport;
    private Camera camera;
    private String name;
    private final float wallHeight;
    private transient boolean modified;
    private transient boolean recovered;
    private BackgroundImage backgroundImage;
    private ObserverCamera observerCamera;
    private Camera topCamera;
    private List<Camera> storedCameras;
    private HomeEnvironment environment;
    private HomePrint print;
    private String furnitureSortedPropertyName;
    private List<String> furnitureVisiblePropertyNames;
    private boolean furnitureDescendingSorted;
    private Map<String, Object> visualProperties;
    private transient PropertyChangeSupport propertyChangeSupport;
    private long version;
    private boolean basePlanLocked;
    private Compass compass;
    private int skyColor;
    private int groundColor;
    private HomeTexture groundTexture;
    private int lightColor;
    private float wallsAlpha;
    private HomePieceOfFurniture.SortableProperty furnitureSortedProperty;
    private List<HomePieceOfFurniture.SortableProperty> furnitureVisibleProperties;
    private List<HomePieceOfFurniture> furnitureWithDoorsAndWindows;
    private List<HomePieceOfFurniture> furnitureWithGroups;

    public Home() {
        this(250.0f);
    }

    public Home(float f) {
        this(new ArrayList<HomePieceOfFurniture>(), f);
    }

    public Home(List<HomePieceOfFurniture> list) {
        this(list, 250.0f);
    }

    private Home(List<HomePieceOfFurniture> list, float f) {
        this.furniture = new ArrayList<HomePieceOfFurniture>(list);
        this.walls = new ArrayList<Wall>();
        this.wallHeight = f;
        this.furnitureVisibleProperties = Arrays.asList(HomePieceOfFurniture.SortableProperty.NAME, HomePieceOfFurniture.SortableProperty.WIDTH, HomePieceOfFurniture.SortableProperty.DEPTH, HomePieceOfFurniture.SortableProperty.HEIGHT, HomePieceOfFurniture.SortableProperty.VISIBLE);
        this.init(true);
        this.addModelListeners();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init(false);
        objectInputStream.defaultReadObject();
        this.addModelListeners();
        if (this.furnitureSortedPropertyName != null) {
            try {
                this.furnitureSortedProperty = HomePieceOfFurniture.SortableProperty.valueOf(this.furnitureSortedPropertyName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.furnitureSortedPropertyName = null;
        }
        if (this.furnitureVisiblePropertyNames != null) {
            this.furnitureVisibleProperties = new ArrayList<HomePieceOfFurniture.SortableProperty>();
            for (String object : this.furnitureVisiblePropertyNames) {
                try {
                    this.furnitureVisibleProperties.add(HomePieceOfFurniture.SortableProperty.valueOf(object));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            this.furnitureVisiblePropertyNames = null;
        }
        for (Wall wall : this.walls) {
            if (wall.getHeight() != null) continue;
            wall.setHeight(Float.valueOf(this.wallHeight));
        }
        if (this.furnitureWithDoorsAndWindows != null) {
            this.furniture = this.furnitureWithDoorsAndWindows;
            this.furnitureWithDoorsAndWindows = null;
        }
        if (this.furnitureWithGroups != null) {
            this.furniture = this.furnitureWithGroups;
            this.furnitureWithGroups = null;
        }
        this.environment.setGroundColor(this.groundColor);
        this.environment.setGroundTexture(this.groundTexture);
        this.environment.setSkyColor(this.skyColor);
        this.environment.setLightColor(this.lightColor);
        this.environment.setWallsAlpha(this.wallsAlpha);
        if (this.version <= 3400L) {
            int n = this.environment.getGroundColor();
            this.environment.setGroundColor((n >> 16 & 0xFF) * 3 / 4 << 16 | (n >> 8 & 0xFF) * 3 / 4 << 8 | (n & 0xFF) * 3 / 4);
        }
    }

    private void init(boolean bl) {
        this.selectedItems = new ArrayList<Selectable>();
        this.furnitureChangeSupport = new CollectionChangeSupport(this);
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.levelsChangeSupport = new CollectionChangeSupport(this);
        this.wallsChangeSupport = new CollectionChangeSupport(this);
        this.roomsChangeSupport = new CollectionChangeSupport(this);
        this.dimensionLinesChangeSupport = new CollectionChangeSupport(this);
        this.labelsChangeSupport = new CollectionChangeSupport(this);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        if (this.furnitureVisibleProperties == null) {
            this.furnitureVisibleProperties = Arrays.asList(HomePieceOfFurniture.SortableProperty.NAME, HomePieceOfFurniture.SortableProperty.WIDTH, HomePieceOfFurniture.SortableProperty.DEPTH, HomePieceOfFurniture.SortableProperty.HEIGHT, HomePieceOfFurniture.SortableProperty.COLOR, HomePieceOfFurniture.SortableProperty.MOVABLE, HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW, HomePieceOfFurniture.SortableProperty.VISIBLE);
        }
        this.topCamera = new Camera(500.0f, 1500.0f, 1010.0f, (float)Math.PI, 0.7853982f, 1.0995575f);
        this.observerCamera = new ObserverCamera(50.0f, 50.0f, 170.0f, 5.4977875f, 0.19634955f, 1.0995575f);
        this.storedCameras = Collections.emptyList();
        this.environment = new HomeEnvironment();
        this.rooms = new ArrayList<Room>();
        this.dimensionLines = new ArrayList<DimensionLine>();
        this.labels = new ArrayList<Label>();
        this.compass = new Compass(-100.0f, 50.0f, 100.0f);
        this.levels = new ArrayList<Level>();
        this.compass.setVisible(bl);
        this.visualProperties = new HashMap<String, Object>();
        this.version = 4200L;
    }

    private void addModelListeners() {
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Level.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName()) || Level.Property.HEIGHT.name().equals(propertyChangeEvent.getPropertyName())) {
                    Home.this.levels = new ArrayList(Home.this.levels);
                    Collections.sort(Home.this.levels, LEVEL_ELEVATION_COMPARATOR);
                }
            }
        };
        for (Level level : this.levels) {
            level.addPropertyChangeListener(propertyChangeListener);
        }
        this.addLevelsListener(new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                switch (collectionEvent.getType()) {
                    case ADD: {
                        collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener);
                        break;
                    }
                    case DELETE: {
                        collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.version = 4200L;
        HomePieceOfFurniture.SortableProperty sortableProperty = this.furnitureSortedProperty;
        List<HomePieceOfFurniture.SortableProperty> list = this.furnitureVisibleProperties;
        List<HomePieceOfFurniture> list2 = this.furniture;
        try {
            if (this.furnitureSortedProperty != null) {
                this.furnitureSortedPropertyName = this.furnitureSortedProperty.name();
                if (!this.isFurnitureSortedPropertyBackwardCompatible(this.furnitureSortedProperty)) {
                    this.furnitureSortedProperty = null;
                }
            }
            this.furnitureVisiblePropertyNames = new ArrayList<String>();
            this.furnitureVisibleProperties = new ArrayList<HomePieceOfFurniture.SortableProperty>();
            for (HomePieceOfFurniture.SortableProperty object : list) {
                this.furnitureVisiblePropertyNames.add(object.name());
                if (!this.isFurnitureSortedPropertyBackwardCompatible(object)) continue;
                this.furnitureVisibleProperties.add(object);
            }
            this.furnitureWithGroups = this.furniture;
            this.furnitureWithDoorsAndWindows = new ArrayList<HomePieceOfFurniture>(this.furniture.size());
            this.furniture = new ArrayList<HomePieceOfFurniture>(this.furniture.size());
            for (HomePieceOfFurniture homePieceOfFurniture : this.furnitureWithGroups) {
                if (homePieceOfFurniture.getClass() == HomePieceOfFurniture.class) {
                    this.furnitureWithDoorsAndWindows.add(homePieceOfFurniture);
                    this.furniture.add(homePieceOfFurniture);
                    continue;
                }
                if (homePieceOfFurniture.getClass() == HomeFurnitureGroup.class) {
                    for (HomePieceOfFurniture homePieceOfFurniture2 : this.getGroupFurniture((HomeFurnitureGroup)homePieceOfFurniture)) {
                        this.furnitureWithDoorsAndWindows.add(homePieceOfFurniture2);
                        if (homePieceOfFurniture2.getClass() == HomePieceOfFurniture.class) {
                            this.furniture.add(homePieceOfFurniture2);
                            continue;
                        }
                        this.furniture.add(new HomePieceOfFurniture(homePieceOfFurniture2));
                    }
                    continue;
                }
                this.furnitureWithDoorsAndWindows.add(homePieceOfFurniture);
                this.furniture.add(new HomePieceOfFurniture(homePieceOfFurniture));
            }
            this.groundColor = this.environment.getGroundColor();
            this.groundTexture = this.environment.getGroundTexture();
            this.skyColor = this.environment.getSkyColor();
            this.lightColor = this.environment.getLightColor();
            this.wallsAlpha = this.environment.getWallsAlpha();
            objectOutputStream.defaultWriteObject();
        }
        finally {
            this.furniture = list2;
            this.furnitureWithDoorsAndWindows = null;
            this.furnitureWithGroups = null;
            this.furnitureSortedProperty = sortableProperty;
            this.furnitureVisibleProperties = list;
            this.furnitureSortedPropertyName = null;
            this.furnitureVisiblePropertyNames = null;
        }
    }

    private boolean isFurnitureSortedPropertyBackwardCompatible(HomePieceOfFurniture.SortableProperty sortableProperty) {
        switch (sortableProperty) {
            case NAME: 
            case WIDTH: 
            case DEPTH: 
            case HEIGHT: 
            case MOVABLE: 
            case DOOR_OR_WINDOW: 
            case COLOR: 
            case VISIBLE: 
            case X: 
            case Y: 
            case ELEVATION: 
            case ANGLE: {
                return true;
            }
        }
        return false;
    }

    private List<HomePieceOfFurniture> getGroupFurniture(HomeFurnitureGroup homeFurnitureGroup) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture homePieceOfFurniture : homeFurnitureGroup.getFurniture()) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                arrayList.addAll(this.getGroupFurniture((HomeFurnitureGroup)homePieceOfFurniture));
                continue;
            }
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    public void addLevelsListener(CollectionListener<Level> collectionListener) {
        this.levelsChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeLevelsListener(CollectionListener<Level> collectionListener) {
        this.levelsChangeSupport.removeCollectionListener(collectionListener);
    }

    public List<Level> getLevels() {
        return Collections.unmodifiableList(this.levels);
    }

    public void addLevel(Level level) {
        this.levels = new ArrayList<Level>(this.levels);
        int n = Collections.binarySearch(this.levels, level, LEVEL_ELEVATION_COMPARATOR);
        int n2 = n >= 0 ? n : -(n + 1);
        this.levels.add(n2, level);
        this.levelsChangeSupport.fireCollectionChanged(level, n2, CollectionEvent.Type.ADD);
    }

    public void deleteLevel(Level level) {
        int n = this.levels.indexOf(level);
        if (n != -1) {
            for (HomePieceOfFurniture selectable : this.furniture) {
                if (selectable.getLevel() != level) continue;
                this.deletePieceOfFurniture(selectable);
            }
            for (Room room : this.rooms) {
                if (room.getLevel() != level) continue;
                this.deleteRoom(room);
            }
            for (Wall wall : this.walls) {
                if (wall.getLevel() != level) continue;
                this.deleteWall(wall);
            }
            for (DimensionLine dimensionLine : this.dimensionLines) {
                if (dimensionLine.getLevel() != level) continue;
                this.deleteDimensionLine(dimensionLine);
            }
            for (Label label : this.labels) {
                if (label.getLevel() != level) continue;
                this.deleteLabel(label);
            }
            if (this.selectedLevel == level) {
                if (this.levels.size() == 1) {
                    this.setSelectedLevel(null);
                } else {
                    this.setSelectedLevel(this.levels.get(n >= 1 ? n - 1 : n + 1));
                }
            }
            this.levels = new ArrayList<Level>(this.levels);
            this.levels.remove(n);
            this.levelsChangeSupport.fireCollectionChanged(level, n, CollectionEvent.Type.DELETE);
        }
    }

    public Level getSelectedLevel() {
        return this.selectedLevel;
    }

    public void setSelectedLevel(Level level) {
        if (level != this.selectedLevel) {
            Level level2 = this.selectedLevel;
            this.selectedLevel = level;
            this.propertyChangeSupport.firePropertyChange(Property.SELECTED_LEVEL.name(), level2, level);
        }
    }

    public void addFurnitureListener(CollectionListener<HomePieceOfFurniture> collectionListener) {
        this.furnitureChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeFurnitureListener(CollectionListener<HomePieceOfFurniture> collectionListener) {
        this.furnitureChangeSupport.removeCollectionListener(collectionListener);
    }

    public List<HomePieceOfFurniture> getFurniture() {
        return Collections.unmodifiableList(this.furniture);
    }

    public void addPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
        this.addPieceOfFurniture(homePieceOfFurniture, this.furniture.size());
    }

    public void addPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture, int n) {
        this.furniture = new ArrayList<HomePieceOfFurniture>(this.furniture);
        homePieceOfFurniture.setLevel(this.selectedLevel);
        this.furniture.add(n, homePieceOfFurniture);
        this.furnitureChangeSupport.fireCollectionChanged(homePieceOfFurniture, n, CollectionEvent.Type.ADD);
    }

    public void deletePieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
        this.deselectItem(homePieceOfFurniture);
        int n = this.furniture.indexOf(homePieceOfFurniture);
        if (n != -1) {
            homePieceOfFurniture.setLevel(null);
            this.furniture = new ArrayList<HomePieceOfFurniture>(this.furniture);
            this.furniture.remove(n);
            this.furnitureChangeSupport.fireCollectionChanged(homePieceOfFurniture, n, CollectionEvent.Type.DELETE);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    public List<Selectable> getSelectedItems() {
        return Collections.unmodifiableList(this.selectedItems);
    }

    public void setSelectedItems(List<? extends Selectable> list) {
        this.selectedItems = new ArrayList<Selectable>(list);
        if (!this.selectionListeners.isEmpty()) {
            SelectionListener[] selectionListenerArray;
            SelectionEvent selectionEvent = new SelectionEvent(this, this.getSelectedItems());
            for (SelectionListener selectionListener : selectionListenerArray = this.selectionListeners.toArray(new SelectionListener[this.selectionListeners.size()])) {
                selectionListener.selectionChanged(selectionEvent);
            }
        }
    }

    public void deselectItem(Selectable selectable) {
        int n = this.selectedItems.indexOf(selectable);
        if (n != -1) {
            ArrayList<Selectable> arrayList = new ArrayList<Selectable>(this.getSelectedItems());
            arrayList.remove(n);
            this.setSelectedItems(arrayList);
        }
    }

    public void addRoomsListener(CollectionListener<Room> collectionListener) {
        this.roomsChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeRoomsListener(CollectionListener<Room> collectionListener) {
        this.roomsChangeSupport.removeCollectionListener(collectionListener);
    }

    public List<Room> getRooms() {
        return Collections.unmodifiableList(this.rooms);
    }

    public void addRoom(Room room) {
        this.addRoom(room, this.rooms.size());
    }

    public void addRoom(Room room, int n) {
        this.rooms = new ArrayList<Room>(this.rooms);
        this.rooms.add(n, room);
        room.setLevel(this.selectedLevel);
        this.roomsChangeSupport.fireCollectionChanged(room, n, CollectionEvent.Type.ADD);
    }

    public void deleteRoom(Room room) {
        this.deselectItem(room);
        int n = this.rooms.indexOf(room);
        if (n != -1) {
            room.setLevel(null);
            this.rooms = new ArrayList<Room>(this.rooms);
            this.rooms.remove(n);
            this.roomsChangeSupport.fireCollectionChanged(room, n, CollectionEvent.Type.DELETE);
        }
    }

    public void addWallsListener(CollectionListener<Wall> collectionListener) {
        this.wallsChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeWallsListener(CollectionListener<Wall> collectionListener) {
        this.wallsChangeSupport.removeCollectionListener(collectionListener);
    }

    public Collection<Wall> getWalls() {
        return Collections.unmodifiableCollection(this.walls);
    }

    public void addWall(Wall wall) {
        this.walls = new ArrayList<Wall>(this.walls);
        this.walls.add(wall);
        wall.setLevel(this.selectedLevel);
        this.wallsChangeSupport.fireCollectionChanged(wall, CollectionEvent.Type.ADD);
    }

    public void deleteWall(Wall wall) {
        this.deselectItem(wall);
        for (Wall wall2 : this.getWalls()) {
            if (wall.equals(wall2.getWallAtStart())) {
                wall2.setWallAtStart(null);
                continue;
            }
            if (!wall.equals(wall2.getWallAtEnd())) continue;
            wall2.setWallAtEnd(null);
        }
        int n = this.walls.indexOf(wall);
        if (n != -1) {
            wall.setLevel(null);
            this.walls = new ArrayList<Wall>(this.walls);
            this.walls.remove(n);
            this.wallsChangeSupport.fireCollectionChanged(wall, CollectionEvent.Type.DELETE);
        }
    }

    public void addDimensionLinesListener(CollectionListener<DimensionLine> collectionListener) {
        this.dimensionLinesChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeDimensionLinesListener(CollectionListener<DimensionLine> collectionListener) {
        this.dimensionLinesChangeSupport.removeCollectionListener(collectionListener);
    }

    public Collection<DimensionLine> getDimensionLines() {
        return Collections.unmodifiableCollection(this.dimensionLines);
    }

    public void addDimensionLine(DimensionLine dimensionLine) {
        this.dimensionLines = new ArrayList<DimensionLine>(this.dimensionLines);
        this.dimensionLines.add(dimensionLine);
        dimensionLine.setLevel(this.selectedLevel);
        this.dimensionLinesChangeSupport.fireCollectionChanged(dimensionLine, CollectionEvent.Type.ADD);
    }

    public void deleteDimensionLine(DimensionLine dimensionLine) {
        this.deselectItem(dimensionLine);
        int n = this.dimensionLines.indexOf(dimensionLine);
        if (n != -1) {
            dimensionLine.setLevel(null);
            this.dimensionLines = new ArrayList<DimensionLine>(this.dimensionLines);
            this.dimensionLines.remove(n);
            this.dimensionLinesChangeSupport.fireCollectionChanged(dimensionLine, CollectionEvent.Type.DELETE);
        }
    }

    public void addLabelsListener(CollectionListener<Label> collectionListener) {
        this.labelsChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeLabelsListener(CollectionListener<Label> collectionListener) {
        this.labelsChangeSupport.removeCollectionListener(collectionListener);
    }

    public Collection<Label> getLabels() {
        return Collections.unmodifiableCollection(this.labels);
    }

    public void addLabel(Label label) {
        this.labels = new ArrayList<Label>(this.labels);
        this.labels.add(label);
        label.setLevel(this.selectedLevel);
        this.labelsChangeSupport.fireCollectionChanged(label, CollectionEvent.Type.ADD);
    }

    public void deleteLabel(Label label) {
        this.deselectItem(label);
        int n = this.labels.indexOf(label);
        if (n != -1) {
            label.setLevel(null);
            this.labels = new ArrayList<Label>(this.labels);
            this.labels.remove(n);
            this.labelsChangeSupport.fireCollectionChanged(label, CollectionEvent.Type.DELETE);
        }
    }

    public boolean isEmpty() {
        return this.furniture.isEmpty() && this.walls.isEmpty() && this.rooms.isEmpty() && this.dimensionLines.isEmpty() && this.labels.isEmpty();
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public float getWallHeight() {
        return this.wallHeight;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!(string == this.name || string != null && string.equals(this.name))) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        if (bl != this.modified) {
            this.modified = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MODIFIED.name(), !bl, bl);
        }
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public void setRecovered(boolean bl) {
        if (bl != this.recovered) {
            this.recovered = bl;
            this.propertyChangeSupport.firePropertyChange(Property.RECOVERED.name(), !bl, bl);
        }
    }

    public HomePieceOfFurniture.SortableProperty getFurnitureSortedProperty() {
        return this.furnitureSortedProperty;
    }

    public void setFurnitureSortedProperty(HomePieceOfFurniture.SortableProperty sortableProperty) {
        if (!(sortableProperty == this.furnitureSortedProperty || sortableProperty != null && sortableProperty.equals((Object)this.furnitureSortedProperty))) {
            HomePieceOfFurniture.SortableProperty sortableProperty2 = this.furnitureSortedProperty;
            this.furnitureSortedProperty = sortableProperty;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_SORTED_PROPERTY.name(), (Object)sortableProperty2, (Object)sortableProperty);
        }
    }

    public boolean isFurnitureDescendingSorted() {
        return this.furnitureDescendingSorted;
    }

    public void setFurnitureDescendingSorted(boolean bl) {
        if (bl != this.furnitureDescendingSorted) {
            this.furnitureDescendingSorted = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_DESCENDING_SORTED.name(), !bl, bl);
        }
    }

    public List<HomePieceOfFurniture.SortableProperty> getFurnitureVisibleProperties() {
        if (this.furnitureVisibleProperties == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.furnitureVisibleProperties);
    }

    public void setFurnitureVisibleProperties(List<HomePieceOfFurniture.SortableProperty> list) {
        if (!(list == this.furnitureVisibleProperties || list != null && ((Object)list).equals(this.furnitureVisibleProperties))) {
            List<HomePieceOfFurniture.SortableProperty> list2 = this.furnitureVisibleProperties;
            this.furnitureVisibleProperties = new ArrayList<HomePieceOfFurniture.SortableProperty>(list);
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_VISIBLE_PROPERTIES.name(), Collections.unmodifiableList(list2), Collections.unmodifiableList(list));
        }
    }

    public BackgroundImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(BackgroundImage backgroundImage) {
        if (backgroundImage != this.backgroundImage) {
            BackgroundImage backgroundImage2 = this.backgroundImage;
            this.backgroundImage = backgroundImage;
            this.propertyChangeSupport.firePropertyChange(Property.BACKGROUND_IMAGE.name(), backgroundImage2, backgroundImage);
        }
    }

    public Camera getTopCamera() {
        return this.topCamera;
    }

    public ObserverCamera getObserverCamera() {
        return this.observerCamera;
    }

    public void setCamera(Camera camera) {
        if (camera != this.camera) {
            Camera camera2 = this.camera;
            this.camera = camera;
            this.propertyChangeSupport.firePropertyChange(Property.CAMERA.name(), camera2, camera);
        }
    }

    public Camera getCamera() {
        if (this.camera == null) {
            this.camera = this.getTopCamera();
        }
        return this.camera;
    }

    public void setStoredCameras(List<Camera> list) {
        if (!((Object)this.storedCameras).equals(list)) {
            List<Camera> list2 = this.storedCameras;
            this.storedCameras = list == null ? Collections.emptyList() : new ArrayList<Camera>(list);
            this.propertyChangeSupport.firePropertyChange(Property.STORED_CAMERAS.name(), Collections.unmodifiableList(list2), Collections.unmodifiableList(list));
        }
    }

    public List<Camera> getStoredCameras() {
        return Collections.unmodifiableList(this.storedCameras);
    }

    public HomeEnvironment getEnvironment() {
        return this.environment;
    }

    public Compass getCompass() {
        return this.compass;
    }

    public HomePrint getPrint() {
        return this.print;
    }

    public void setPrint(HomePrint homePrint) {
        if (homePrint != this.print) {
            HomePrint homePrint2 = this.print;
            this.print = homePrint;
            this.propertyChangeSupport.firePropertyChange(Property.PRINT.name(), homePrint2, homePrint);
        }
        this.print = homePrint;
    }

    public Object getVisualProperty(String string) {
        return this.visualProperties.get(string);
    }

    public void setVisualProperty(String string, Object object) {
        this.visualProperties.put(string, object);
    }

    public boolean isBasePlanLocked() {
        return this.basePlanLocked;
    }

    public void setBasePlanLocked(boolean bl) {
        if (bl != this.basePlanLocked) {
            this.basePlanLocked = bl;
            this.propertyChangeSupport.firePropertyChange(Property.BASE_PLAN_LOCKED.name(), !bl, bl);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public Home clone() {
        try {
            int n;
            Home home = (Home)super.clone();
            home.selectedItems = new ArrayList<Selectable>(this.selectedItems.size());
            home.furniture = this.cloneSelectableItems(this.furniture, this.selectedItems, home.selectedItems);
            for (n = 0; n < this.furniture.size(); ++n) {
                HomePieceOfFurniture cloneable2 = this.furniture.get(n);
                if (!(cloneable2 instanceof HomeDoorOrWindow) || !((HomeDoorOrWindow)cloneable2).isBoundToWall()) continue;
                ((HomeDoorOrWindow)home.furniture.get(n)).setBoundToWall(true);
            }
            home.rooms = this.cloneSelectableItems(this.rooms, this.selectedItems, home.selectedItems);
            home.dimensionLines = this.cloneSelectableItems(this.dimensionLines, this.selectedItems, home.selectedItems);
            home.labels = this.cloneSelectableItems(this.labels, this.selectedItems, home.selectedItems);
            home.walls = Wall.clone(this.walls);
            for (n = 0; n < this.walls.size(); ++n) {
                Wall wall = this.walls.get(n);
                if (!this.selectedItems.contains(wall)) continue;
                home.selectedItems.add(home.walls.get(n));
            }
            home.levels = new ArrayList<Level>();
            if (this.levels.size() > 0) {
                for (Level level : this.levels) {
                    home.levels.add(level.clone());
                }
                for (n = 0; n < this.furniture.size(); ++n) {
                    Level level = this.furniture.get(n).getLevel();
                    if (level == null) continue;
                    home.furniture.get(n).setLevel(home.levels.get(this.levels.indexOf(level)));
                }
                for (n = 0; n < this.rooms.size(); ++n) {
                    Level level = this.rooms.get(n).getLevel();
                    if (level == null) continue;
                    home.rooms.get(n).setLevel(home.levels.get(this.levels.indexOf(level)));
                }
                for (n = 0; n < this.dimensionLines.size(); ++n) {
                    Level level = this.dimensionLines.get(n).getLevel();
                    if (level == null) continue;
                    home.dimensionLines.get(n).setLevel(home.levels.get(this.levels.indexOf(level)));
                }
                for (n = 0; n < this.labels.size(); ++n) {
                    Level level = this.labels.get(n).getLevel();
                    if (level == null) continue;
                    home.labels.get(n).setLevel(home.levels.get(this.levels.indexOf(level)));
                }
                for (n = 0; n < this.walls.size(); ++n) {
                    Level level = this.walls.get(n).getLevel();
                    if (level == null) continue;
                    home.walls.get(n).setLevel(home.levels.get(this.levels.indexOf(level)));
                }
                if (this.selectedLevel != null) {
                    home.selectedLevel = home.levels.get(this.levels.indexOf(this.selectedLevel));
                }
            }
            home.observerCamera = this.observerCamera.clone();
            home.topCamera = this.topCamera.clone();
            if (this.camera == this.observerCamera) {
                home.camera = home.observerCamera;
                if (this.selectedItems.contains(this.observerCamera)) {
                    home.selectedItems.add(home.observerCamera);
                }
            } else {
                home.camera = home.topCamera;
            }
            home.storedCameras = new ArrayList<Camera>(this.storedCameras.size());
            for (Camera camera : this.storedCameras) {
                home.storedCameras.add(camera.clone());
            }
            home.environment = this.environment.clone();
            home.compass = this.compass.clone();
            home.furnitureVisibleProperties = new ArrayList<HomePieceOfFurniture.SortableProperty>(this.furnitureVisibleProperties);
            home.visualProperties = new HashMap<String, Object>(this.visualProperties);
            home.furnitureChangeSupport = new CollectionChangeSupport(home);
            home.selectionListeners = new ArrayList<SelectionListener>();
            home.wallsChangeSupport = new CollectionChangeSupport(home);
            home.roomsChangeSupport = new CollectionChangeSupport(home);
            home.dimensionLinesChangeSupport = new CollectionChangeSupport(home);
            home.labelsChangeSupport = new CollectionChangeSupport(home);
            home.propertyChangeSupport = new PropertyChangeSupport(home);
            return home;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Super class isn't cloneable");
        }
    }

    private <T extends Selectable> List<T> cloneSelectableItems(List<T> list, List<Selectable> list2, List<Selectable> list3) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>(list.size());
        for (Selectable selectable : list) {
            Selectable selectable2 = selectable.clone();
            arrayList.add(selectable2);
            if (!list2.contains(selectable)) continue;
            list3.add(selectable2);
        }
        return arrayList;
    }

    public static List<Selectable> duplicate(List<? extends Selectable> list) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        for (Selectable selectable : list) {
            if (selectable instanceof Wall || selectable instanceof Camera || selectable instanceof Compass) continue;
            arrayList.add(selectable.clone());
        }
        arrayList.addAll(Wall.clone(Home.getWallsSubList(list)));
        return arrayList;
    }

    public static List<HomePieceOfFurniture> getFurnitureSubList(List<? extends Selectable> list) {
        return Home.getSubList(list, HomePieceOfFurniture.class);
    }

    public static List<Wall> getWallsSubList(List<? extends Selectable> list) {
        return Home.getSubList(list, Wall.class);
    }

    public static List<Room> getRoomsSubList(List<? extends Selectable> list) {
        return Home.getSubList(list, Room.class);
    }

    public static List<DimensionLine> getDimensionLinesSubList(List<? extends Selectable> list) {
        return Home.getSubList(list, DimensionLine.class);
    }

    public static List<Label> getLabelsSubList(List<? extends Selectable> list) {
        return Home.getSubList(list, Label.class);
    }

    public static <T> List<T> getSubList(List<? extends Selectable> list, Class<T> clazz) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        for (Selectable selectable : list) {
            if (!clazz.isInstance(selectable)) continue;
            arrayList.add(selectable);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        NAME,
        MODIFIED,
        FURNITURE_SORTED_PROPERTY,
        FURNITURE_DESCENDING_SORTED,
        FURNITURE_VISIBLE_PROPERTIES,
        BACKGROUND_IMAGE,
        CAMERA,
        PRINT,
        BASE_PLAN_LOCKED,
        STORED_CAMERAS,
        RECOVERED,
        SELECTED_LEVEL;

    }
}

