/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCAbstractQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCQueryManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.QLCompiler;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQlQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;

public final class JDBCEJBQLQuery
extends JDBCAbstractQueryCommand {
    public JDBCEJBQLQuery(JDBCStoreManager manager, JDBCQueryMetaData q) throws DeploymentException {
        super(manager, q);
        JDBCQlQueryMetaData metadata = (JDBCQlQueryMetaData)q;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("EJB-QL: " + metadata.getEjbQl()));
        }
        QLCompiler compiler = JDBCQueryManager.getInstance(metadata.getQLCompilerClass(), manager.getCatalog());
        try {
            compiler.compileEJBQL(metadata.getEjbQl(), metadata.getMethod().getReturnType(), metadata.getMethod().getParameterTypes(), metadata);
        }
        catch (Throwable t) {
            this.log.error((Object)t.getMessage(), t);
            throw new DeploymentException("Error compiling EJB-QL statement for EJB '" + manager.getContainer().getBeanMetaData().getEjbName() + "': " + metadata.getEjbQl(), t);
        }
        this.setSQL(compiler.getSQL());
        if (compiler.isSelectEntity()) {
            JDBCEntityBridge selectEntity = (JDBCEntityBridge)compiler.getSelectEntity();
            this.setSelectEntity(selectEntity);
            JDBCReadAheadMetaData readahead = metadata.getReadAhead();
            if (readahead.isOnFind()) {
                this.setEagerLoadGroup(readahead.getEagerLoadGroup());
                this.setOnFindCMRList(compiler.getLeftJoinCMRList());
                if (compiler.isSelectDistinct()) {
                    boolean[] mask = this.getEagerLoadMask();
                    JDBCFieldBridge[] tableFields = selectEntity.getTableFields();
                    for (int i = 0; i < tableFields.length; ++i) {
                        if (!mask[i] || tableFields[i].getJDBCType().isSearchable()) continue;
                        mask[i] = false;
                    }
                }
            }
        } else if (compiler.isSelectField()) {
            this.setSelectField((JDBCCMPFieldBridge)compiler.getSelectField());
        } else {
            this.setSelectFunction(compiler.getSelectFunction(), manager);
        }
        this.setParameterList(compiler.getInputParameters());
    }
}

